/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import tel.schich.javacan.CanFilter;
import tel.schich.javacan.CanId;

public class IsotpAddress {
    public static final int DESTINATION_ECU_1 = 0;
    public static final int DESTINATION_ECU_2 = 1;
    public static final int DESTINATION_ECU_3 = 2;
    public static final int DESTINATION_ECU_4 = 3;
    public static final int DESTINATION_ECU_5 = 4;
    public static final int DESTINATION_ECU_6 = 5;
    public static final int DESTINATION_ECU_7 = 6;
    public static final int DESTINATION_EFF_FUNCTIONAL = 51;
    public static final int DESTINATION_EFF_TEST_EQUIPMENT = 241;
    public static final int EFF_TYPE_PHYSICAL_ADDRESSING = 218;
    public static final int EFF_TYPE_FUNCTIONAL_ADDRESSING = 219;
    public static final int EFF_MASK_FUNCTIONAL_RESPONSE = -65281;
    public static final int SFF_ECU_REQUEST_BASE = 2016;
    public static final int SFF_ECU_RESPONSE_BASE = 2024;
    public static final int SFF_FUNCTIONAL_ADDRESS = 2015;
    public static final int SFF_MASK_FUNCTIONAL_RESPONSE = 2040;
    public static final CanFilter SFF_FUNCTIONAL_FILTER = new CanFilter(2024, 2040);

    public static int effAddress(int priority, int type, int sender, int receiver) {
        return ((priority & 0xFF) << 24 | (type & 0xFF) << 16 | (sender & 0xFF) << 8 | receiver & 0xFF) & 0x1FFFFFFF | Integer.MIN_VALUE;
    }

    public static int returnAddress(int addr) {
        if (CanId.isExtended(addr)) {
            return IsotpAddress.effReturnAddress(addr);
        }
        return IsotpAddress.sffReturnAddress(addr);
    }

    private static int effReturnAddress(int addr) {
        int[] components = IsotpAddress.decomposeEffAddress(addr);
        return IsotpAddress.effReturnAddress(components[0], components[1], components[2], components[3]);
    }

    private static int effReturnAddress(int priority, int type, int sender, int receiver) {
        return IsotpAddress.effAddress(priority, type, receiver, sender);
    }

    private static int sffReturnAddress(int addr) {
        int returnAddr = (addr & 8) > 0 ? addr - 8 : addr + 8;
        return returnAddr;
    }

    private static boolean isEffAddressFunctional(int addr) {
        int[] components = IsotpAddress.decomposeEffAddress(addr);
        return IsotpAddress.isEffAddressFunctional(components[1], components[3]);
    }

    private static boolean isEffAddressFunctional(int type, int receiver) {
        return type == 219 && receiver == 51;
    }

    private static boolean isSffAddressFunctional(int addr) {
        return addr == 2015;
    }

    public static boolean isFunctional(int addr) {
        if (CanId.isExtended(addr)) {
            return IsotpAddress.isEffAddressFunctional(addr);
        }
        return IsotpAddress.isSffAddressFunctional(addr);
    }

    public static CanFilter filterFromDestination(int addr) {
        if (CanId.isExtended(addr)) {
            int[] components = IsotpAddress.decomposeEffAddress(addr);
            int priority = components[0];
            int type = components[1];
            int sender = components[2];
            int receiver = components[3];
            if (IsotpAddress.isEffAddressFunctional(type, receiver)) {
                return new CanFilter(IsotpAddress.effAddress(priority, 218, 0, sender), -65281);
            }
            return new CanFilter(IsotpAddress.effReturnAddress(priority, type, sender, receiver));
        }
        if (IsotpAddress.isSffAddressFunctional(addr)) {
            return SFF_FUNCTIONAL_FILTER;
        }
        return new CanFilter(IsotpAddress.sffReturnAddress(addr));
    }

    public static int[] decomposeEffAddress(int effAddr) {
        int prio = effAddr >>> 24;
        int type = effAddr >>> 16 & 0xFF;
        int from = effAddr >>> 8 & 0xFF;
        int to = effAddr & 0xFF;
        return new int[]{prio, type, from, to};
    }
}

