/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.devexperts.logging.Logging;
import com.rusefi.UiProperties;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.RusEfiSignature;
import com.rusefi.core.SignatureHelper;
import com.rusefi.core.io.BundleUtil;
import com.rusefi.io.IoStream;
import com.rusefi.io.UpdateOperationCallbacks;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class BootloaderHelper {
    private static final Logging log = Logging.getLogging(BootloaderHelper.class);

    private static void sendBootloaderRebootCommand(IoStream stream, UpdateOperationCallbacks callbacks, String cmd) {
        byte[] command = BinaryProtocol.getTextCommandBytes(cmd);
        try {
            stream.sendPacket(command);
            callbacks.logLine(String.format("Reboot command [%s] sent into %s!\n", cmd, stream));
        }
        catch (IOException e) {
            callbacks.logLine("Error " + e);
        }
    }

    public static boolean sendBootloaderRebootCommand(JComponent parent, String signature, IoStream stream, UpdateOperationCallbacks callbacks, String command) {
        RusEfiSignature controllerSignature = SignatureHelper.parse(signature);
        String fileSystemBundleTarget = BundleUtil.getBundleTarget();
        if (!(fileSystemBundleTarget == null || controllerSignature == null || UiProperties.skipEcuTypeDetection() || fileSystemBundleTarget.equalsIgnoreCase(controllerSignature.getBundleTarget()) || fileSystemBundleTarget.contains("_QC_"))) {
            String message = String.format("You have \"%s\" controller does not look right to program it with \"%s\"", controllerSignature.getBundleTarget(), fileSystemBundleTarget);
            log.info(message);
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(parent, message);
                new Thread(() -> {
                    BinaryProtocol.sleep(5000L);
                    System.exit(-5);
                }).start();
            });
            return false;
        }
        BootloaderHelper.sendBootloaderRebootCommand(stream, callbacks, command);
        return true;
    }
}

