/*
 * Decompiled with CFR 0.152.
 */
import com.rusefi.SerialPortScanner;
import com.rusefi.maintenance.jobs.AsyncJobExecutor;
import com.rusefi.maintenance.jobs.OpenBltManualJob;
import com.rusefi.ui.StatusWindow;
import com.rusefi.ui.widgets.ToolButtons;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;

public class MassUpdater {
    private final StatusWindow mainStatus = new StatusWindow();
    private final Set<String> knownBlts = new HashSet<String>();

    public MassUpdater() {
        this.mainStatus.showFrame("Mass Updater");
        SerialPortScanner.INSTANCE.addListener(currentHardware -> {
            List currentBltList = currentHardware.getKnownPorts().stream().filter(portResult -> portResult.type == SerialPortScanner.SerialPortType.OpenBlt).collect(Collectors.toList());
            Set currentSet = currentBltList.stream().map(portResult -> portResult.port).collect(Collectors.toSet());
            Iterator<String> it = this.knownBlts.iterator();
            while (it.hasNext()) {
                String port = it.next();
                if (currentSet.contains(port)) continue;
                this.mainStatus.append(port + ": No longer present");
                it.remove();
            }
            for (SerialPortScanner.PortResult openBltPort : currentBltList) {
                if (this.knownBlts.contains(openBltPort.port)) continue;
                this.knownBlts.add(openBltPort.port);
                this.mainStatus.append("New OpenBlt " + openBltPort);
                SwingUtilities.invokeLater(() -> AsyncJobExecutor.INSTANCE.executeJob(new OpenBltManualJob(openBltPort, this.mainStatus.getContent())));
            }
        });
    }

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        ToolButtons.showDeviceManager();
        SwingUtilities.invokeAndWait(MassUpdater::new);
    }
}

