/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.CustomLedColor;
import eu.hansolo.steelseries.tools.ForegroundType;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.FrameEffect;
import eu.hansolo.steelseries.tools.FrameType;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.KnobStyle;
import eu.hansolo.steelseries.tools.KnobType;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.NumberFormat;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.PointerType;
import eu.hansolo.steelseries.tools.Section;
import eu.hansolo.steelseries.tools.ThresholdType;
import eu.hansolo.steelseries.tools.TicklabelOrientation;
import eu.hansolo.steelseries.tools.TickmarkType;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class Model
implements Cloneable {
    private static final int BASE = 10;
    private final EventListenerList LISTENER_LIST = new EventListenerList();
    private final Font STANDARD_BASE_FONT = new Font("Verdana", 0, 24);
    private final Font STANDARD_INFO_FONT = new Font("Verdana", 0, 24);
    private final Font DIGITAL_BASE_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24);
    private ChangeEvent changeEvent;
    private Rectangle bounds;
    private double minValue;
    private double maxValue;
    private double range;
    private double value;
    private double oldValue;
    private double redrawTolerance;
    private double redrawFactor;
    private double peakValue;
    private boolean peakValueVisible;
    private double lcdValue;
    private double lcdThreshold;
    private boolean lcdThresholdVisible;
    private boolean lcdThresholdBehaviourInverted;
    private boolean lcdBlinking;
    private boolean singleLedBargraphEnabled;
    private boolean autoResetToZero;
    private boolean frameVisible;
    private FrameEffect frameEffect;
    private Color frameBaseColor;
    private boolean frameBaseColorEnabled;
    private boolean backgroundVisible;
    private boolean titleVisible;
    private boolean unitVisible;
    private boolean customTitleAndUnitFontEnabled;
    private boolean customLayerVisible;
    private boolean ledVisible;
    private boolean userLedVisible;
    private boolean lcdVisible;
    private boolean lcdUnitStringVisible;
    private boolean lcdScientificFormatEnabled;
    private boolean valueCoupled;
    private boolean digitalFontEnabled;
    private boolean customLcdUnitFontEnabled;
    private NumberSystem numberSystem;
    private boolean foregroundVisible;
    private boolean tickmarksVisible;
    private boolean ticklabelsVisible;
    private boolean minorTickmarksVisible;
    private boolean majorTickmarksVisible;
    private boolean sectionTickmarksOnly;
    private boolean tickmarkColorFromThemeEnabled;
    private boolean labelColorFromThemeEnabled;
    private TicklabelOrientation ticklabelOrientation;
    private double threshold;
    private boolean thresholdVisible;
    private ColorDef thresholdColor;
    private CustomColorDef customThresholdColor;
    private ThresholdType thresholdType;
    private boolean thresholdBehaviourInverted;
    private double minMeasuredValue;
    private boolean minMeasuredValueVisible;
    private double maxMeasuredValue;
    private boolean maxMeasuredValueVisible;
    private boolean rangeOfMeasuredValuesVisible;
    private Shape radialShapeOfMeasuredValues;
    private boolean collectingData;
    private double trackStart;
    private double trackSection;
    private double trackStop;
    private boolean trackVisible;
    private ArrayList<Section> sections = new ArrayList(10);
    private boolean sectionsVisible;
    private boolean highlightSection;
    private ArrayList<Section> areas = new ArrayList(10);
    private boolean areasVisible;
    private boolean highlightArea;
    private ArrayList<Section> tickmarkSections = new ArrayList(10);
    private boolean tickmarkSectionsVisible;
    private GaugeType gaugeType;
    private double angleStep;
    private double logAngleStep;
    private boolean niceScale;
    private boolean logScale;
    private double niceRange;
    private int maxNoOfMajorTicks;
    private int maxNoOfMinorTicks;
    private double majorTickSpacing;
    private double minorTickSpacing;
    private double niceMinValue;
    private double niceMaxValue;
    private BackgroundColor backgroundColor;
    private Paint customBackground;
    private Color textureColor;
    private BufferedImage customLayer;
    private boolean glowVisible;
    private Color glowColor;
    private boolean glowing;
    private FrameType frameType;
    private FrameDesign frameDesign;
    private Paint customFrameDesign;
    private Paint outerFrameColor;
    private Paint innerFrameColor;
    private LedColor ledColor;
    private CustomLedColor customLedColor;
    private LedColor userLedColor;
    private CustomLedColor customUserLedColor;
    private LcdColor lcdColor;
    private Paint customLcdColor;
    private Color customLcdForegroundColor;
    private boolean lcdBackgroundVisible;
    private TickmarkType minorTickmarkType;
    private TickmarkType majorTickmarkType;
    private NumberFormat labelNumberFormat;
    private Color tickmarkColor;
    private Color customTickmarkColor;
    private Color labelColor;
    private Color trackStartColor;
    private Color trackSectionColor;
    private Color trackStopColor;
    private PointerType pointerType;
    private ColorDef pointerColor;
    private boolean pointerShadowVisible;
    private CustomColorDef customPointerColorObject;
    private ColorDef valueColor;
    private CustomColorDef customValueColorObject;
    private KnobType knobType;
    private KnobStyle knobStyle;
    private boolean postsVisible;
    private ForegroundType foregroundType;
    private Font lcdValueFont;
    private Font lcdUnitFont;
    private Font customLcdUnitFont;
    private Font lcdInfoFont;
    private int lcdDecimals;
    private Paint rangeOfMeasuredValuesPaint;

    public Model() {
        this.init();
    }

    private void init() {
        this.bounds = new Rectangle();
        this.minValue = 0.0;
        this.maxValue = 100.0;
        this.range = this.maxValue - this.minValue;
        this.value = this.minValue;
        this.oldValue = this.minValue;
        this.redrawTolerance = 0.0;
        this.redrawFactor = 0.0;
        this.peakValue = this.minValue;
        this.peakValueVisible = false;
        this.lcdValue = 0.0;
        this.lcdThreshold = 0.0;
        this.lcdThresholdVisible = false;
        this.lcdThresholdBehaviourInverted = false;
        this.lcdBlinking = false;
        this.autoResetToZero = false;
        this.frameVisible = true;
        this.frameEffect = FrameEffect.NONE;
        this.frameBaseColor = new Color(179, 179, 179, 255);
        this.frameBaseColorEnabled = false;
        this.backgroundVisible = true;
        this.titleVisible = true;
        this.unitVisible = true;
        this.customTitleAndUnitFontEnabled = false;
        this.customLayerVisible = false;
        this.ledVisible = true;
        this.lcdVisible = true;
        this.lcdUnitStringVisible = false;
        this.lcdScientificFormatEnabled = false;
        this.valueCoupled = true;
        this.digitalFontEnabled = false;
        this.customLcdUnitFontEnabled = false;
        this.numberSystem = NumberSystem.DEC;
        this.foregroundVisible = true;
        this.tickmarksVisible = true;
        this.ticklabelsVisible = true;
        this.minorTickmarksVisible = true;
        this.majorTickmarksVisible = true;
        this.sectionTickmarksOnly = false;
        this.tickmarkColorFromThemeEnabled = true;
        this.labelColorFromThemeEnabled = true;
        this.ticklabelOrientation = TicklabelOrientation.TANGENT;
        this.threshold = this.range / 2.0;
        this.thresholdVisible = false;
        this.thresholdColor = ColorDef.RED;
        this.customThresholdColor = new CustomColorDef(Color.RED);
        this.thresholdType = ThresholdType.TRIANGLE;
        this.thresholdBehaviourInverted = false;
        this.minMeasuredValue = this.maxValue;
        this.minMeasuredValueVisible = false;
        this.maxMeasuredValue = this.minValue;
        this.maxMeasuredValueVisible = false;
        this.rangeOfMeasuredValuesVisible = false;
        this.radialShapeOfMeasuredValues = new Arc2D.Double();
        this.collectingData = false;
        this.trackStart = this.minValue;
        this.trackSection = this.range / 2.0;
        this.trackStop = this.maxValue;
        this.trackVisible = false;
        this.sections.clear();
        this.sectionsVisible = false;
        this.highlightSection = false;
        this.areas.clear();
        this.areasVisible = false;
        this.highlightArea = false;
        this.tickmarkSections.clear();
        this.tickmarkSectionsVisible = false;
        this.gaugeType = GaugeType.TYPE4;
        this.angleStep = this.gaugeType.ANGLE_RANGE / this.range;
        this.logAngleStep = this.gaugeType.ANGLE_RANGE / (Util.INSTANCE.logOfBase(10.0, this.range) - 1.0) * 9.0 + 10.0;
        this.niceScale = true;
        this.logScale = false;
        this.maxNoOfMajorTicks = 10;
        this.maxNoOfMinorTicks = 10;
        this.backgroundColor = BackgroundColor.DARK_GRAY;
        this.customBackground = Color.RED;
        this.textureColor = new Color(0x686868);
        this.customLayer = null;
        this.glowVisible = false;
        this.glowColor = new Color(51, 255, 255);
        this.glowing = false;
        this.frameType = FrameType.ROUND;
        this.frameDesign = FrameDesign.METAL;
        this.outerFrameColor = new Color(0x848484);
        this.innerFrameColor = new Color(0.6f, 0.6f, 0.6f, 0.8f);
        this.customFrameDesign = Color.RED;
        this.ledColor = LedColor.RED_LED;
        this.customLedColor = new CustomLedColor(Color.RED);
        this.userLedColor = LedColor.RED_LED;
        this.customUserLedColor = new CustomLedColor(Color.RED);
        this.lcdColor = LcdColor.WHITE_LCD;
        this.customLcdColor = Color.RED;
        this.lcdBackgroundVisible = true;
        this.customLcdForegroundColor = Color.BLACK;
        this.minorTickmarkType = TickmarkType.LINE;
        this.majorTickmarkType = TickmarkType.LINE;
        this.labelNumberFormat = NumberFormat.AUTO;
        this.tickmarkColor = this.backgroundColor.LABEL_COLOR;
        this.customTickmarkColor = Color.BLACK;
        this.labelColor = this.backgroundColor.LABEL_COLOR;
        this.trackStartColor = new Color(0.0f, 1.0f, 0.0f, 0.35f);
        this.trackSectionColor = new Color(1.0f, 1.0f, 0.0f, 0.35f);
        this.trackStopColor = new Color(1.0f, 0.0f, 0.0f, 0.35f);
        this.pointerType = PointerType.TYPE1;
        this.pointerColor = ColorDef.RED;
        this.pointerShadowVisible = true;
        this.customPointerColorObject = new CustomColorDef(Color.RED);
        this.valueColor = ColorDef.RED;
        this.customValueColorObject = new CustomColorDef(Color.RED);
        this.knobType = KnobType.SMALL_STD_KNOB;
        this.knobStyle = KnobStyle.SILVER;
        this.postsVisible = true;
        this.foregroundType = ForegroundType.FG_TYPE1;
        this.customLcdUnitFont = new Font("Verdana", 1, 24);
        this.lcdInfoFont = new Font("Verdana", 0, 24);
        this.rangeOfMeasuredValuesPaint = new Color(1.0f, 0.0f, 0.0f, 0.1f);
        this.calculate();
    }

    public Rectangle getSize() {
        return this.bounds;
    }

    public void setSize(int X, int Y, int WIDTH, int HEIGHT) {
        this.bounds.setBounds(X, Y, WIDTH, HEIGHT);
        this.fireStateChanged();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double MIN_VALUE) {
        if (Double.compare(MIN_VALUE, this.maxValue) == 0) {
            throw new IllegalArgumentException("Min value cannot be equal to max value");
        }
        if (Double.compare(MIN_VALUE, this.maxValue) > 0) {
            this.minValue = this.maxValue;
            this.maxValue = MIN_VALUE;
        } else {
            this.minValue = MIN_VALUE;
        }
        this.calculate();
        this.validate();
        this.calcAngleStep();
        this.fireStateChanged();
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double MAX_VALUE) {
        if (Double.compare(MAX_VALUE, this.minValue) == 0) {
            throw new IllegalArgumentException("Max value cannot be equal to min value");
        }
        if (Double.compare(MAX_VALUE, this.minValue) < 0) {
            this.maxValue = this.minValue;
            this.minValue = MAX_VALUE;
        } else {
            this.maxValue = MAX_VALUE;
        }
        this.calculate();
        this.validate();
        this.calcAngleStep();
        this.fireStateChanged();
    }

    public double getRange() {
        return this.maxValue - this.minValue;
    }

    public void setRange(double MIN_VALUE, double MAX_VALUE) {
        this.maxValue = MAX_VALUE;
        this.minValue = MIN_VALUE;
        this.calculate();
        this.validate();
        this.calcAngleStep();
        this.fireStateChanged();
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double VALUE) {
        this.oldValue = this.value;
        this.value = VALUE < this.niceMinValue ? this.niceMinValue : (VALUE > this.niceMaxValue ? this.niceMaxValue : VALUE);
        this.fireStateChanged();
    }

    public double getOldValue() {
        return this.oldValue;
    }

    public double getRedrawTolerance() {
        return this.redrawTolerance;
    }

    public void setRedrawTolerance(double REDRAW_TOLERANCE) {
        this.redrawTolerance = REDRAW_TOLERANCE < 0.0 ? 0.0 : (REDRAW_TOLERANCE > 1.0 ? 1.0 : REDRAW_TOLERANCE);
        this.redrawFactor = this.redrawTolerance * this.getRange();
        this.fireStateChanged();
    }

    public double getRedrawFactor() {
        return this.redrawFactor;
    }

    public double getPeakValue() {
        return this.peakValue;
    }

    public void setPeakValue(double PEAK_VALUE) {
        this.peakValue = PEAK_VALUE;
        this.fireStateChanged();
    }

    public boolean isPeakValueVisible() {
        return this.peakValueVisible;
    }

    public void setPeakValueVisible(boolean PEAK_VALUE_VISIBLE) {
        this.peakValueVisible = PEAK_VALUE_VISIBLE;
        this.fireStateChanged();
    }

    public double getLcdValue() {
        return this.lcdValue;
    }

    public void setLcdValue(double LCD_VALUE) {
        this.lcdValue = LCD_VALUE;
        this.fireStateChanged();
    }

    public double getLcdThreshold() {
        return this.lcdThreshold;
    }

    public void setLcdThreshold(double LCD_THRESHOLD) {
        this.lcdThreshold = LCD_THRESHOLD;
        this.fireStateChanged();
    }

    public boolean isLcdThresholdVisible() {
        return this.lcdThresholdVisible;
    }

    public void setLcdThresholdVisible(boolean LCD_THRESHOLD_VISIBLE) {
        this.lcdThresholdVisible = LCD_THRESHOLD_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isLcdThresholdBehaviourInverted() {
        return this.lcdThresholdBehaviourInverted;
    }

    public void setLcdThresholdBehaviourInverted(boolean LCD_THRESHOLD_BEHAVIOUR_INVERTED) {
        this.lcdThresholdBehaviourInverted = LCD_THRESHOLD_BEHAVIOUR_INVERTED;
        this.fireStateChanged();
    }

    public boolean isLcdBlinking() {
        return this.lcdBlinking;
    }

    public void setLcdBlinking(boolean LCD_BLINKING) {
        this.lcdBlinking = LCD_BLINKING;
        this.fireStateChanged();
    }

    public boolean isSingleLedBargraphEnabled() {
        return this.singleLedBargraphEnabled;
    }

    public void setSingleLedBargraphEnabled(boolean SINGLE_LED_BARGRAPH_ENABLED) {
        this.singleLedBargraphEnabled = SINGLE_LED_BARGRAPH_ENABLED;
        this.fireStateChanged();
    }

    public boolean isAutoResetToZero() {
        return this.autoResetToZero;
    }

    public void setAutoResetToZero(boolean AUTO_RESET_TO_ZERO) {
        this.autoResetToZero = this.niceMinValue > 0.0 || this.niceMaxValue < 0.0 ? false : AUTO_RESET_TO_ZERO;
        this.fireStateChanged();
    }

    public boolean isFrameVisible() {
        return this.frameVisible;
    }

    public void setFrameVisible(boolean FRAME_VISIBLE) {
        this.frameVisible = FRAME_VISIBLE;
        this.fireStateChanged();
    }

    public FrameEffect getFrameEffect() {
        return this.frameEffect;
    }

    public void setFrameEffect(FrameEffect FRAME_EFFECT) {
        this.frameEffect = FRAME_EFFECT;
        this.fireStateChanged();
    }

    public Color getFrameBaseColor() {
        return this.frameBaseColor;
    }

    public void setFrameBaseColor(Color FRAME_BASECOLOR) {
        this.frameBaseColor = FRAME_BASECOLOR;
        this.fireStateChanged();
    }

    public boolean isFrameBaseColorEnabled() {
        return this.frameBaseColorEnabled;
    }

    public void setFrameBaseColorEnabled(boolean FRAME_BASECOLOR_ENABLED) {
        this.frameBaseColorEnabled = FRAME_BASECOLOR_ENABLED;
        this.fireStateChanged();
    }

    public boolean isBackgroundVisible() {
        return this.backgroundVisible;
    }

    public void setBackgroundVisible(boolean BACKGROUND_VISIBLE) {
        this.backgroundVisible = BACKGROUND_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    public void setTitleVisible(boolean TITLE_VISIBLE) {
        this.titleVisible = TITLE_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean UNIT_VISIBLE) {
        this.unitVisible = UNIT_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isCustomTitleAndUnitFontEnabled() {
        return this.customTitleAndUnitFontEnabled;
    }

    public void setCustomTitleAndUnitFontEnabled(boolean CUSTOM_TITLE_AND_UNIT_FONT_ENABLED) {
        this.customTitleAndUnitFontEnabled = CUSTOM_TITLE_AND_UNIT_FONT_ENABLED;
        this.fireStateChanged();
    }

    public boolean isCustomLayerVisible() {
        return this.customLayerVisible;
    }

    public void setCustomLayerVisible(boolean CUSTOM_LAYER_VISIBLE) {
        this.customLayerVisible = CUSTOM_LAYER_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isLedVisible() {
        return this.ledVisible;
    }

    public void setLedVisible(boolean LED_VISIBLE) {
        this.ledVisible = LED_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isUserLedVisible() {
        return this.userLedVisible;
    }

    public void setUserLedVisible(boolean USER_LED_VISIBLE) {
        this.userLedVisible = USER_LED_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isLcdVisible() {
        return this.lcdVisible;
    }

    public void setLcdVisible(boolean LCD_VISIBLE) {
        this.lcdVisible = LCD_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isLcdUnitStringVisible() {
        return this.lcdUnitStringVisible;
    }

    public void setLcdUnitStringVisible(boolean LCD_UNIT_STRING_VISIBLE) {
        this.lcdUnitStringVisible = LCD_UNIT_STRING_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isLcdScientificFormatEnabled() {
        return this.lcdScientificFormatEnabled;
    }

    public void setLcdScientificFormatEnabled(boolean LCD_SCIENTIFIC_FORMAT_ENABLED) {
        this.lcdScientificFormatEnabled = LCD_SCIENTIFIC_FORMAT_ENABLED;
        this.fireStateChanged();
    }

    public boolean isValueCoupled() {
        return this.valueCoupled;
    }

    public void setValueCoupled(boolean VALUE_COUPLED) {
        this.valueCoupled = VALUE_COUPLED;
        this.fireStateChanged();
    }

    public boolean isDigitalFontEnabled() {
        return this.digitalFontEnabled;
    }

    public void setDigitalFontEnabled(boolean DIGITAL_FONT_ENABLED) {
        this.digitalFontEnabled = DIGITAL_FONT_ENABLED;
        this.fireStateChanged();
    }

    public boolean isCustomLcdUnitFontEnabled() {
        return this.customLcdUnitFontEnabled;
    }

    public void setCustomLcdUnitFontEnabled(boolean CUSTOM_LCD_UNIT_FONT_ENABLED) {
        this.customLcdUnitFontEnabled = CUSTOM_LCD_UNIT_FONT_ENABLED;
        this.fireStateChanged();
    }

    public NumberSystem getNumberSystem() {
        return this.numberSystem;
    }

    public void setNumberSystem(NumberSystem NUMBER_SYSTEM) {
        this.numberSystem = NUMBER_SYSTEM;
        this.fireStateChanged();
    }

    public boolean isForegroundVisible() {
        return this.foregroundVisible;
    }

    public void setForegroundVisible(boolean FOREGROUND_VISIBLE) {
        this.foregroundVisible = FOREGROUND_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isMinorTickmarksVisible() {
        return this.minorTickmarksVisible;
    }

    public void setMinorTickmarksVisible(boolean MINOR_TICKMARKS_VISIBLE) {
        this.minorTickmarksVisible = MINOR_TICKMARKS_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isMajorTickmarksVisible() {
        return this.majorTickmarksVisible;
    }

    public void setMajorTickmarksVisible(boolean MAJOR_TICKMARKS_VISIBLE) {
        this.majorTickmarksVisible = MAJOR_TICKMARKS_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isSectionTickmarksOnly() {
        return this.sectionTickmarksOnly;
    }

    public void setSectionTickmarksOnly(boolean SECTION_TICKMARKS_ONLY) {
        this.sectionTickmarksOnly = SECTION_TICKMARKS_ONLY;
        this.fireStateChanged();
    }

    public boolean isTickmarkColorFromThemeEnabled() {
        return this.tickmarkColorFromThemeEnabled;
    }

    public void setTickmarkColorFromThemeEnabled(boolean TICKMARK_COLOR_FROM_THEME_ENABLED) {
        this.tickmarkColorFromThemeEnabled = TICKMARK_COLOR_FROM_THEME_ENABLED;
        this.fireStateChanged();
    }

    public boolean isLabelColorFromThemeEnabled() {
        return this.labelColorFromThemeEnabled;
    }

    public void setLabelColorFromThemeEnabled(boolean LABEL_COLOR_FROM_THEME_ENABLED) {
        this.labelColorFromThemeEnabled = LABEL_COLOR_FROM_THEME_ENABLED;
        this.fireStateChanged();
    }

    public TicklabelOrientation getTicklabelOrientation() {
        return this.ticklabelOrientation;
    }

    public void setTicklabelOrienatation(TicklabelOrientation TICKLABEL_ORIENTATION) {
        this.ticklabelOrientation = TICKLABEL_ORIENTATION;
        this.fireStateChanged();
    }

    public boolean isTickmarksVisible() {
        return this.tickmarksVisible;
    }

    public void setTickmarksVisible(boolean TICKMARKS_VISIBLE) {
        this.tickmarksVisible = TICKMARKS_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isTicklabelsVisible() {
        return this.ticklabelsVisible;
    }

    public void setTicklabelsVisible(boolean TICKLABELS_VISIBLE) {
        this.ticklabelsVisible = TICKLABELS_VISIBLE;
        this.fireStateChanged();
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double THRESHOLD) {
        if (Double.compare(THRESHOLD, this.minValue) >= 0 && Double.compare(THRESHOLD, this.maxValue) <= 0) {
            this.threshold = THRESHOLD;
        } else {
            if (THRESHOLD < this.niceMinValue) {
                this.threshold = this.niceMinValue;
            }
            if (THRESHOLD > this.niceMaxValue) {
                this.threshold = this.niceMaxValue;
            }
        }
        this.fireStateChanged();
    }

    public boolean isThresholdVisible() {
        return this.thresholdVisible;
    }

    public void setThresholdVisible(boolean THRESHOLD_VISIBLE) {
        this.thresholdVisible = THRESHOLD_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isThresholdBehaviourInverted() {
        return this.thresholdBehaviourInverted;
    }

    public void setThresholdBehaviourInverted(boolean THRESHOLD_BEHAVIOUR_INVERTED) {
        this.thresholdBehaviourInverted = THRESHOLD_BEHAVIOUR_INVERTED;
        this.fireStateChanged();
    }

    public ColorDef getThresholdColor() {
        return this.thresholdColor;
    }

    public void setThresholdColor(ColorDef THRESHOLD_COLOR) {
        this.thresholdColor = THRESHOLD_COLOR;
        this.fireStateChanged();
    }

    public CustomColorDef getCustomThresholdColor() {
        return this.customThresholdColor;
    }

    public void setCustomThresholdColor(CustomColorDef CUSTOM_THRESHOLD_COLOR) {
        this.customThresholdColor = CUSTOM_THRESHOLD_COLOR;
        this.fireStateChanged();
    }

    public ThresholdType getThresholdType() {
        return this.thresholdType;
    }

    public void setThresholdType(ThresholdType THRESHOLD_TYPE) {
        this.thresholdType = THRESHOLD_TYPE;
        this.fireStateChanged();
    }

    public double getMinMeasuredValue() {
        return this.minMeasuredValue;
    }

    public void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        if (Double.compare(MIN_MEASURED_VALUE, this.niceMinValue) >= 0 && Double.compare(MIN_MEASURED_VALUE, this.niceMaxValue) <= 0) {
            this.minMeasuredValue = MIN_MEASURED_VALUE;
        } else {
            if (MIN_MEASURED_VALUE < this.niceMinValue) {
                this.minMeasuredValue = this.niceMinValue;
            }
            if (MIN_MEASURED_VALUE > this.niceMaxValue) {
                this.minMeasuredValue = this.niceMaxValue;
            }
        }
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public void resetMinMeasuredValue() {
        this.minMeasuredValue = this.value;
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public void resetMinMeasuredValue(double MIN_MEASURED_VALUE) {
        this.minMeasuredValue = MIN_MEASURED_VALUE < this.niceMinValue ? this.niceMinValue : (MIN_MEASURED_VALUE > this.niceMaxValue ? this.niceMaxValue : MIN_MEASURED_VALUE);
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public boolean isMinMeasuredValueVisible() {
        return this.minMeasuredValueVisible;
    }

    public void setMinMeasuredValueVisible(boolean MIN_MEASURED_VALUE_VISIBLE) {
        this.minMeasuredValueVisible = MIN_MEASURED_VALUE_VISIBLE;
        this.fireStateChanged();
    }

    public double getMaxMeasuredValue() {
        return this.maxMeasuredValue;
    }

    public void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        if (Double.compare(MAX_MEASURED_VALUE, this.niceMinValue) >= 0 && Double.compare(MAX_MEASURED_VALUE, this.niceMaxValue) <= 0) {
            this.maxMeasuredValue = MAX_MEASURED_VALUE;
        } else {
            if (MAX_MEASURED_VALUE < this.niceMinValue) {
                this.maxMeasuredValue = this.niceMinValue;
            }
            if (MAX_MEASURED_VALUE > this.niceMaxValue) {
                this.maxMeasuredValue = this.niceMaxValue;
            }
        }
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public void resetMaxMeasuredValue() {
        this.maxMeasuredValue = this.value;
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public void resetMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        this.maxMeasuredValue = MAX_MEASURED_VALUE < this.niceMinValue ? this.niceMinValue : (MAX_MEASURED_VALUE > this.niceMaxValue ? this.niceMaxValue : MAX_MEASURED_VALUE);
        this.createRadialShapeOfMeasureValuesArea();
        this.fireStateChanged();
    }

    public boolean isMaxMeasuredValueVisible() {
        return this.maxMeasuredValueVisible;
    }

    public void setMaxMeasuredValueVisible(boolean MAX_MEASURED_VALUE_VISIBLE) {
        this.maxMeasuredValueVisible = MAX_MEASURED_VALUE_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isRangeOfMeasuredValuesVisible() {
        return this.rangeOfMeasuredValuesVisible;
    }

    public void setRangeOfMeasuredValuesVisible(boolean RANGE_OF_MEASURED_VALUES_VISIBLE) {
        this.rangeOfMeasuredValuesVisible = RANGE_OF_MEASURED_VALUES_VISIBLE;
        this.fireStateChanged();
    }

    public Paint getRangeOfMeasuredValuesPaint() {
        return this.rangeOfMeasuredValuesPaint;
    }

    public Shape getRadialShapeOfMeasuredValues() {
        return this.radialShapeOfMeasuredValues;
    }

    public Area getRadialAreaOfMeasuredValues() {
        return new Area(this.radialShapeOfMeasuredValues);
    }

    public void setRangeOfMeasuredValuesPaint(Paint RANGE_OF_MEASURED_VALUES_PAINT) {
        this.rangeOfMeasuredValuesPaint = RANGE_OF_MEASURED_VALUES_PAINT;
        this.fireStateChanged();
    }

    public boolean isCollectingData() {
        return this.collectingData;
    }

    public void setCollectingData(boolean COLLECTING_DATA) {
        this.collectingData = COLLECTING_DATA;
    }

    public double getTrackStart() {
        return this.trackStart;
    }

    public void setTrackStart(double TRACK_START) {
        if (Double.compare(TRACK_START, this.trackStop) == 0) {
            throw new IllegalArgumentException("Track start value cannot equal track stop value");
        }
        this.trackStart = TRACK_START;
        this.validate();
        this.fireStateChanged();
    }

    public double getTrackSection() {
        return this.trackSection;
    }

    public void setTrackSection(double TRACK_SECTION) {
        this.trackSection = TRACK_SECTION;
        this.validate();
        this.fireStateChanged();
    }

    public double getTrackStop() {
        return this.trackStop;
    }

    public void setTrackStop(double TRACK_STOP) {
        if (Double.compare(this.trackStart, TRACK_STOP) == 0) {
            throw new IllegalArgumentException("Track stop value cannot equal track start value");
        }
        this.trackStop = TRACK_STOP;
        this.validate();
        this.fireStateChanged();
    }

    public boolean isTrackVisible() {
        return this.trackVisible;
    }

    public void setTrackVisible(boolean TRACK_VISIBLE) {
        this.trackVisible = TRACK_VISIBLE;
        this.fireStateChanged();
    }

    public List<Section> getSections() {
        ArrayList<Section> sectionsCopy = new ArrayList<Section>(10);
        sectionsCopy.addAll(this.sections);
        return sectionsCopy;
    }

    public void setSections(Section ... SECTIONS_ARRAY) {
        this.sections.clear();
        for (Section section : SECTIONS_ARRAY) {
            this.sections.add(new Section(section.getStart(), section.getStop(), section.getColor()));
        }
        this.validate();
        this.fireStateChanged();
    }

    public void addSection(Section SECTION) {
        this.sections.add(SECTION);
        this.fireStateChanged();
    }

    public void resetSections() {
        this.sections.clear();
        this.fireStateChanged();
    }

    public boolean isSectionsVisible() {
        return this.sectionsVisible;
    }

    public void setSectionsVisible(boolean SECTIONS_VISIBLE) {
        this.sectionsVisible = SECTIONS_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isHighlightSection() {
        return this.highlightSection;
    }

    public void setHighlightSection(boolean HIGHLIGHT_SECTION) {
        this.highlightSection = HIGHLIGHT_SECTION;
        this.fireStateChanged();
    }

    public List<Section> getAreas() {
        ArrayList<Section> areasCopy = new ArrayList<Section>(10);
        areasCopy.addAll(this.areas);
        return areasCopy;
    }

    public void setAreas(Section ... AREAS_ARRAY) {
        this.areas.clear();
        for (Section area : AREAS_ARRAY) {
            this.areas.add(new Section(area.getStart(), area.getStop(), area.getColor()));
        }
        this.validate();
        this.fireStateChanged();
    }

    public void addArea(Section AREA) {
        this.areas.add(AREA);
    }

    public void resetAreas() {
        this.areas.clear();
    }

    public boolean isAreasVisible() {
        return this.areasVisible;
    }

    public void setAreasVisible(boolean AREAS_VISIBLE) {
        this.areasVisible = AREAS_VISIBLE;
        this.fireStateChanged();
    }

    public boolean isHighlightArea() {
        return this.highlightArea;
    }

    public void setHighlightArea(boolean HIGHLIGHT_AREA) {
        this.highlightArea = HIGHLIGHT_AREA;
        this.fireStateChanged();
    }

    public List<Section> getTickmarkSections() {
        ArrayList<Section> tickmarkSectionsCopy = new ArrayList<Section>(10);
        tickmarkSectionsCopy.addAll(this.tickmarkSections);
        return tickmarkSectionsCopy;
    }

    public void setTickmarkSections(Section ... TICKMARK_SECTIONS_ARRAY) {
        this.tickmarkSections.clear();
        for (Section tickmarkSection : TICKMARK_SECTIONS_ARRAY) {
            this.tickmarkSections.add(new Section(tickmarkSection.getStart(), tickmarkSection.getStop(), tickmarkSection.getColor()));
        }
        this.validate();
        this.fireStateChanged();
    }

    public void addTickmarkSection(Section TICKMARK_SECTION) {
        this.tickmarkSections.add(TICKMARK_SECTION);
        this.fireStateChanged();
    }

    public void resetTickmarkSections() {
        this.tickmarkSections.clear();
        this.fireStateChanged();
    }

    public boolean isTickmarkSectionsVisible() {
        return this.tickmarkSectionsVisible;
    }

    public void setTickmarkSectionsVisible(boolean TICKMARK_SECTIONS_VISIBLE) {
        this.tickmarkSectionsVisible = TICKMARK_SECTIONS_VISIBLE;
        this.fireStateChanged();
    }

    public GaugeType getGaugeType() {
        return this.gaugeType;
    }

    public void setGaugeType(GaugeType GAUGE_TYPE) {
        this.gaugeType = GAUGE_TYPE;
        this.calcAngleStep();
        this.fireStateChanged();
    }

    public double getFreeAreaAngle() {
        return this.gaugeType.FREE_AREA_ANGLE;
    }

    public double getAngleStep() {
        return this.angleStep;
    }

    public double getLogAngleStep() {
        return this.logAngleStep;
    }

    public double getRotationOffset() {
        return this.gaugeType.ROTATION_OFFSET;
    }

    public double getTickmarkOffset() {
        return this.gaugeType.TICKMARK_OFFSET;
    }

    public void setMinMaxValues(double MIN_VALUE, double MAX_VALUE) {
        this.minValue = MIN_VALUE;
        this.maxValue = MAX_VALUE;
        this.calculate();
    }

    public void setMinMaxAndNoOfTicks(double MIN_VALUE, double MAX_VALUE, int NO_OF_MINOR_TICKS, int NO_OF_MAJOR_TICKS) {
        this.maxNoOfMinorTicks = NO_OF_MINOR_TICKS;
        this.maxNoOfMajorTicks = NO_OF_MAJOR_TICKS;
        this.minValue = MIN_VALUE;
        this.maxValue = MAX_VALUE;
        this.calculate();
    }

    public int getMaxNoOfMajorTicks() {
        return this.maxNoOfMajorTicks;
    }

    public void setMaxNoOfMajorTicks(int MAX_NO_OF_MAJOR_TICKS) {
        this.maxNoOfMajorTicks = MAX_NO_OF_MAJOR_TICKS > 20 ? 20 : (MAX_NO_OF_MAJOR_TICKS < 2 ? 2 : MAX_NO_OF_MAJOR_TICKS);
        this.calculate();
        this.fireStateChanged();
    }

    public int getMaxNoOfMinorTicks() {
        return this.maxNoOfMinorTicks;
    }

    public void setMaxNoOfMinorTicks(int MAX_NO_OF_MINOR_TICKS) {
        this.maxNoOfMinorTicks = MAX_NO_OF_MINOR_TICKS > 10 ? 10 : (MAX_NO_OF_MINOR_TICKS < 1 ? 1 : MAX_NO_OF_MINOR_TICKS);
        this.calculate();
        this.fireStateChanged();
    }

    public double getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMajorTickSpacing(double MAJOR_TICKSPACING) {
        if (!this.niceScale) {
            this.majorTickSpacing = MAJOR_TICKSPACING;
            this.calculate();
            this.validate();
            this.fireStateChanged();
        }
    }

    public double getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setMinorTickSpacing(double MINOR_TICKSPACING) {
        if (!this.niceScale) {
            this.minorTickSpacing = MINOR_TICKSPACING;
            this.calculate();
            this.validate();
            this.fireStateChanged();
        }
    }

    public double getNiceMinValue() {
        return this.niceMinValue;
    }

    public double getNiceMaxValue() {
        return this.niceMaxValue;
    }

    public double getNiceRange() {
        return this.niceRange;
    }

    public BackgroundColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColor BACKGROUND_COLOR) {
        this.backgroundColor = BACKGROUND_COLOR;
        this.fireStateChanged();
    }

    public Paint getCustomBackground() {
        return this.customBackground;
    }

    public void setCustomBackground(Paint CUSTOM_BACKGROUND) {
        this.customBackground = CUSTOM_BACKGROUND;
        this.fireStateChanged();
    }

    public Color getTextureColor() {
        return this.textureColor;
    }

    public void setTextureColor(Color TEXTURE_COLOR) {
        this.textureColor = TEXTURE_COLOR;
        this.fireStateChanged();
    }

    public BufferedImage getCustomLayer() {
        return this.customLayer;
    }

    public void setCustomLayer(BufferedImage CUSTOM_LAYER) {
        if (this.customLayer != null) {
            this.customLayer.flush();
        }
        this.customLayer = CUSTOM_LAYER;
        this.fireStateChanged();
    }

    public boolean isGlowVisible() {
        return this.glowVisible;
    }

    public void setGlowVisible(boolean GLOW_VISIBLE) {
        this.glowVisible = GLOW_VISIBLE;
        this.fireStateChanged();
    }

    public Color getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(Color GLOW_COLOR) {
        this.glowColor = GLOW_COLOR;
        this.fireStateChanged();
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public void setGlowing(boolean GLOWING) {
        this.glowing = GLOWING;
        this.fireStateChanged();
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public void setFrameType(FrameType FRAME_TYPE) {
        this.frameType = FRAME_TYPE;
        this.fireStateChanged();
    }

    public FrameDesign getFrameDesign() {
        return this.frameDesign;
    }

    public void setFrameDesign(FrameDesign FRAME_DESIGN) {
        this.frameDesign = FRAME_DESIGN;
        this.fireStateChanged();
    }

    public Paint getCustomFrameDesign() {
        return this.customFrameDesign;
    }

    public void setCustomFrameDesign(Paint CUSTOM_FRAME_DESIGN) {
        this.customFrameDesign = CUSTOM_FRAME_DESIGN;
        this.fireStateChanged();
    }

    public Paint getOuterFrameColor() {
        return this.outerFrameColor;
    }

    public void setOuterFrameColor(Paint OUTER_FRAME_COLOR) {
        this.outerFrameColor = OUTER_FRAME_COLOR;
        this.fireStateChanged();
    }

    public Paint getInnerFrameColor() {
        return this.innerFrameColor;
    }

    public void setInnerFrameColor(Paint INNER_FRAME_COLOR) {
        this.innerFrameColor = INNER_FRAME_COLOR;
        this.fireStateChanged();
    }

    public LedColor getLedColor() {
        return this.ledColor;
    }

    public void setLedColor(LedColor LED_COLOR) {
        this.ledColor = LED_COLOR;
        this.fireStateChanged();
    }

    public CustomLedColor getCustomLedColor() {
        return this.customLedColor;
    }

    public void setCustomLedColor(CustomLedColor CUSTOM_LED_COLOR) {
        this.customLedColor = CUSTOM_LED_COLOR;
        this.fireStateChanged();
    }

    public LedColor getUserLedColor() {
        return this.userLedColor;
    }

    public void setUserLedColor(LedColor LED_COLOR) {
        this.userLedColor = LED_COLOR;
        this.fireStateChanged();
    }

    public CustomLedColor getCustomUserLedColor() {
        return this.customUserLedColor;
    }

    public void setCustomUserLedColor(CustomLedColor CUSTOM_LED_COLOR) {
        this.customUserLedColor = CUSTOM_LED_COLOR;
        this.fireStateChanged();
    }

    public LcdColor getLcdColor() {
        return this.lcdColor;
    }

    public void setLcdColor(LcdColor LCD_COLOR) {
        this.lcdColor = LCD_COLOR;
        this.fireStateChanged();
    }

    public Paint getCustomLcdBackground() {
        return this.customLcdColor;
    }

    public void setCustomLcdBackground(Paint CUSTOM_LCD_COLOR) {
        this.customLcdColor = CUSTOM_LCD_COLOR;
        this.fireStateChanged();
    }

    public boolean isLcdBackgroundVisible() {
        return this.lcdBackgroundVisible;
    }

    public void setLcdBackgroundVisible(boolean LCD_BACKGROUND_VISIBLE) {
        this.lcdBackgroundVisible = LCD_BACKGROUND_VISIBLE;
        this.fireStateChanged();
    }

    public Color getCustomLcdForeground() {
        return this.customLcdForegroundColor;
    }

    public void setCustomLcdForeground(Color CUSTOM_LCD_FOREGROUND_COLOR) {
        this.customLcdForegroundColor = CUSTOM_LCD_FOREGROUND_COLOR;
        this.fireStateChanged();
    }

    public TickmarkType getMinorTickmarkType() {
        return this.minorTickmarkType;
    }

    public void setMinorTickmarkType(TickmarkType MINOR_TICKMARK_TYPE) {
        this.minorTickmarkType = MINOR_TICKMARK_TYPE;
        this.fireStateChanged();
    }

    public TickmarkType getMajorTickmarkType() {
        return this.majorTickmarkType;
    }

    public void setMajorTickmarkType(TickmarkType MAJOR_TICKMARK_TYPE) {
        this.majorTickmarkType = MAJOR_TICKMARK_TYPE;
        this.fireStateChanged();
    }

    public NumberFormat getLabelNumberFormat() {
        return this.labelNumberFormat;
    }

    public void setLabelNumberFormat(NumberFormat LABEL_NUMBERFORMAT) {
        this.labelNumberFormat = LABEL_NUMBERFORMAT;
        this.fireStateChanged();
    }

    public Color getTickmarkColor() {
        return this.tickmarkColor;
    }

    public void setTickmarkColor(Color TICKMARK_COLOR) {
        this.tickmarkColor = TICKMARK_COLOR;
        this.fireStateChanged();
    }

    public Color getCustomTickmarkColor() {
        return this.customTickmarkColor;
    }

    public void setCustomTickmarkColor(Color CUSTOM_TICKMARK_COLOR) {
        this.customTickmarkColor = CUSTOM_TICKMARK_COLOR;
        this.fireStateChanged();
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color LABEL_COLOR) {
        this.labelColor = LABEL_COLOR;
        this.fireStateChanged();
    }

    public Color getTrackStartColor() {
        return this.trackStartColor;
    }

    public void setTrackStartColor(Color TRACK_START_COLOR) {
        this.trackStartColor = TRACK_START_COLOR;
        this.fireStateChanged();
    }

    public Color getTrackSectionColor() {
        return this.trackSectionColor;
    }

    public void setTrackSectionColor(Color TRACK_SECTION_COLOR) {
        this.trackSectionColor = TRACK_SECTION_COLOR;
        this.fireStateChanged();
    }

    public Color getTrackStopColor() {
        return this.trackStopColor;
    }

    public void setTrackStopColor(Color TRACK_STOP_COLOR) {
        this.trackStopColor = TRACK_STOP_COLOR;
        this.fireStateChanged();
    }

    public PointerType getPointerType() {
        return this.pointerType;
    }

    public void setPointerType(PointerType POINTER_TYPE) {
        this.pointerType = POINTER_TYPE;
        this.fireStateChanged();
    }

    public ColorDef getPointerColor() {
        return this.pointerColor;
    }

    public void setPointerColor(ColorDef POINTER_COLOR) {
        this.pointerColor = POINTER_COLOR;
        this.fireStateChanged();
    }

    public boolean isPointerShadowVisible() {
        return this.pointerShadowVisible;
    }

    public void setPointerShadowVisible(boolean POINTER_SHADOW_VISIBLE) {
        this.pointerShadowVisible = POINTER_SHADOW_VISIBLE;
        this.fireStateChanged();
    }

    public CustomColorDef getCustomPointerColorObject() {
        return this.customPointerColorObject;
    }

    public void setCustomPointerColorObject(CustomColorDef CUSTOM_POINTER_COLOR_OBJECT) {
        this.customPointerColorObject = CUSTOM_POINTER_COLOR_OBJECT;
        this.fireStateChanged();
    }

    public Color getCustomPointerColor() {
        return this.customPointerColorObject.COLOR;
    }

    public ColorDef getValueColor() {
        return this.valueColor;
    }

    public void setValueColor(ColorDef VALUE_COLOR) {
        this.valueColor = VALUE_COLOR;
        this.fireStateChanged();
    }

    public CustomColorDef getCustomValueColorObject() {
        return this.customValueColorObject;
    }

    public void setCustomValueColorObject(CustomColorDef CUSTOM_VALUE_COLOR_OBJECT) {
        this.customValueColorObject = CUSTOM_VALUE_COLOR_OBJECT;
        this.fireStateChanged();
    }

    public Color getCustomValueColor() {
        return this.customValueColorObject.COLOR;
    }

    public KnobType getKnobType() {
        return this.knobType;
    }

    public void setKnobType(KnobType KNOB_TYPE) {
        this.knobType = KNOB_TYPE;
        this.fireStateChanged();
    }

    public KnobStyle getKnobStyle() {
        return this.knobStyle;
    }

    public void setKnobStyle(KnobStyle KNOB_STYLE) {
        this.knobStyle = KNOB_STYLE;
        this.fireStateChanged();
    }

    public boolean getPostsVisible() {
        return this.postsVisible;
    }

    public void setPostsVisible(boolean POSTS_VISIBLE) {
        this.postsVisible = POSTS_VISIBLE;
        this.fireStateChanged();
    }

    public ForegroundType getForegroundType() {
        return this.foregroundType;
    }

    public void setForegroundType(ForegroundType FOREGROUND_TYPE) {
        this.foregroundType = FOREGROUND_TYPE;
        this.fireStateChanged();
    }

    public Font getStandardBaseFont() {
        return this.STANDARD_BASE_FONT;
    }

    public Font getStandardInfoFont() {
        return this.STANDARD_INFO_FONT;
    }

    public Font getDigitalBaseFont() {
        return this.DIGITAL_BASE_FONT;
    }

    public Font getLcdValueFont() {
        return this.lcdValueFont;
    }

    public void setLcdValueFont(Font LCD_VALUE_FONT) {
        this.lcdValueFont = LCD_VALUE_FONT;
        this.fireStateChanged();
    }

    public Font getLcdUnitFont() {
        return this.lcdUnitFont;
    }

    public void setLcdUnitFont(Font LCD_UNIT_FONT) {
        this.lcdUnitFont = LCD_UNIT_FONT;
        this.fireStateChanged();
    }

    public Font getCustomLcdUnitFont() {
        return this.customLcdUnitFont;
    }

    public void setCustomLcdUnitFont(Font CUSTOM_LCD_UNIT_FONT) {
        this.customLcdUnitFont = CUSTOM_LCD_UNIT_FONT;
        this.fireStateChanged();
    }

    public Font getLcdInfoFont() {
        return this.lcdInfoFont;
    }

    public void setLcdInfoFont(Font LCD_INFO_FONT) {
        this.lcdInfoFont = LCD_INFO_FONT;
        this.fireStateChanged();
    }

    public int getLcdDecimals() {
        return this.lcdDecimals;
    }

    public void setLcdDecimals(int LCD_DECIMALS) {
        this.lcdDecimals = LCD_DECIMALS;
        this.fireStateChanged();
    }

    public boolean isNiceScale() {
        return this.niceScale;
    }

    public void setNiceScale(boolean NICE_SCALE) {
        this.niceScale = NICE_SCALE;
        if (!this.niceScale) {
            this.minorTickSpacing = 1.0;
            this.majorTickSpacing = 10.0;
        }
        this.calculate();
        this.validate();
        this.calcAngleStep();
        this.fireStateChanged();
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean LOG_SCALE) {
        this.logScale = LOG_SCALE;
        this.fireStateChanged();
    }

    public void validate() {
        if (this.niceMinValue > 0.0 || this.niceMaxValue < 0.0) {
            this.autoResetToZero = false;
        }
        if (this.threshold < this.niceMinValue || this.threshold > this.niceMaxValue) {
            this.threshold = this.niceMaxValue;
        }
        if (this.minMeasuredValue < this.niceMinValue || this.minMeasuredValue > this.niceMaxValue) {
            this.minMeasuredValue = this.value;
        }
        if (this.maxMeasuredValue > this.niceMaxValue || this.maxMeasuredValue < this.niceMinValue) {
            this.maxMeasuredValue = this.value;
        }
        if (this.peakValue < this.niceMinValue || this.peakValue > this.niceMaxValue) {
            this.peakValue = this.value;
        }
        if (Double.compare(this.trackStart, this.niceMinValue) <= 0 || Double.compare(this.trackStart, this.niceMaxValue) >= 0 || Double.compare(this.trackStart, this.trackStop) >= 0) {
            this.trackStart = this.niceMinValue;
        }
        if (Double.compare(this.trackStop, this.niceMinValue) <= 0 || Double.compare(this.trackStop, this.niceMaxValue) >= 0 || Double.compare(this.trackStop, this.trackStart) <= 0) {
            this.trackStop = this.niceMaxValue;
        }
        if (Double.compare(this.trackSection, this.niceMinValue) <= 0 || Double.compare(this.trackSection, this.niceMaxValue) >= 0 || Double.compare(this.trackSection, this.trackStart) <= 0 || Double.compare(this.trackSection, this.trackStop) >= 0) {
            this.trackSection = this.trackStart + (this.trackStop - this.trackStart) / 2.0;
        }
        for (Section area : this.areas) {
            if (area.getStart() < this.niceMinValue || Double.compare(area.getStart(), this.niceMaxValue) >= 0 || Double.compare(area.getStart(), area.getStop()) >= 0) {
                area.setStart(this.niceMinValue);
            }
            if (area.getStop() < this.niceMinValue || area.getStop() > this.niceMaxValue || Double.compare(area.getStop(), area.getStart()) <= 0) {
                area.setStop(this.niceMaxValue);
            }
            if (Double.compare(area.getStart(), this.minValue) == 0) {
                area.setStart(this.niceMinValue);
            }
            if (Double.compare(area.getStop(), this.maxValue) != 0) continue;
            area.setStop(this.niceMaxValue);
        }
        for (Section section : this.sections) {
            if (section.getStart() < this.niceMinValue || Double.compare(section.getStart(), this.niceMaxValue) >= 0 || Double.compare(section.getStart(), section.getStop()) >= 0) {
                section.setStart(this.niceMinValue);
            }
            if (section.getStop() < this.niceMinValue || section.getStop() > this.niceMaxValue || Double.compare(section.getStop(), section.getStart()) <= 0) {
                section.setStop(this.niceMaxValue);
            }
            if (Double.compare(section.getStart(), this.minValue) == 0) {
                section.setStart(this.niceMinValue);
            }
            if (Double.compare(section.getStop(), this.maxValue) != 0) continue;
            section.setStop(this.niceMaxValue);
        }
        for (Section tickmarkSection : this.tickmarkSections) {
            if (tickmarkSection.getStart() < this.niceMinValue || Double.compare(tickmarkSection.getStart(), this.niceMaxValue) >= 0 || Double.compare(tickmarkSection.getStart(), tickmarkSection.getStop()) >= 0) {
                tickmarkSection.setStart(this.niceMinValue);
            }
            if (tickmarkSection.getStop() < this.niceMinValue || tickmarkSection.getStop() > this.niceMaxValue || Double.compare(tickmarkSection.getStop(), tickmarkSection.getStart()) <= 0) {
                tickmarkSection.setStop(this.niceMaxValue);
            }
            if (Double.compare(tickmarkSection.getStart(), this.minValue) == 0) {
                tickmarkSection.setStart(this.niceMinValue);
            }
            if (Double.compare(tickmarkSection.getStop(), this.maxValue) != 0) continue;
            tickmarkSection.setStop(this.niceMaxValue);
        }
        this.redrawFactor = this.redrawTolerance * this.getRange();
        this.value = this.value < this.niceMinValue ? this.niceMinValue : (this.value > this.niceMaxValue ? this.niceMaxValue : this.value);
    }

    private void calcAngleStep() {
        this.angleStep = this.gaugeType.ANGLE_RANGE / this.range;
        this.logAngleStep = this.gaugeType.ANGLE_RANGE / Util.INSTANCE.logOfBase(10.0, this.range);
    }

    private void calculate() {
        if (this.niceScale) {
            this.niceRange = this.calcNiceNumber(this.maxValue - this.minValue, false);
            this.majorTickSpacing = this.calcNiceNumber(this.niceRange / (double)(this.maxNoOfMajorTicks - 1), true);
            this.niceMinValue = Math.floor(this.minValue / this.majorTickSpacing) * this.majorTickSpacing;
            this.niceMaxValue = Math.ceil(this.maxValue / this.majorTickSpacing) * this.majorTickSpacing;
            this.minorTickSpacing = this.calcNiceNumber(this.majorTickSpacing / (double)(this.maxNoOfMinorTicks - 1), true);
            this.range = this.niceMaxValue - this.niceMinValue;
        } else {
            this.niceRange = this.maxValue - this.minValue;
            this.niceMinValue = this.minValue;
            this.niceMaxValue = this.maxValue;
            this.range = this.niceRange;
        }
    }

    private double calcNiceNumber(double RANGE, boolean ROUND) {
        double EXPONENT = Math.floor(Math.log10(RANGE));
        double FRACTION = RANGE / Math.pow(10.0, EXPONENT);
        double NICE_FRACTION = ROUND ? (FRACTION < 1.5 ? 1.0 : (FRACTION < 3.0 ? 2.0 : (FRACTION < 7.0 ? 5.0 : 10.0))) : (FRACTION <= 1.0 ? 1.0 : (FRACTION <= 2.0 ? 2.0 : (FRACTION <= 5.0 ? 5.0 : 10.0)));
        return NICE_FRACTION * Math.pow(10.0, EXPONENT);
    }

    private void createRadialShapeOfMeasureValuesArea() {
        if (this.bounds.width > 1 && this.bounds.height > 1 && Double.compare(this.getMinMeasuredValue(), this.getMaxMeasuredValue()) != 0) {
            double ANGLE_STEP = Math.toDegrees(this.getGaugeType().ANGLE_RANGE) / (this.getMaxValue() - this.getMinValue());
            double RADIUS = (float)this.bounds.width * 0.35f - (float)this.bounds.height * 0.04f;
            double FREE_AREA = (double)this.bounds.width / 2.0 - RADIUS;
            ((Arc2D)this.radialShapeOfMeasuredValues).setFrame(new Rectangle2D.Double((double)this.bounds.x + FREE_AREA, (double)this.bounds.y + FREE_AREA, 2.0 * RADIUS, 2.0 * RADIUS));
            ((Arc2D)this.radialShapeOfMeasuredValues).setAngleStart(this.getGaugeType().ORIGIN_CORRECTION - this.getMinMeasuredValue() * ANGLE_STEP + this.getMinValue() * ANGLE_STEP);
            ((Arc2D)this.radialShapeOfMeasuredValues).setAngleExtent(-(this.getMaxMeasuredValue() - this.getMinMeasuredValue()) * ANGLE_STEP);
            ((Arc2D)this.radialShapeOfMeasuredValues).setArcType(2);
        }
    }

    public void reset() {
        this.init();
    }

    public Model clone() {
        try {
            return (Model)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new Model();
        }
    }

    public void addChangeListener(ChangeListener LISTENER) {
        this.LISTENER_LIST.add(ChangeListener.class, LISTENER);
    }

    public void removeChangeListener(ChangeListener LISTENER) {
        this.LISTENER_LIST.remove(ChangeListener.class, LISTENER);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.LISTENER_LIST.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public String toString() {
        return "Model";
    }
}

