/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.EnumsReader;
import com.rusefi.RootHolder;
import com.rusefi.ToolUtil;
import com.rusefi.enum_reader.Value;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableRegistry {
    public static final String AUTO_ENUM_SUFFIX = "_auto_enum";
    private static final Logging log = Logging.getLogging(VariableRegistry.class);
    public static final String _16_HEX_SUFFIX = "_16_hex";
    public static final String _HEX_SUFFIX = "_hex";
    public static final String CHAR_SUFFIX = "_char";
    public static final String KEY_VALUE_FORMAT_ENUM = "_enum";
    public static final String ARRAY_FORMAT_ENUM = "_fullenum";
    public static final char MULT_TOKEN = '*';
    public static final String DEFINE = "#define";
    private static final String HEX_PREFIX = "0x";
    private final TreeMap<String, String> data = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final Pattern VAR = Pattern.compile("(@@(.*?)@@)");
    private final Pattern VAR_REMOVE_QUOTE = Pattern.compile("(@#(.*?)#@)");
    public final Map<String, Integer> intValues = new HashMap<String, Integer>();
    private final Map<String, String> cAllDefinitions = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> javaDefinitions = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public static String unquote(String token) {
        return VariableRegistry.unquote(token, '\"');
    }

    @NotNull
    public static String unquote(String token, char quoteSymbol) {
        int length = token.length();
        if (length < 2) {
            return token;
        }
        if (token.charAt(0) == quoteSymbol && token.charAt(token.length() - 1) == quoteSymbol) {
            return token.substring(1, length - 1);
        }
        return token;
    }

    static boolean looksLikeDefineLine(String line) {
        return ToolUtil.startsWithToken(line, DEFINE);
    }

    public void readPrependValues(String prependFile, boolean ignoreUnexpectedLined) {
        File file = new File(RootHolder.ROOT + prependFile);
        try {
            this.readPrependValues(new FileReader(file), ignoreUnexpectedLined);
        }
        catch (Throwable e) {
            throw new IllegalStateException("While reading from " + file.getAbsolutePath(), e);
        }
    }

    public void readPrependValues(Reader fileReader, boolean ignoreUnexpectedLined) throws IOException {
        String line;
        BufferedReader definitionReader = new BufferedReader(fileReader);
        while ((line = definitionReader.readLine()) != null) {
            if (ToolUtil.isEmptyDefinitionLine(line = ToolUtil.trimLine(line))) continue;
            if (ToolUtil.startsWithToken(line, DEFINE)) {
                this.processDefine(line.substring(DEFINE.length()).trim());
                continue;
            }
            if (ignoreUnexpectedLined) continue;
            throw new IllegalStateException("Unexpected line while prepending: [" + line + "]");
        }
    }

    void processLine(String line) {
        this.processDefine(line.substring(DEFINE.length()).trim());
    }

    void processDefine(String line) {
        String name;
        int index = line.indexOf(32);
        if (index == -1) {
            name = line;
            line = "";
        } else {
            name = line.substring(0, index);
            line = line.substring(index).trim();
        }
        if (VariableRegistry.isNumeric(line)) {
            int v = Integer.parseInt(line);
            this.register(name, v);
        } else {
            if (line.contains(" ") && !VariableRegistry.isQuoted(line, '\"') && !VariableRegistry.isQuoted(line, '\'')) {
                throw new IllegalStateException("Unexpected space in unquoted " + line);
            }
            this.register(name, line);
        }
    }

    @Nullable
    private TreeMap<Integer, String> resolveEnumValues(@NotNull EnumsReader.EnumState stringValueMap) {
        TreeMap<Integer, String> valueNameById = new TreeMap<Integer, String>();
        for (Value value : stringValueMap.values()) {
            if (VariableRegistry.isNumeric(value.getValue())) {
                valueNameById.put(value.getIntValue(), value.getName());
                continue;
            }
            String valueFromRegistry = this.get(value.getValue());
            if (valueFromRegistry == null) {
                throw new IllegalStateException("No value for " + value);
            }
            int intValue = Integer.parseInt(valueFromRegistry);
            valueNameById.put(intValue, value.getName());
        }
        return valueNameById;
    }

    private static void appendCommaIfNeeded(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(",");
        }
    }

    public String getEnumOptionsForTunerStudio(EnumsReader enumsReader, String enumName) {
        EnumsReader.EnumState stringValueMap = enumsReader.getEnums().get(enumName);
        if (stringValueMap == null) {
            return null;
        }
        TreeMap<Integer, String> valueNameById = this.resolveEnumValues(stringValueMap);
        if (valueNameById == null) {
            return null;
        }
        return VariableRegistry.getHumanSortedTsKeyValueString(valueNameById);
    }

    public static String quote(String string) {
        return "\"" + string + "\"";
    }

    @NotNull
    public static String getHumanSortedTsKeyValueString(Map<Integer, String> valueNameById) {
        TreeMap<Integer, String> humanDropDownSorted = new TreeMap<Integer, String>((o1, o2) -> {
            if (o1.intValue() == o2.intValue()) {
                return 0;
            }
            if (o1 == 0) {
                return -1;
            }
            if (o2 == 0) {
                return 1;
            }
            return ((String)valueNameById.get(o1)).compareTo((String)valueNameById.get(o2));
        });
        humanDropDownSorted.putAll(valueNameById);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : humanDropDownSorted.entrySet()) {
            VariableRegistry.appendCommaIfNeeded(sb);
            sb.append(e.getKey() + "=" + VariableRegistry.quote((String)e.getValue()));
        }
        return sb.toString();
    }

    public String applyVariables(String line) {
        if (line == null) {
            return null;
        }
        line = this.process(line, this.VAR, key -> {
            if (!this.data.containsKey(key)) {
                throw new IllegalStateException("No such variable: [" + key + "]");
            }
            return this.data.get(key);
        });
        line = this.process(line, this.VAR_REMOVE_QUOTE, key -> {
            if (!this.data.containsKey(key)) {
                throw new IllegalStateException("No such variable: [" + key + "]");
            }
            String unquotedDouble = VariableRegistry.unquote(this.data.get(key));
            return VariableRegistry.unquote(unquotedDouble, '\'');
        });
        return line;
    }

    @NotNull
    private String process(String line, Pattern pattern, Function<String, String> function) {
        Matcher m;
        while ((m = pattern.matcher(line)).find()) {
            if (m.groupCount() < 2) {
                throw new IllegalStateException("Something broken in: [" + line + "]");
            }
            String key = m.group(2);
            line = m.replaceFirst(function.apply(key));
        }
        return line;
    }

    public void register(String var, String rawValue) {
        try {
            String value = this.doRegister(var, rawValue);
            if (value == null) {
                return;
            }
            this.tryToRegisterAsInteger(var, value);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("While [" + var + "][" + rawValue + "]", e);
        }
    }

    @Nullable
    private String doRegister(String var, String value) {
        if (this.data.containsKey(var)) {
            if (log.debugEnabled()) {
                log.debug("Not redefining " + var);
            }
            return null;
        }
        value = this.applyVariables(value);
        int multPosition = value.indexOf(42);
        if (!value.contains("\n") && !VariableRegistry.isQuoted(value, '\"') && multPosition != -1) {
            Integer first = Integer.valueOf(value.substring(0, multPosition).trim());
            Integer second = Integer.valueOf(value.substring(multPosition + 1).trim());
            value = String.valueOf(first * second);
        }
        if (log.debugEnabled()) {
            log.debug("Registering " + var + " as " + value);
        }
        this.data.put(var, value);
        if (!(value.contains("\n") || var.endsWith(_16_HEX_SUFFIX) || var.endsWith(_HEX_SUFFIX))) {
            this.cAllDefinitions.put(var, "#define " + var + " " + value + "\n");
        }
        return value;
    }

    public static boolean isNumeric(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void tryToRegisterAsInteger(String var, String value) {
        block6: {
            if (value.trim().startsWith(HEX_PREFIX)) {
                int intValue = Integer.parseInt(value.trim().substring(HEX_PREFIX.length()), 16);
                this.intValues.put(var, intValue);
                this.javaDefinitions.put(var, "\tpublic static final int " + var + " = " + value + ";\n");
                return;
            }
            try {
                int intValue = Integer.parseInt(value);
                if (log.debugEnabled()) {
                    log.debug("key [" + var + "] value: " + intValue);
                }
                this.intValues.put(var, intValue);
                if (!var.endsWith(_HEX_SUFFIX)) {
                    this.javaDefinitions.put(var, "\tpublic static final int " + var + " = " + intValue + ";\n");
                }
            }
            catch (NumberFormatException e) {
                if (var.trim().endsWith(KEY_VALUE_FORMAT_ENUM) || var.trim().endsWith(ARRAY_FORMAT_ENUM)) break block6;
                if (VariableRegistry.isQuoted(value, '\"')) {
                    this.javaDefinitions.put(var, "\tpublic static final String " + var + " = " + value + ";\n");
                }
                if (!VariableRegistry.isQuoted(value, '\'')) break block6;
                this.javaDefinitions.put(var, "\tpublic static final char " + var + " = " + value + ";\n");
                char charValue = value.charAt(1);
                this.registerHex(var + CHAR_SUFFIX, charValue);
                this.doRegister(var + CHAR_SUFFIX, Character.toString(charValue));
            }
        }
    }

    public static boolean isQuoted(String value, char quote) {
        if (value == null) {
            return false;
        }
        if ((value = value.trim()).isEmpty()) {
            return false;
        }
        return VariableRegistry.simpleIsQuoted(value, quote);
    }

    private static boolean simpleIsQuoted(String value, char quote) {
        return value.charAt(0) == quote && value.charAt(value.length() - 1) == quote;
    }

    public void register(String name, int value) {
        this.register(name, Integer.toString(value));
        this.registerHex(name, value);
    }

    public void registerHex(String name, int value) {
        this.register(name + _HEX_SUFFIX, Integer.toString(value, 16));
        String _16_hex = String.format("\\\\x%02x\\\\x%02x", value >> 8 & 0xFF, value & 0xFF);
        this.register(name + _16_HEX_SUFFIX, _16_hex);
    }

    public String getDefinesSection() {
        StringBuilder sb = new StringBuilder();
        for (String value : this.cAllDefinitions.values()) {
            sb.append(value);
        }
        return sb.toString();
    }

    public String getJavaConstants() {
        StringBuilder result = new StringBuilder();
        for (String value : this.javaDefinitions.values()) {
            result.append(value);
        }
        return result.toString();
    }

    public int size() {
        return this.data.size();
    }

    public void put(String key, String value) {
        this.data.put(key, value);
    }

    @Nullable
    public String get(Object key) {
        return this.data.get(key);
    }
}

