/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.lua;

import com.rusefi.ui.lua.ContentSource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LuaIncludeSyntax {
    static String getScriptName(String lua) {
        Pattern p = Pattern.compile(".*--\\s*scriptname\\s*([\\S]+)", 8);
        Matcher m = p.matcher(lua);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    static String reloadScript(String lua, ContentSource source) {
        int index = 0;
        Pattern startPattern = Pattern.compile(".*--\\s*include\\s*([\\S]+)", 8);
        Pattern endPattern = Pattern.compile(".*--\\s*endinclude", 8);
        StringBuilder result = new StringBuilder();
        Matcher startMatcher = startPattern.matcher(lua);
        Matcher endMatcher = endPattern.matcher(lua);
        while (startMatcher.find(index)) {
            int endOfIncludeStartIndex = startMatcher.end();
            result.append(lua.substring(index, endOfIncludeStartIndex));
            result.append("\n");
            String includeName = startMatcher.group(1);
            result.append(source.getContent(includeName));
            if (!endMatcher.find(endOfIncludeStartIndex)) {
                throw new IllegalStateException("No end for " + includeName);
            }
            index = endMatcher.end();
        }
        result.append(lua.substring(index));
        return result.toString();
    }
}

