/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autotune;

import com.rusefi.autotune.AfrDataPoint;
import com.rusefi.autotune.FuelAutoLogic;
import com.rusefi.autotune.MathUtil;
import com.rusefi.autotune.Result;
import java.util.Collection;

public enum FuelAutoTune implements FuelAutoLogic
{
    INSTANCE;

    public static final int SIZE = 16;
    public static final double _14_7 = 14.7;

    private static boolean isLogEnabled() {
        return true;
    }

    @Override
    public Result process(boolean smooth, Collection<AfrDataPoint> dataECU, double STEP, double targetAFR, double[][] kgbcINIT) {
        double[][] cellDeviation = new double[16][16];
        double totalDeviation = 0.0;
        double minSQtotal = Double.MAX_VALUE;
        double kgbcSQsumLastTotal = 1.0E16;
        double ksq = 1000.0;
        double ke = 100.0;
        double kg = 100.0;
        int[][] bkGBC = new int[16][16];
        for (AfrDataPoint data : dataECU) {
            int[] nArray = bkGBC[data.PRESS_RT_32()];
            int n = data.RPM_RT_32();
            nArray[n] = nArray[n] + 1;
        }
        double[][] result = MathUtil.deepCopy(kgbcINIT);
        double[][] ktgbcRES = new double[16][16];
        double[][] ktgbcINIT = new double[16][16];
        MathUtil.setArray2D(ktgbcINIT, 1.0);
        MathUtil.setArray2D(ktgbcRES, 1.0);
        int COUNT_THRESHOLD = 20;
        int minK = 0;
        while (minK <= 4) {
            for (int loadIndex = 0; loadIndex < 16; ++loadIndex) {
                for (int rpmIndex = 0; rpmIndex < 16; ++rpmIndex) {
                    if (bkGBC[loadIndex][rpmIndex] < COUNT_THRESHOLD) continue;
                    totalDeviation = FuelAutoTune.getTotalDeviationAfterCellOptimization(smooth, dataECU, STEP, targetAFR, kgbcINIT, cellDeviation, ksq, ke, kg, result, loadIndex, rpmIndex);
                }
            }
            if (totalDeviation < minSQtotal) {
                minSQtotal = totalDeviation;
            }
            if (Math.abs(minSQtotal - kgbcSQsumLastTotal) < 1.0E-10) {
                ++minK;
            }
            kgbcSQsumLastTotal = totalDeviation;
        }
        FuelAutoTune.log("return " + minK);
        return new Result(result);
    }

    private static double getTotalDeviationAfterCellOptimization(boolean smooth, Collection<AfrDataPoint> dataECU, double step, double targetAFR, double[][] kgbcINIT, double[][] cellDeviation, double ksq, double ke, double kg, double[][] result, int loadIndex, int rpmIndex) {
        double totalDeviation = Double.MAX_VALUE;
        double minTotalDeviation = Double.MAX_VALUE;
        double currentStep = step;
        int goodValueCounter = 0;
        while (goodValueCounter <= 4) {
            double prevTotalDeviation = totalDeviation;
            FuelAutoTune.countDeviation(dataECU, cellDeviation, result, kgbcINIT, targetAFR);
            totalDeviation = MathUtil.sumArray(cellDeviation);
            if (smooth) {
                totalDeviation = FuelAutoTune.smooth(totalDeviation, ksq, ke, kg, result);
            }
            if (totalDeviation >= prevTotalDeviation) {
                currentStep = -currentStep;
            }
            double[] dArray = result[loadIndex];
            int n = rpmIndex;
            dArray[n] = dArray[n] + currentStep;
            if (!(Math.abs((minTotalDeviation = Math.min(minTotalDeviation, totalDeviation)) - prevTotalDeviation) < 1.0E-10)) continue;
            ++goodValueCounter;
        }
        return totalDeviation;
    }

    private static void countDeviation(Collection<AfrDataPoint> dataECU, double[][] cellDeviation, double[][] result, double[][] kgbcINIT, double targetAFR) {
        MathUtil.setArray2D(cellDeviation, 0.0);
        double normalizedTargetAfr = targetAFR / 14.7;
        for (AfrDataPoint dataPoint : dataECU) {
            double normalizedAfr = dataPoint.getAfr() / 14.7;
            double tmp = normalizedAfr - normalizedTargetAfr * result[dataPoint.PRESS_RT_32()][dataPoint.RPM_RT_32()] / kgbcINIT[dataPoint.PRESS_RT_32()][dataPoint.RPM_RT_32()];
            double[] dArray = cellDeviation[dataPoint.PRESS_RT_32()];
            int n = dataPoint.RPM_RT_32();
            dArray[n] = dArray[n] + Math.abs(tmp);
        }
    }

    private static double smooth(double kgbcSQsum, double ksq, double ke, double kg, double[][] kgbcRES) {
        double e = 0.0;
        kgbcSQsum = ksq * kgbcSQsum;
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 16; ++j) {
                e += MathUtil.square(kgbcRES[i][j] - kgbcRES[i + 1][j]);
                e += MathUtil.square(kgbcRES[j][i] - kgbcRES[j][i + 1]);
            }
        }
        double g = 0.0;
        for (int i = 0; i < 14; ++i) {
            for (int j = 0; j < 16; ++j) {
                double tmp1 = MathUtil.square(kgbcRES[i][j] - 2.0 * kgbcRES[i + 1][j] + kgbcRES[i + 2][j]);
                g += tmp1;
                g += MathUtil.square(kgbcRES[j][i] - 2.0 * kgbcRES[j][i + 1] + kgbcRES[j][i + 2]);
            }
        }
        return kgbcSQsum += ke * e + kg * g;
    }

    private static void log(String s) {
        System.out.println(s);
    }
}

