/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Timer;

public class StatusAnimation {
    private static final int DOTS_COUNT = 5;
    private final Timer timer;
    private volatile boolean isStopped;
    private int counter;

    public StatusAnimation(final StatusConsumer consumer, final String message) {
        this.timer = new Timer(200, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StatusAnimation.this.isStopped) {
                    return;
                }
                ++StatusAnimation.this.counter;
                StringBuilder status = new StringBuilder(message);
                for (int i = 0; i < StatusAnimation.this.counter % 5; ++i) {
                    status.append(".");
                }
                consumer.onStatus(status.toString());
            }
        });
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
        this.isStopped = true;
    }

    public static interface StatusConsumer {
        public void onStatus(String var1);
    }
}

