/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.serial;

import java.util.LinkedList;

public class RateCounter {
    private static final int MAGIC_DURATION = 1000;
    private final LinkedList<Pair> timeStamps = new LinkedList();

    public int getCurrentRate() {
        return this.getCurrentRate(System.currentTimeMillis());
    }

    public synchronized int getCurrentRate(long now) {
        long threshold = now - 1000L;
        while (!this.timeStamps.isEmpty() && this.timeStamps.peekFirst().timestamp < threshold) {
            this.timeStamps.removeFirst();
        }
        int result = 0;
        for (Pair pair : this.timeStamps) {
            result += pair.value;
        }
        return result;
    }

    public synchronized int getSizeForUnitTest() {
        return this.timeStamps.size();
    }

    public void add() {
        this.add(System.currentTimeMillis());
    }

    public synchronized void add(long timestamp) {
        this.timeStamps.add(new Pair(timestamp, 1));
    }

    public String toString() {
        return "RateCounter{" + this.getSizeForUnitTest() + "}";
    }

    private static class Pair {
        private final long timestamp;
        private final int value;

        public Pair(long timestamp, int value) {
            this.timestamp = timestamp;
            this.value = value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getValue() {
            return this.value;
        }
    }
}

