/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractConcurrentSet<E>
implements Set<E> {
    protected AbstractConcurrentSet() {
    }

    @Override
    public void clear() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        return this.toArrayImpl(null);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArrayImpl(a);
    }

    private <T> T[] toArrayImpl(T[] a) {
        int size = this.size();
        Object[] result = a == null ? new Object[size] : (a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size));
        int n = 0;
        for (Object o : this) {
            if (n >= result.length) {
                Object[] tmp = (Object[])Array.newInstance(result.getClass().getComponentType(), n + n + 1);
                System.arraycopy(result, 0, tmp, 0, n);
                result = tmp;
            }
            result[n++] = o;
        }
        if (n < result.length && a == null) {
            Object[] tmp = new Object[n];
            System.arraycopy(result, 0, tmp, 0, n);
            result = tmp;
        }
        if (n < result.length) {
            result[n] = null;
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E o : c) {
            if (!this.add(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        if (this.size() > c.size()) {
            for (Object o : c) {
                if (!this.remove(o)) continue;
                modified = true;
            }
        } else {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Set && this.size() == ((Set)o).size() && this.containsAll((Set)o);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (Object o : this) {
            if (o == null) continue;
            hash += o.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size() * 3 + 10);
        sb.append("[");
        String separator = "";
        for (Object o : this) {
            sb.append(separator);
            sb.append(o);
            separator = ", ";
        }
        sb.append("]");
        return sb.toString();
    }
}

