/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.FieldIteratorWithOffset;
import com.rusefi.parse.TypesHelper;

public class BaseCHeaderConsumer
implements ConfigurationConsumer {
    private static final String BOOLEAN_TYPE = "bool";
    public static boolean needZeroInit = true;
    private final StringBuilder content = new StringBuilder();

    private static String getHeaderText(FieldIteratorWithOffset iterator) {
        ConfigField configField = iterator.cf;
        if (configField.isBit()) {
            String comment = "\t/**\n" + BaseCHeaderConsumer.packComment(configField.getComment(), "\t") + "\toffset " + iterator.currentOffset + " bit " + iterator.bitState.get() + " */\n";
            return comment + "\tbool " + configField.getName() + " : 1 {};\n";
        }
        Object cEntry = BaseCHeaderConsumer.getComment(configField.getComment(), iterator.currentOffset, configField.getUnits());
        Object typeName = configField.getTypeName();
        String autoscaleSpec = configField.autoscaleSpec();
        if (autoscaleSpec != null) {
            typeName = "scaled_channel<" + (String)typeName + ", " + autoscaleSpec + ">";
        }
        if (!configField.isArray()) {
            cEntry = (String)cEntry + "\t" + (String)typeName + " " + configField.getName();
            if (needZeroInit && TypesHelper.isPrimitive(configField.getTypeName())) {
                cEntry = (String)cEntry + " = (" + configField.getTypeName() + ")0";
            }
            cEntry = (String)cEntry + ";\n";
        } else {
            cEntry = (String)cEntry + "\t" + (String)typeName + " " + configField.getName() + "[" + configField.getArraySizeVariableName() + "];\n";
        }
        return cEntry;
    }

    private static String getComment(String comment, int currentOffset, String units) {
        String start = "\t/**";
        String packedComment = BaseCHeaderConsumer.packComment(comment, "\t");
        Object unitsComment = units.isEmpty() ? "" : "\t * units: " + units + "\n";
        return start + "\n" + packedComment + (String)unitsComment + "\t * offset " + currentOffset + "\n\t */\n";
    }

    public static String packComment(String comment, String linePrefix) {
        if (comment == null) {
            return "";
        }
        if (comment.trim().isEmpty()) {
            return "";
        }
        Object result = "";
        for (String line : comment.split("\\\\n")) {
            result = (String)result + linePrefix + " * " + line + "\n";
        }
        return result;
    }

    @Override
    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) {
        if (structure.getComment() != null) {
            this.content.append("/**\n" + BaseCHeaderConsumer.packComment(structure.getComment(), "") + "\n*/\n");
        }
        this.content.append("// start of " + structure.getName() + "\n");
        this.content.append("struct " + structure.getName() + " {\n");
        FieldIteratorWithOffset iterator = new FieldIteratorWithOffset(structure.getcFields());
        for (int i = 0; i < structure.getcFields().size(); ++i) {
            iterator.start(i);
            this.content.append(BaseCHeaderConsumer.getHeaderText(iterator));
            iterator.currentOffset += iterator.cf.getSize(iterator.next);
            iterator.end();
        }
        this.content.append("};\n");
        int realSize = iterator.currentOffset;
        int cppSize = Math.max(1, realSize);
        this.content.append("static_assert(sizeof(" + structure.getName() + ") == " + cppSize + ");\n");
        this.content.append("\n");
    }

    public String getContent() {
        return this.content.toString();
    }
}

