/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.knock;

import com.devexperts.logging.Logging;
import com.rusefi.FileLog;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.EngineState;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.ui.RpmLabel;
import com.rusefi.ui.RpmModel;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.knock.KnockScale;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.AnyCommand;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Base64;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class KnockPane {
    private static final Logging log = Logging.getLogging(KnockPane.class);
    private final KnockCanvas canvas = new KnockCanvas();
    private final JPanel content = new JPanel(new BorderLayout());
    private final AnyCommand command;

    public KnockPane(final UIContext uiContext, Node config) {
        uiContext.getLinkManager().getEngineState().registerStringValueAction("knock_spectrogram", new EngineState.ValueCallback<String>(){

            @Override
            public void onUpdate(String value) {
                KnockPane.this.canvas.processValues(value);
                KnockPane.this.canvas.repaint();
            }
        });
        JPanel upperPanel = new JPanel(new FlowLayout(0, 5, 0));
        JButton enableButton = new JButton("start");
        enableButton.setMnemonic('s');
        enableButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                uiContext.getLinkManager().submit(() -> {
                    BinaryProtocol binaryProtocol = uiContext.getLinkManager().getConnector().getBinaryProtocol();
                    binaryProtocol.executeCommand('m', "start knock analyzer");
                });
            }
        });
        upperPanel.add(enableButton);
        JButton disableButton = new JButton("stop");
        disableButton.setMnemonic('s');
        disableButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                uiContext.getLinkManager().submit(() -> {
                    BinaryProtocol binaryProtocol = uiContext.getLinkManager().getConnector().getBinaryProtocol();
                    binaryProtocol.executeCommand('n', "stop knock analyzer");
                });
            }
        });
        upperPanel.add(disableButton);
        JButton saveImageButton = UiUtils.createSaveImageButton();
        upperPanel.add(saveImageButton);
        saveImageButton.addActionListener(e -> {
            int rpm = RpmModel.getInstance().getValue();
            String fileName = FileLog.getDate() + "_knock_" + rpm + "_spectrogram.png";
            UiUtils.saveImageWithPrompt(fileName, upperPanel, this.canvas);
        });
        upperPanel.add(new RpmLabel(uiContext, 2).getContent());
        this.command = AnyCommand.createField(uiContext, config, true, false);
        upperPanel.add(this.command.getContent());
        this.content.add((Component)upperPanel, "North");
        KnockKeListener l = new KnockKeListener();
        this.canvas.setFocusable(true);
        this.canvas.setFocusTraversalKeysEnabled(false);
        this.canvas.addKeyListener(l);
        this.canvas.setFocusable(true);
        this.canvas.setDoubleBuffered(true);
        this.content.add((Component)this.canvas, "Center");
        KnockScale leftPanel = new KnockScale(this);
        leftPanel.setPreferredSize(new Dimension(150, 0));
        this.content.add((Component)leftPanel, "West");
    }

    public KnockCanvas getCanvas() {
        return this.canvas;
    }

    public JComponent getPanel() {
        return this.content;
    }

    public ActionListener getTabSelectedListener() {
        return e -> this.command.requestFocus();
    }

    public class KnockCanvas
    extends JComponent
    implements ComponentListener {
        JComponent dd = this;
        private BufferedImage bufferedImage;
        private Graphics2D bufferedGraphics;
        int SPECTROGRAM_X_AXIS_SIZE = 1024;
        float[][] specrtogram;
        float mainFrequency = 0.0f;
        Color[] colorspace;
        Color[] colors;
        float[] amplitudesInColorSpace;
        int spectrogramYAxisSize;
        public double[] yAxisHz;
        int currentIndexXAxis = 0;

        private KnockCanvas() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KnockCanvas.this.dd.repaint();
                }
            });
            this.bufferedImage = new BufferedImage(640, 480, 1);
            this.bufferedGraphics = this.bufferedImage.createGraphics();
            this.addComponentListener(this);
            this.colorspace = new Color[]{Color.decode("#000000"), Color.decode("#290d1a"), Color.decode("#490b32"), Color.decode("#670353"), Color.decode("#81007b"), Color.decode("#a60085"), Color.decode("#ca008b"), Color.decode("#ef008f"), Color.decode("#ff356b"), Color.decode("#ff6947"), Color.decode("#ff9a22"), Color.decode("#ffc700")};
            this.yAxisHz = new double[]{0.0, 427.246, 854.492, 1281.74, 1708.98, 2136.23, 2563.48, 2990.72, 3417.97, 3845.21, 4272.46, 4699.71, 5126.95, 5554.2, 5981.45, 6408.69, 6835.94, 7263.18, 7690.43, 8117.68, 8544.92, 8972.17, 9399.41, 9826.66, 10253.9, 10681.2, 11108.4, 11535.6, 11962.9, 12390.1, 12817.4, 13244.6, 13671.9, 14099.1, 14526.4, 14953.6, 15380.9, 15808.1, 16235.4, 16662.6, 17089.8, 17517.1, 17944.3, 18371.6, 18798.8, 19226.1, 19653.3, 20080.6, 20507.8, 20935.1, 21362.3, 21789.6, 22216.8, 22644.0, 23071.3, 23498.5, 23925.8, 24353.0, 24780.3, 25207.5};
            this.spectrogramYAxisSize = this.yAxisHz.length;
            this.specrtogram = new float[this.SPECTROGRAM_X_AXIS_SIZE][this.spectrogramYAxisSize];
            this.colors = new Color[this.spectrogramYAxisSize];
            this.amplitudesInColorSpace = new float[this.spectrogramYAxisSize];
        }

        private void processValues(String values) {
            char base64Size;
            char sizec;
            String[] first_split = values.split("\\*");
            String freq_str = first_split[0];
            this.mainFrequency = Float.parseFloat(freq_str);
            String compressed = first_split[1];
            char size_data = sizec = compressed.charAt(0);
            char b64size = base64Size = compressed.charAt(1);
            String base64 = compressed.substring(2, b64size + 2);
            byte[] data = Base64.getDecoder().decode(base64);
            assert (size_data == compressed.length() - 1);
            assert (size_data == this.yAxisHz.length);
            if (compressed.length() - 1 < this.spectrogramYAxisSize) {
                log.error("data size error: " + compressed.length());
                return;
            }
            for (int i = 0; i < this.spectrogramYAxisSize; ++i) {
                byte c = data[i];
                int k = c + 128;
                this.specrtogram[this.currentIndexXAxis][i] = k;
            }
            int width = this.bufferedImage.getWidth();
            int height = this.bufferedImage.getHeight();
            float bx = (float)width / (float)this.SPECTROGRAM_X_AXIS_SIZE;
            float min = 2.1474836E9f;
            float max = 0.0f;
            for (int x = 0; x < this.SPECTROGRAM_X_AXIS_SIZE; ++x) {
                for (int y = 0; y < this.spectrogramYAxisSize; ++y) {
                    float value = this.specrtogram[x][y];
                    if (value < min) {
                        min = value;
                    }
                    if (!(value > max)) continue;
                    max = value;
                }
            }
            for (int y = 0; y < this.spectrogramYAxisSize; ++y) {
                Color color;
                float value = this.specrtogram[this.currentIndexXAxis][y];
                double lvalue = value;
                double lmin = min;
                double lmax = max;
                double normalized = 0.0;
                if (lmax - lmin != 0.0) {
                    normalized = (lvalue - lmin) / (lmax - lmin);
                }
                if (normalized > 1.0) {
                    normalized = 1.0;
                }
                if (normalized < 0.0) {
                    normalized = 0.0;
                }
                int color_index = (int)((double)(this.colorspace.length - 1) * normalized);
                this.colors[this.spectrogramYAxisSize - 1 - y] = color = this.colorspace[color_index];
                this.amplitudesInColorSpace[y] = (float)y / (float)this.spectrogramYAxisSize;
            }
            LinearGradientPaint lgp = new LinearGradientPaint(new Point2D.Float(0.0f, 0.0f), new Point2D.Float(0.0f, height), this.amplitudesInColorSpace, this.colors);
            this.bufferedGraphics.setPaint(lgp);
            this.bufferedGraphics.fillRect((int)((float)this.currentIndexXAxis * bx), 0, (int)bx, height);
            ++this.currentIndexXAxis;
            if (this.currentIndexXAxis >= this.SPECTROGRAM_X_AXIS_SIZE) {
                this.currentIndexXAxis = 0;
            }
        }

        double lerp(double start, double end, double t) {
            return start * (1.0 - t) + end * t;
        }

        private int searchHZ(double[] a, int fromIndex, int toIndex, double key) {
            int low = fromIndex;
            int high = toIndex - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                double midVal = a[mid];
                if (midVal < key) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > key) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return low;
        }

        int hzToYScreen(double hz, int screen_height) {
            int near_hz_index = this.searchHZ(this.yAxisHz, 0, this.yAxisHz.length - 1, hz);
            int a = near_hz_index - 1;
            int b = near_hz_index;
            if (a < 0 || b > this.yAxisHz.length - 1) {
                return -1;
            }
            double a_value = this.yAxisHz[a];
            double b_value = this.yAxisHz[b];
            double t = (hz - a_value) / (b_value - a_value);
            double y_step = (double)screen_height / (double)this.yAxisHz.length;
            double a_screen = y_step * (double)a;
            double b_screen = y_step * (double)b;
            double y_screen = this.lerp(a_screen, b_screen, t);
            return screen_height - (int)y_screen;
        }

        float YScreenToHz(int y, int screen_height) {
            return 0.0f;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Dimension size = this.getSize();
            g.drawImage(this.bufferedImage, 0, 0, size.width, size.height, null);
            int width = this.bufferedImage.getWidth();
            int height = this.bufferedImage.getHeight();
            float bx = (float)width / (float)this.SPECTROGRAM_X_AXIS_SIZE;
            g.setColor(Color.RED);
            int line = (int)((float)this.currentIndexXAxis * bx);
            g.drawLine(line, 0, line, height);
            for (int i = 0; i < this.yAxisHz.length; ++i) {
                int y = this.hzToYScreen(this.yAxisHz[i], height);
                g.setColor(Color.WHITE);
                g.fillRect(0, y, 30, 3);
            }
            Font f = g.getFont();
            g.setFont(new Font(f.getName(), 1, g.getFont().getSize() * 10));
            g.setColor(Color.RED);
            g.drawString(Float.valueOf(this.mainFrequency).toString() + " Hz", width / 2, 100);
            g.setFont(f);
            g.setColor(Color.WHITE);
            int yy = this.hzToYScreen(this.mainFrequency, height);
            g.fillRect(0, yy, width, 1);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            this.bufferedGraphics = this.bufferedImage.createGraphics();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    public class KnockKeListener
    extends KeyAdapter
    implements ActionListener {
        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 39) {
                // empty if block
            }
            if (e.getKeyCode() == 38) {
                // empty if block
            }
            if (e.getKeyCode() == 37) {
                // empty if block
            }
            if (e.getKeyCode() == 40) {
                // empty if block
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

