/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public enum LcdImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private Rectangle2D boundsBuffer = new Rectangle2D.Double();
    private LcdColor lcdColorBuffer = LcdColor.WHITE_LCD;
    private Paint customLcdBackgroundBuffer = Color.RED;
    private BufferedImage lcdImageBuffer = this.UTIL.createImage(1, 1, 3);

    public BufferedImage create_LCD_Image(Rectangle2D BOUNDS, LcdColor LCD_COLOR, Paint CUSTOM_LCD_BACKGROUND, BufferedImage BACKGROUND_IMAGE) {
        if (BOUNDS.getWidth() <= 0.0 || BOUNDS.getHeight() <= 0.0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (BOUNDS.equals(this.boundsBuffer) && LCD_COLOR == this.lcdColorBuffer && CUSTOM_LCD_BACKGROUND == this.customLcdBackgroundBuffer) {
            if (BACKGROUND_IMAGE != null && this.lcdImageBuffer.getWidth() == BACKGROUND_IMAGE.getWidth()) {
                Graphics2D G = BACKGROUND_IMAGE.createGraphics();
                G.drawImage((Image)this.lcdImageBuffer, 0, 0, null);
                G.dispose();
            }
            return this.lcdImageBuffer;
        }
        this.lcdImageBuffer.flush();
        this.lcdImageBuffer = BACKGROUND_IMAGE != null ? this.UTIL.createImage(BACKGROUND_IMAGE.getWidth(), BACKGROUND_IMAGE.getHeight(), 3) : this.UTIL.createImage((int)BOUNDS.getWidth(), (int)BOUNDS.getHeight(), 3);
        Graphics2D G2 = this.lcdImageBuffer.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Point2D.Double BACKGROUND_START = new Point2D.Double(0.0, BOUNDS.getMinY());
        Point2D.Double BACKGROUND_STOP = new Point2D.Double(0.0, BOUNDS.getMaxY());
        if (BACKGROUND_START.equals(BACKGROUND_STOP)) {
            ((Point2D)BACKGROUND_STOP).setLocation(0.0, ((Point2D)BACKGROUND_START).getY() + 1.0);
        }
        float[] BACKGROUND_FRACTIONS = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] BACKGROUND_COLORS = new Color[]{new Color(0.3f, 0.3f, 0.3f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint BACKGROUND_GRADIENT = new LinearGradientPaint(BACKGROUND_START, BACKGROUND_STOP, BACKGROUND_FRACTIONS, BACKGROUND_COLORS);
        double BACKGROUND_CORNER_RADIUS = BOUNDS.getWidth() > BOUNDS.getHeight() ? BOUNDS.getHeight() * 0.12 : BOUNDS.getWidth() * 0.12;
        RoundRectangle2D.Double BACKGROUND = new RoundRectangle2D.Double(BOUNDS.getMinX(), BOUNDS.getMinY(), BOUNDS.getWidth(), BOUNDS.getHeight(), BACKGROUND_CORNER_RADIUS, BACKGROUND_CORNER_RADIUS);
        G2.setPaint(BACKGROUND_GRADIENT);
        G2.fill(BACKGROUND);
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, BOUNDS.getMinY() + 1.0);
        Point2D.Double FOREGROUND_STOP = new Point2D.Double(0.0, BOUNDS.getMaxY() - 1.0);
        if (FOREGROUND_START.equals(FOREGROUND_STOP)) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLOR.GRADIENT_START_COLOR, LCD_COLOR.GRADIENT_FRACTION1_COLOR, LCD_COLOR.GRADIENT_FRACTION2_COLOR, LCD_COLOR.GRADIENT_FRACTION3_COLOR, LCD_COLOR.GRADIENT_STOP_COLOR};
        if (LCD_COLOR == LcdColor.CUSTOM) {
            G2.setPaint(CUSTOM_LCD_BACKGROUND);
        } else {
            LinearGradientPaint FOREGROUND_GRADIENT = new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
            G2.setPaint(FOREGROUND_GRADIENT);
        }
        double FOREGROUND_CORNER_RADIUS = ((RoundRectangle2D)BACKGROUND).getArcWidth() - 1.0;
        RoundRectangle2D.Double FOREGROUND = new RoundRectangle2D.Double(BOUNDS.getMinX() + 1.0, BOUNDS.getMinY() + 1.0, BOUNDS.getWidth() - 2.0, BOUNDS.getHeight() - 2.0, FOREGROUND_CORNER_RADIUS, FOREGROUND_CORNER_RADIUS);
        G2.fill(FOREGROUND);
        G2.dispose();
        if (BACKGROUND_IMAGE != null) {
            Graphics2D G = BACKGROUND_IMAGE.createGraphics();
            G.drawImage((Image)this.lcdImageBuffer, 0, 0, null);
            G.dispose();
        }
        this.boundsBuffer.setRect(BOUNDS);
        this.lcdColorBuffer = LCD_COLOR;
        this.customLcdBackgroundBuffer = CUSTOM_LCD_BACKGROUND;
        return this.lcdImageBuffer;
    }
}

