/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.io;

import com.devexperts.logging.Logging;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleUtil {
    private static final Logging log = Logging.getLogging(BundleUtil.class);
    private static final char BUNDLE_TOKEN_SEPARATOR = '.';
    private static final String SNAPSHOT = "snapshot";

    @Nullable
    public static String readBundleFullName() {
        try {
            Path path = Paths.get("", new String[0]).toAbsolutePath();
            String fullName = path.getParent().getFileName().toString();
            if (fullName.length() < 3) {
                return null;
            }
            return fullName;
        }
        catch (InvalidPathException e) {
            log.error("Error reading bundle name", e);
            return null;
        }
    }

    @NotNull
    public static String readBundleFullNameNotNull() {
        String bundle = BundleUtil.readBundleFullName();
        bundle = bundle == null ? "unknown bundle" : bundle;
        return bundle;
    }

    public static String getBundleTarget() {
        return BundleUtil.getBundleTarget(BundleUtil.readBundleFullName());
    }

    public static BundleInfo parse(String bundleFullName) {
        String[] bundleFullNameSplit = bundleFullName.split("\\.");
        if (bundleFullNameSplit.length != 3) {
            throw new IllegalStateException("Unexpected parent folder name/bundleFullName [" + bundleFullName + "] exactly two dots expected");
        }
        String branchName = bundleFullNameSplit[1];
        String target = bundleFullNameSplit[2];
        return new BundleInfo(branchName, target);
    }

    public static String getBundleTarget(String s) {
        return BundleUtil.parse(s).getTarget();
    }

    public static class BundleInfo {
        private final String branchName;
        private final String target;

        public BundleInfo(String branchName, String target) {
            this.branchName = branchName;
            this.target = target;
        }

        public String getBranchName() {
            return this.branchName;
        }

        public boolean isMaster() {
            return BundleUtil.SNAPSHOT.equals(this.branchName);
        }

        public String getTarget() {
            return this.target;
        }

        public String toString() {
            return "BundleInfo{branchName='" + this.branchName + "', target='" + this.target + "'}";
        }
    }
}

