/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.can;

import com.devexperts.logging.Logging;
import com.opensr5.io.DataListener;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.io.IoStream;
import com.rusefi.io.can.SocketCANHelper;
import com.rusefi.io.can.isotp.IsoTpCanDecoder;
import com.rusefi.io.can.isotp.IsoTpConnector;
import com.rusefi.io.serial.AbstractIoStream;
import com.rusefi.io.tcp.BinaryProtocolServer;
import com.rusefi.uds.CanConnector;
import com.rusefi.util.HexBinary;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.Nullable;
import tel.schich.javacan.RawCanChannel;

public class SocketCANIoStream
extends AbstractIoStream {
    static Logging log = Logging.getLogging(SocketCANIoStream.class);
    private final IncomingDataBuffer dataBuffer;
    private final RawCanChannel socket;
    private final IsoTpCanDecoder canDecoder = new IsoTpCanDecoder(){

        @Override
        protected void onTpFirstFrame() {
            SocketCANIoStream.this.sendCanPacket(FLOW_CONTROL);
        }
    };
    private final IsoTpConnector isoTpConnector = new IsoTpConnector(1808){

        @Override
        public void sendCanData(byte[] total) {
            SocketCANIoStream.this.sendCanPacket(total);
        }
    };

    private void sendCanPacket(byte[] total) {
        if (log.debugEnabled()) {
            log.debug("-------sendIsoTp " + total.length + " byte(s):");
        }
        if (log.debugEnabled()) {
            log.debug("Sending " + HexBinary.printHexBinary(total));
        }
        SocketCANHelper.send(this.isoTpConnector.canId(), total, this.socket);
    }

    public SocketCANIoStream() {
        this.socket = SocketCANHelper.createSocket();
        this.dataBuffer = this.createDataBuffer();
    }

    @Nullable
    public static SocketCANIoStream create() {
        return new SocketCANIoStream();
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        IsoTpConnector.sendStrategy(bytes, this.isoTpConnector);
    }

    @Override
    public void setInputListener(DataListener listener) {
        ExecutorService threadExecutor = Executors.newSingleThreadExecutor(BinaryProtocolServer.getThreadFactory("SocketCAN reader"));
        threadExecutor.execute(() -> {
            while (!this.isClosed()) {
                this.readOnePacket(listener);
            }
        });
    }

    private void readOnePacket(DataListener listener) {
        try {
            CanConnector.CanPacket rx = SocketCANHelper.read(this.socket);
            if (rx.id() != 1824) {
                if (log.debugEnabled()) {
                    log.debug("Skipping non " + String.format("%X", 1824) + " packet: " + String.format("%X", rx.id()));
                }
                return;
            }
            byte[] decode = this.canDecoder.decodePacket(rx.payload());
            listener.onDataArrived(decode);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public IncomingDataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public static IoStream createStream() {
        return new SocketCANIoStream();
    }
}

