/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.console;

import com.devexperts.logging.Logging;
import com.rusefi.ConsoleUI;
import com.rusefi.IoUtil;
import com.rusefi.Launcher;
import com.rusefi.SimulatorHelper;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.EngineState;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.ConnectionFailedListener;
import com.rusefi.io.ConnectionStateListener;
import com.rusefi.io.ConnectionStatusLogic;
import com.rusefi.io.ConnectionStatusValue;
import com.rusefi.io.ConnectionWatchdog;
import com.rusefi.io.InvocationConfirmationListener;
import com.rusefi.io.LinkManager;
import com.rusefi.io.tcp.BinaryProtocolServer;
import com.rusefi.maintenance.VersionChecker;
import com.rusefi.ui.console.TabbedPanel;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.util.IoUtils;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MainFrame {
    private static final Logging log = Logging.getLogging(Launcher.class);
    @NotNull
    private final ConsoleUI consoleUI;
    private final TabbedPanel tabbedPane;
    private final FrameHelper frame = new FrameHelper(){

        @Override
        protected void onWindowOpened() {
            log.info("onWindowOpened");
            MainFrame.this.windowOpenedHandler();
        }

        @Override
        protected void onWindowClosed() {
            MainFrame.this.windowClosedHandler();
            log.info("onWindowClosed");
        }
    };
    public final ConnectionFailedListener listener;

    public MainFrame(ConsoleUI consoleUI, TabbedPanel tabbedPane) {
        this.consoleUI = Objects.requireNonNull(consoleUI);
        this.tabbedPane = tabbedPane;
        this.listener = s -> {};
    }

    private void windowOpenedHandler() {
        this.setTitle();
        ConnectionStatusLogic.INSTANCE.addListener(isConnected -> SwingUtilities.invokeLater(() -> {
            this.setTitle();
            UiUtils.trueRepaint(this.tabbedPane.tabbedPane);
            if (ConnectionStatusLogic.INSTANCE.getValue() == ConnectionStatusValue.CONNECTED) {
                LocalDateTime dateTime = LocalDateTime.now(ZoneOffset.systemDefault());
                String isoDateTime = dateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                this.consoleUI.uiContext.getLinkManager().execute(() -> this.consoleUI.uiContext.getCommandQueue().write(IoUtil.getSetCommand("date") + " " + isoDateTime, CommandQueue.DEFAULT_TIMEOUT, InvocationConfirmationListener.VOID, false));
            }
        }));
        final LinkManager linkManager = this.consoleUI.uiContext.getLinkManager();
        linkManager.getConnector().connectAndReadConfiguration(new BinaryProtocol.Arguments(true), new ConnectionStateListener(){

            @Override
            public void onConnectionFailed(String errorMessage) {
                log.error("onConnectionFailed " + errorMessage);
                String message = "This copy of rusEFI console is not compatible with this version of firmware\r\n" + errorMessage;
                JOptionPane.showMessageDialog(MainFrame.this.frame.getFrame(), message);
            }

            @Override
            public void onConnectionEstablished() {
                ConnectionWatchdog.init(linkManager);
                SwingUtilities.invokeLater(() -> {
                    MainFrame.this.tabbedPane.settingsTab.showContent(linkManager);
                    MainFrame.this.tabbedPane.logsManager.showContent();
                    new BinaryProtocolServer().start(linkManager);
                });
            }
        });
        this.consoleUI.uiContext.getLinkManager().getEngineState().registerStringValueAction("rusEfiVersion", new EngineState.ValueCallback<String>(){

            @Override
            public void onUpdate(String firmwareVersion) {
                Launcher.firmwareVersion.set(firmwareVersion);
                MainFrame.this.setTitle();
                VersionChecker.getInstance().onFirmwareVersion(firmwareVersion);
            }
        });
    }

    public FrameHelper getFrame() {
        return this.frame;
    }

    private void setTitle() {
        String frameTitle;
        String consoleVersion = "Console 20241031";
        if (ConnectionStatusLogic.INSTANCE.isConnected()) {
            BinaryProtocol bp = this.consoleUI.uiContext.getLinkManager().getCurrentStreamState();
            String signature = bp == null ? "not loaded" : bp.signature;
            frameTitle = consoleVersion + "; firmware=" + (String)Launcher.firmwareVersion.get() + "@" + this.consoleUI.getPort() + " " + signature;
            this.frame.getFrame().setTitle(frameTitle);
        } else {
            frameTitle = "DISCONNECTED " + consoleVersion;
        }
        this.frame.getFrame().setTitle(frameTitle);
    }

    private void windowClosedHandler() {
        SimulatorHelper.onWindowClosed();
        Node root = PersistentConfiguration.getConfig().getRoot();
        root.setProperty("version", 20241031);
        root.setProperty("main_tab", this.tabbedPane.tabbedPane.getSelectedIndex());
        this.consoleUI.uiContext.DetachedRepositoryINSTANCE.saveConfig();
        PersistentConfiguration.getConfig().save();
        BinaryProtocol bp = this.consoleUI.uiContext.getLinkManager().getCurrentStreamState();
        if (bp != null && !bp.isClosed()) {
            bp.close();
        }
        IoUtils.exit("windowClosedHandler", 0);
    }
}

