/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.tracing;

import com.rusefi.tracing.EnumNames;
import com.rusefi.tracing.Phase;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Entry {
    private static final double MAGIC_NT = 168.0;
    private final String name;
    private final Phase phase;
    private final int isr;
    private final int thread;
    private double timestampSeconds;

    public Entry(String name, Phase phase, double timestampSeconds, int isr, int thread) {
        this.name = name;
        this.phase = phase;
        this.isr = isr;
        this.thread = thread;
        this.timestampSeconds = timestampSeconds;
    }

    private static void AppendKeyValuePair(StringBuilder sb, String x, String y) {
        sb.append('\"');
        sb.append(x);
        sb.append("\":\"");
        sb.append(y);
        sb.append('\"');
    }

    private static void AppendKeyValuePair(StringBuilder sb, String x, int y) {
        sb.append('\"');
        sb.append(x);
        sb.append("\":");
        sb.append(y);
    }

    private static void AppendKeyValuePair(StringBuilder sb, String x, double y) {
        sb.append('\"');
        sb.append(x);
        sb.append("\":");
        sb.append(y);
    }

    public static int readInt(DataInputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
    }

    public static List<Entry> parseBuffer(byte[] packet) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        double minValue = Double.MAX_VALUE;
        try {
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(packet));
            is.readByte();
            int firstTimeStamp = 0;
            for (int i = 0; i < packet.length - 1; i += 8) {
                byte type = is.readByte();
                byte phase = is.readByte();
                byte isr = is.readByte();
                byte thread = is.readByte();
                int timestampNt = Entry.readInt(is);
                if (i == 0) {
                    firstTimeStamp = timestampNt;
                } else if (timestampNt < firstTimeStamp) {
                    System.out.println("Dropping the remainder of the packet at " + i + " due to " + timestampNt + " below " + firstTimeStamp);
                    break;
                }
                double timestampSeconds = (double)timestampNt / 168.0;
                minValue = Math.min(minValue, timestampSeconds);
                String name = type == 1 ? "ISR: " + thread : EnumNames.TypeNames[type];
                Entry e = new Entry(name, Phase.decode(phase), timestampSeconds, isr, thread);
                result.add(e);
            }
            for (Entry e : result) {
                e.adjustTimestamp(minValue);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    private void adjustTimestamp(double minValue) {
        this.timestampSeconds -= minValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Entry.AppendKeyValuePair(sb, "name", this.name);
        sb.append(",");
        Entry.AppendKeyValuePair(sb, "ph", this.phase.toString());
        sb.append(",");
        Entry.AppendKeyValuePair(sb, "tid", this.thread);
        sb.append(",");
        Entry.AppendKeyValuePair(sb, "pid", this.isr);
        sb.append(",");
        Entry.AppendKeyValuePair(sb, "ts", this.timestampSeconds);
        sb.append("}");
        return sb.toString();
    }
}

