/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.lua;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.rusefi.ConnectionTab;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.config.generated.Fields;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.io.ConnectionStatusLogic;
import com.rusefi.io.LinkManager;
import com.rusefi.ui.MessagesPanel;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.lua.CompatibilityFiles;
import com.rusefi.ui.lua.LuaIncludeSyntax;
import com.rusefi.ui.lua.TextEditor;
import com.rusefi.ui.util.URLLabel;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.AnyCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import neoe.formatter.lua.LuaFormatter;
import org.jetbrains.annotations.NotNull;

public class LuaScriptPanel {
    private static final Logging log = Logging.getLogging(LuaScriptPanel.class);
    private static final String SCRIPT_FOLDER_CONFIG_KEY = "SCRIPT_FOLDER";
    private final UIContext context;
    private final Node config;
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private final AnyCommand command;
    private final TextEditor scriptText = new TextEditor();
    private final MessagesPanel mp;

    public LuaScriptPanel(UIContext context, Node config) {
        this.context = context;
        this.config = config;
        ConnectionTab.installConnectAndDisconnect(context, this.mainPanel);
        this.command = AnyCommand.createField(context, config, true, true);
        JPanel upperPanel = new JPanel(new FlowLayout(0, 5, 0));
        JButton writeButton = new JButton("Write to ECU");
        JButton burnButton = new JButton("Burn to ECU");
        this.mp = new MessagesPanel(null, config);
        this.mp.getMessagesView().listener = message -> {
            if (message.contains("BEEP")) {
                Toolkit.getDefaultToolkit().beep();
            }
        };
        writeButton.addActionListener(e -> this.writeScriptToEcu());
        burnButton.addActionListener(e -> {
            LinkManager linkManager = context.getLinkManager();
            linkManager.submit(() -> {
                BinaryProtocol bp = linkManager.getCurrentStreamState();
                bp.burn();
            });
        });
        final JButton moreButton = new JButton("More...");
        moreButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                JMenuItem loadFromDisc;
                JPopupMenu menu = new JPopupMenu();
                JMenuItem format = new JMenuItem("Format Script");
                format.addActionListener(e -> LuaScriptPanel.this.formatScript());
                JMenuItem reset = new JMenuItem("Reset Lua");
                reset.addActionListener(e -> LuaScriptPanel.this.resetLua());
                String scriptName = LuaIncludeSyntax.getScriptName(LuaScriptPanel.this.getScript());
                if (scriptName == null) {
                    loadFromDisc = new JMenuItem("Script name not specified");
                    loadFromDisc.setEnabled(false);
                } else if (!new File(LuaScriptPanel.this.getScriptFullFileName()).exists()) {
                    loadFromDisc = new JMenuItem(scriptName + " not found in " + LuaScriptPanel.this.getWorkingFolder());
                    loadFromDisc.setEnabled(false);
                } else {
                    loadFromDisc = new JMenuItem("Reload " + scriptName);
                    loadFromDisc.addActionListener(e -> LuaScriptPanel.this.reloadFromDisc());
                }
                JMenuItem selectFolder = LuaScriptPanel.this.createSelectFolderMenuItem();
                menu.add(format);
                menu.add(reset);
                menu.add(new JSeparator());
                menu.add(loadFromDisc);
                menu.add(selectFolder);
                menu.show(moreButton, me.getX(), me.getY());
            }
        });
        upperPanel.add(writeButton);
        upperPanel.add(burnButton);
        upperPanel.add(moreButton);
        upperPanel.add(this.command.getContent());
        upperPanel.add(new URLLabel("Lua Wiki", "https://github.com/rusefi/rusefi/wiki/Lua-Scripting"));
        JPanel scriptPanel = new JPanel(new BorderLayout());
        scriptPanel.add((Component)this.scriptText.getControl(), "Center");
        JPanel messagesPanel = new JPanel(new BorderLayout());
        messagesPanel.add("North", this.mp.getButtonPanel());
        messagesPanel.add("Center", this.mp.getMessagesScroll());
        ConnectionStatusLogic.INSTANCE.addListener(isConnected -> SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LuaScriptPanel.this.readFromECU();
                }
                catch (Throwable e) {
                    System.out.println(e);
                }
            }
        }));
        JSplitPane centerPanel = new JSplitPane(1, scriptPanel, messagesPanel);
        this.mainPanel.add((Component)upperPanel, "North");
        this.mainPanel.add((Component)centerPanel, "Center");
        UiUtils.trueLayout(this.mainPanel);
        SwingUtilities.invokeLater(() -> centerPanel.setDividerLocation(centerPanel.getSize().width / 2));
    }

    private String getScriptFullFileName() {
        String scriptName = LuaIncludeSyntax.getScriptName(this.getScript());
        if (scriptName == null) {
            return null;
        }
        return this.getWorkingFolder() + File.separator + scriptName;
    }

    private void reloadFromDisc() {
        String fullFileName = this.getScriptFullFileName();
        if (fullFileName == null) {
            return;
        }
        System.out.println("Reading " + fullFileName);
        try {
            File file = new File(fullFileName);
            log.info("Reloading " + file.getAbsolutePath());
            String discContent = CompatibilityFiles.readString(file.toPath());
            String newLua = LuaIncludeSyntax.reloadScript(discContent, name -> {
                String includeFullName = this.getWorkingFolder() + File.separator + name;
                File includeFile = new File(includeFullName);
                log.info("Reading " + includeFile.getAbsolutePath());
                try {
                    String string = CompatibilityFiles.readString(includeFile.toPath());
                    log.info("Got " + string.length() + " bytes");
                    return string;
                }
                catch (IOException e) {
                    log.error("ERROR ", e);
                    return "ERROR reading " + name + ": " + e.getMessage();
                }
            });
            if (newLua.length() >= 10100) {
                this.setText(newLua.length() + " bytes would not fit sorry current limit " + 10100);
            } else {
                this.setText(newLua);
                this.writeScriptToEcu();
            }
        }
        catch (IOException e) {
            System.err.println("Error " + e);
        }
    }

    @NotNull
    private JMenuItem createSelectFolderMenuItem() {
        JMenuItem selectFolder = new JMenuItem("Select Working Folder");
        selectFolder.addActionListener(e -> {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File(this.getWorkingFolder()));
            fc.setFileSelectionMode(1);
            int returnVal = fc.showSaveDialog(selectFolder);
            if (returnVal == 0) {
                String newWorkingFolder = fc.getSelectedFile().getPath();
                this.config.setProperty(SCRIPT_FOLDER_CONFIG_KEY, newWorkingFolder);
            }
        });
        return selectFolder;
    }

    private void formatScript() {
        String sourceCode = this.getScript();
        try {
            String formatted = new LuaFormatter().format(sourceCode, new LuaFormatter.Env());
            this.setText(formatted);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setText(String luaScript) {
        this.scriptText.setText(luaScript);
    }

    private String getWorkingFolder() {
        return this.config.getProperty(SCRIPT_FOLDER_CONFIG_KEY, System.getProperty("user.home"));
    }

    public JPanel getPanel() {
        return this.mainPanel;
    }

    public ActionListener getTabSelectedListener() {
        return e -> {
            if (this.command != null) {
                this.command.requestFocus();
            }
        };
    }

    void readFromECU() {
        BinaryProtocol bp = this.context.getLinkManager().getCurrentStreamState();
        if (bp == null) {
            this.setText("No ECU located");
            return;
        }
        ConfigurationImage image = bp.getControllerConfiguration();
        if (image == null) {
            this.setText("No configuration image");
            return;
        }
        ByteBuffer luaScriptBuffer = image.getByteBuffer(Fields.LUASCRIPT.getOffset(), 10100);
        byte[] scriptArr = new byte[10100];
        luaScriptBuffer.get(scriptArr);
        int i = LuaScriptPanel.findNullTerminator(scriptArr);
        this.setText(new String(scriptArr, 0, i, StandardCharsets.US_ASCII));
    }

    private static int findNullTerminator(byte[] scriptArr) {
        int i;
        for (i = 0; i < scriptArr.length && scriptArr[i] != 0; ++i) {
        }
        return i;
    }

    private void writeScriptToEcu() {
        String script = this.getScript();
        LinkManager linkManager = this.context.getLinkManager();
        linkManager.submit(() -> {
            int thisWrite;
            BinaryProtocol bp = linkManager.getCurrentStreamState();
            byte[] paddedScript = new byte[10100];
            byte[] scriptBytes = script.getBytes(StandardCharsets.US_ASCII);
            System.arraycopy(scriptBytes, 0, paddedScript, 0, scriptBytes.length);
            int idx = 0;
            do {
                int remaining = paddedScript.length - idx;
                thisWrite = Math.min(remaining, 750);
                bp.writeData(paddedScript, idx, Fields.LUASCRIPT.getOffset() + idx, thisWrite);
                idx += thisWrite;
            } while ((remaining -= thisWrite) > 0);
            this.resetLua();
        });
        this.mp.setPaused(false);
    }

    private String getScript() {
        String script = this.scriptText.getText();
        return script;
    }

    void resetLua() {
        this.context.getCommandQueue().write("luareset");
    }
}

