/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini;

import com.opensr5.ini.IniFileReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawIniFile {
    private final List<Line> lines;
    private final Map<String, Line> asSet = new TreeMap<String, Line>(String.CASE_INSENSITIVE_ORDER);

    public RawIniFile(List<Line> lines) {
        this.lines = lines;
        for (Line line : lines) {
            if (line.tokens.length <= 1) continue;
            this.asSet.put(line.tokens[0], line);
        }
    }

    public static RawIniFile read(String fileName) throws FileNotFoundException {
        return IniFileReader.read(new FileInputStream(fileName));
    }

    @NotNull
    public Line getMandatoryLine(String key) {
        Line result = this.getByKey(key);
        if (result == null) {
            throw new IllegalStateException("Line not found: " + key);
        }
        assert (result.tokens.length > 1);
        return result;
    }

    @Nullable
    public Line getByKey(String key) {
        return this.asSet.get(key);
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public int getSimpleIntegerProperty(String key) {
        Line line = this.asSet.get(key);
        if (line == null) {
            throw new IllegalStateException("Line not found: " + key);
        }
        String value = line.getTokens()[1];
        return Integer.parseInt(value);
    }

    public int getSimpleIntegerProperty(String key, int defaultValue) {
        if (!this.asSet.containsKey(key)) {
            return defaultValue;
        }
        return this.getSimpleIntegerProperty(key);
    }

    public List<String> getValues(String key) {
        Line line = this.getMandatoryLine(key);
        return Arrays.asList(line.getTokens()).subList(1, line.getTokens().length);
    }

    public static class Line {
        private String rawText;
        private String[] tokens;
        private static final String namePattern = "[[\\w\\d\\s_]]+";
        private static final Pattern DIRECTIVE = Pattern.compile("#(if\\s[[\\w\\d\\s_]]+|else|elif\\s\" + namePattern + \"|endif)");

        public Line(String rawText) {
            this.rawText = rawText;
            this.tokens = IniFileReader.splitTokens(rawText);
        }

        public String[] getTokens() {
            return this.tokens;
        }

        public static boolean isCommentLine(String rawText) {
            return rawText.trim().startsWith(";");
        }

        public static boolean isPreprocessorDirective(String rawText) {
            Matcher matcher = DIRECTIVE.matcher(rawText);
            return matcher.matches();
        }

        public String getRawText() {
            return this.rawText;
        }

        public String toString() {
            return "Line{rawText='" + this.rawText + '\'' + ", tokens=" + Arrays.toString(this.tokens) + '}';
        }
    }
}

