/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.devexperts.logging.Logging;
import com.rusefi.ReaderState;
import com.rusefi.ldmp.LiveDataProcessor;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.TsOutput;
import com.rusefi.util.LazyFile;
import java.io.IOException;

public class OutputsSectionConsumer
implements ConfigurationConsumer {
    private static final Logging log = Logging.getLogging(OutputsSectionConsumer.class);
    private final String tsOutputsSectionFileName;
    private final LazyFile.LazyFileFactory fileFactory;
    private final TsOutput tsOutput;
    public String[] outputNames = new String[]{""};
    private int sensorTsPosition;

    public OutputsSectionConsumer(String tsOutputsSectionFileName, LazyFile.LazyFileFactory fileFactory) {
        this.tsOutputsSectionFileName = tsOutputsSectionFileName;
        this.fileFactory = fileFactory;
        this.tsOutput = new TsOutput(false);
    }

    public String getContent() {
        return this.tsOutput.getContent();
    }

    public int getBaseOffset() {
        return this.sensorTsPosition;
    }

    @Override
    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
        log.info("handleEndStruct");
        for (int i = 0; i < LiveDataProcessor.tempLimit(this.outputNames); ++i) {
            String temporaryLineComment = LiveDataProcessor.needComment(i) ? ";" : "";
            String variableNameSuffix = this.outputNames.length > 1 ? Integer.toString(i) : "";
            this.sensorTsPosition = this.tsOutput.run(readerState, structure, this.sensorTsPosition, temporaryLineComment, variableNameSuffix);
            if (!readerState.isStackEmpty() || this.tsOutputsSectionFileName == null) continue;
            LazyFile fos = this.fileFactory.create(this.tsOutputsSectionFileName);
            fos.write(this.tsOutput.getContent());
            fos.close();
        }
    }
}

