/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import tel.schich.javacan.CanId;
import tel.schich.javacan.JavaCAN;
import tel.schich.javacan.util.BufferHelper;

public class CanFrame {
    public static final byte FD_NO_FLAGS = 0;
    public static final byte FD_FLAG_BIT_RATE_SWITCH = 1;
    public static final byte FD_FLAG_ERROR_STATE_INDICATOR = 2;
    public static final byte FD_FLAG_FD_FRAME = 4;
    public static final int HEADER_LENGTH = 8;
    public static final int MAX_DATA_LENGTH = 8;
    public static final int MAX_FD_DATA_LENGTH = 64;
    private static final int OFFSET_ID = 0;
    private static final int OFFSET_DATA_LENGTH = 4;
    private static final int OFFSET_FLAGS = 5;
    private static final int OFFSET_DATA = 8;
    private final ByteBuffer buffer;
    private final int base;
    private final int size;

    private CanFrame(ByteBuffer buffer) {
        this.buffer = buffer;
        this.base = buffer.position();
        this.size = buffer.remaining();
    }

    public int getId() {
        return CanId.getId(this.getRawId());
    }

    public int getRawId() {
        return this.buffer.getInt(this.base + 0);
    }

    public byte getFlags() {
        return this.buffer.get(this.base + 5);
    }

    public ByteBuffer getBuffer() {
        this.buffer.clear().position(this.base).limit(this.base + this.size);
        return this.buffer;
    }

    public int getBase() {
        return this.base;
    }

    int getDataOffset() {
        return this.base + 8;
    }

    public int getDataLength() {
        return this.buffer.get(this.base + 4);
    }

    public int getMaxDataLength() {
        return this.isFDFrame() ? 64 : 8;
    }

    public int getSize() {
        return this.size;
    }

    public void getData(ByteBuffer dest) {
        int offset = this.getDataOffset();
        int length = this.getDataLength();
        int limit = offset + length;
        int currentLimit = this.buffer.limit();
        this.buffer.position(offset);
        if (dest.remaining() <= length && currentLimit == limit) {
            dest.put(this.buffer);
        } else {
            this.buffer.limit(limit);
            dest.put(this.buffer);
            this.buffer.limit(currentLimit);
        }
    }

    public void getData(byte[] dest, int offset, int length) {
        this.buffer.position(this.getDataOffset());
        this.buffer.get(dest, offset, length);
    }

    public boolean isFDFrame() {
        return this.getFlags() != 0 || this.getDataLength() > 8;
    }

    public boolean isExtended() {
        return CanId.isExtended(this.getRawId());
    }

    public boolean isError() {
        return CanId.isError(this.getRawId());
    }

    public int getError() {
        return CanId.getError(this.getRawId());
    }

    public boolean isRemoteTransmissionRequest() {
        return CanId.isRemoteTransmissionRequest(this.getRawId());
    }

    public CanFrame copy() {
        ByteBuffer view = this.buffer.duplicate();
        ByteBuffer copy = ByteBuffer.allocate(this.size);
        view.position(this.base);
        view.limit(this.base + this.size);
        copy.put(view);
        copy.flip();
        return new CanFrame(copy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Can");
        if (this.isFDFrame()) {
            sb.append("FD");
        }
        int length = this.getDataLength();
        int dataOffset = this.getDataOffset();
        sb.append("Frame(").append("ID=").append(String.format("%02X", this.getId())).append(", ").append("FLAGS=").append(String.format("%X", this.getFlags())).append(", ").append("LEN=").append(length).append(", DATA=[");
        if (length > 0) {
            sb.append(String.format("%02X", this.buffer.get(dataOffset)));
            for (int i = 1; i < length; ++i) {
                sb.append(", ").append(String.format("%02X", this.buffer.get(dataOffset + i)));
            }
        }
        return sb.append("])").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CanFrame)) {
            return false;
        }
        CanFrame b = (CanFrame)o;
        return BufferHelper.equals(this.buffer, this.base, this.size, b.buffer, b.base, b.size);
    }

    public int hashCode() {
        return BufferHelper.hashCode(this.buffer, this.base, this.size);
    }

    public static CanFrame create(int id, byte flags, byte[] data) {
        return CanFrame.create(id, flags, data, 0, data.length);
    }

    public static CanFrame create(int id, byte flags, byte[] data, int offset, int length) {
        return CanFrame.create(id, false, flags, data, offset, length);
    }

    public static CanFrame createExtended(int id, byte flags, byte[] data) {
        return CanFrame.createExtended(id, flags, data, 0, data.length);
    }

    public static CanFrame createExtended(int id, byte flags, byte[] data, int offset, int length) {
        return CanFrame.create(id, true, flags, data, offset, length);
    }

    private static CanFrame create(int id, boolean extended, byte flags, byte[] data, int offset, int length) {
        int preparedId = extended ? id & 0x1FFFFFFF | Integer.MIN_VALUE : id & 0x7FF;
        return CanFrame.createRaw(preparedId, flags, data, offset, length);
    }

    public static CanFrame createRaw(int id, byte flags, byte[] data, int offset, int length) {
        int bufSize = data.length <= 8 ? 16 : 72;
        ByteBuffer buffer = JavaCAN.allocateOrdered(bufSize);
        buffer.putInt(id).put((byte)length).put(flags).putShort((short)0).put(data, offset, length).clear();
        return CanFrame.create(buffer);
    }

    public static CanFrame create(ByteBuffer buffer) {
        CanFrame frame = CanFrame.createUnsafe(buffer);
        int maxDlen = frame.getMaxDataLength();
        int dlen = frame.getDataLength();
        if (dlen > maxDlen) {
            throw new IllegalArgumentException("payload must fit in " + maxDlen + " bytes, but specifies a length of " + dlen + "!");
        }
        return frame;
    }

    public static CanFrame createUnsafe(ByteBuffer buffer) {
        if (buffer.order() != ByteOrder.nativeOrder()) {
            throw new IllegalArgumentException("byte order (" + buffer.order() + ") of the given buffer must be the native order (" + ByteOrder.nativeOrder() + ")!");
        }
        int length = buffer.remaining();
        if (length != 16 && length != 72) {
            throw new IllegalArgumentException("length must be either MTU or FD_MTU, but was " + length + "!");
        }
        return new CanFrame(buffer);
    }
}

