/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CanDumpConverter {
    private static final Pattern LINEPATTERN = Pattern.compile(" \\((\\d+-\\d+-\\d+ \\d+:\\d+:\\d+)(\\.\\d+)\\)\\s+(\\w+)\\s+(\\w+)\\s+\\[\\d\\]\\s+(.+)");
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");

    public static void main(String[] args) throws IOException, ParseException {
        if (args.length < 2) {
            System.out.println("usage: CANDumpConverter <srcFile> <dstFile>");
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(args[0]));
             BufferedWriter writer = new BufferedWriter(new FileWriter(args[1]));){
            String line;
            while ((line = reader.readLine()) != null) {
                CanDumpConverter.processLine(line, writer);
            }
        }
    }

    private static void processLine(String line, BufferedWriter writer) throws ParseException, IOException {
        Matcher matcher = LINEPATTERN.matcher(line);
        if (!matcher.matches()) {
            System.out.println("ignoring line: " + line);
            return;
        }
        StringBuilder builder = new StringBuilder("(");
        builder.append(DATEFORMAT.parse(matcher.group(1)).getTime() / 1000L);
        builder.append(matcher.group(2)).append(") ");
        builder.append(matcher.group(3)).append(' ');
        builder.append(matcher.group(4)).append('#');
        builder.append(matcher.group(5).replaceAll("\\s", ""));
        writer.write(builder.toString());
        writer.newLine();
    }
}

