/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autodetect;

import com.devexperts.logging.Logging;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.io.IoStream;
import com.rusefi.io.commands.HelloCommand;
import com.rusefi.io.serial.BufferedSerialIoStream;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class SerialAutoChecker {
    private static final Logging log = Logging.getLogging(SerialAutoChecker.class);
    private final String serialPort;
    private final CountDownLatch portFound;

    public SerialAutoChecker(String serialPort, CountDownLatch portFound) {
        this.serialPort = serialPort;
        this.portFound = portFound;
    }

    public static String checkResponse(IoStream stream, Function<CallbackContext, Void> callback) {
        if (stream == null) {
            return null;
        }
        IncomingDataBuffer incomingData = stream.getDataBuffer();
        try {
            HelloCommand.send(stream);
            byte[] response = incomingData.getPacket("auto detect");
            if (!IoHelper.checkResponseCode(response)) {
                return null;
            }
            String signature = new String(response, 1, response.length - 1);
            if (!SerialAutoChecker.isSignatureWithValidPrefix(signature)) {
                return null;
            }
            log.info("Got signature=" + signature + " from " + stream);
            if (callback != null) {
                callback.apply(new CallbackContext(stream, signature));
            }
            return signature;
        }
        catch (IOException ignore) {
            return null;
        }
    }

    private static boolean isSignatureWithValidPrefix(String signature) {
        if (signature.startsWith("rusEFI ")) {
            return true;
        }
        String signatureWhiteLabel = ConnectionAndMeta.getSignatureWhiteLabel();
        return signatureWhiteLabel != null && signature.startsWith(signatureWhiteLabel + " ");
    }

    public void openAndCheckResponse(AtomicReference<AutoDetectResult> result, Function<CallbackContext, Void> callback) {
        String signature;
        try (IoStream stream = this.getStreamByMode();){
            signature = SerialAutoChecker.checkResponse(stream, callback);
        }
        if (signature != null) {
            AutoDetectResult value = new AutoDetectResult(this.serialPort, signature);
            log.info("Propagating " + value);
            result.set(value);
            this.portFound.countDown();
        }
    }

    @Nullable
    private IoStream getStreamByMode() {
        return BufferedSerialIoStream.openPort(this.serialPort);
    }

    public static class AutoDetectResult {
        private final String serialPort;
        private final String signature;

        public AutoDetectResult(String serialPort, String signature) {
            this.serialPort = serialPort;
            this.signature = signature;
        }

        @Nullable
        public String getSerialPort() {
            return this.serialPort;
        }

        @Nullable
        public String getSignature() {
            return this.signature;
        }

        public String toString() {
            return "AutoDetectResult{serialPort='" + this.serialPort + '\'' + ", signature='" + this.signature + '\'' + '}';
        }
    }

    public static class CallbackContext {
        private final IoStream stream;
        private final String signature;

        public CallbackContext(IoStream stream, String signature) {
            this.stream = stream;
            this.signature = signature;
        }

        public String getSignature() {
            return this.signature;
        }

        public IoStream getStream() {
            return this.stream;
        }
    }
}

