/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.serial;

import com.devexperts.logging.Logging;
import com.fazecast.jSerialComm.SerialPort;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.io.IoStream;
import com.rusefi.io.serial.SerialIoStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BufferedSerialIoStream
extends SerialIoStream {
    private static final Logging log = Logging.getLogging(BufferedSerialIoStream.class);
    private final IncomingDataBuffer dataBuffer = this.createDataBuffer();

    private BufferedSerialIoStream(@NotNull SerialPort sp, String port) {
        super(sp, port);
    }

    @Override
    public IncomingDataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    @Nullable
    public static IoStream openPort(String port) {
        log.info("[BufferedSerialIoStream] openPort " + port);
        SerialPort serialPort = BufferedSerialIoStream.openSerial(port);
        if (serialPort == null) {
            return null;
        }
        return new BufferedSerialIoStream(serialPort, port);
    }

    public String toString() {
        return "serial=" + this.port;
    }
}

