/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.sensor_logs;

import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.ConnectionStatusLogic;
import com.rusefi.io.ConnectionStatusValue;
import com.rusefi.sensor_logs.BinarySensorLogRestarter;
import com.rusefi.sensor_logs.PlainTextSensorLog;
import com.rusefi.sensor_logs.SensorLog;
import com.rusefi.ui.UIContext;
import java.util.Arrays;
import java.util.List;

public class SensorLogger {
    protected static Sensor[] SENSORS = new Sensor[]{Sensor.RPMValue, Sensor.TIME_SECONDS, Sensor.INT_TEMP, Sensor.CLT, Sensor.TPS, Sensor.VBATT, Sensor.IAT, Sensor.MAF, Sensor.MAP, Sensor.instantMAP, Sensor.Lambda1, Sensor.PPS, Sensor.ETB_CONTROL_QUALITY, Sensor.veValue, Sensor.vvtPositionB1E, Sensor.vvtPositionB2I, Sensor.vvtPositionB2E, Sensor.vvtTargetB1I, Sensor.vvtTargetB1E, Sensor.vvtTargetB2I, Sensor.vvtTargetB2E, Sensor.turboSpeed, Sensor.debugFloatField1, Sensor.debugFloatField2, Sensor.debugFloatField3, Sensor.debugFloatField4, Sensor.debugFloatField5, Sensor.debugFloatField6, Sensor.debugFloatField7, Sensor.debugIntField1, Sensor.debugIntField2, Sensor.debugIntField3, Sensor.debugIntField4, Sensor.debugIntField5, Sensor.wastegatePosition, Sensor.idlePositionSensor, Sensor.lowFuelPressure, Sensor.highFuelPressure, Sensor.totalTriggerErrorCounter, Sensor.lastErrorCode, Sensor.tuneCrc16};
    private final List<SensorLog> sensorLogs;
    private boolean isInitialized;

    public SensorLogger(UIContext uiContext) {
        this.sensorLogs = Arrays.asList(new PlainTextSensorLog(uiContext), new BinarySensorLogRestarter());
    }

    public synchronized void init() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        SensorCentral.getInstance().addListener(Sensor.TIME_SECONDS, value -> {
            if (ConnectionStatusLogic.INSTANCE.getValue() != ConnectionStatusValue.CONNECTED) {
                return;
            }
            for (SensorLog sensorLog : this.sensorLogs) {
                sensorLog.writeSensorLogLine();
            }
        });
    }

    public double getSecondsSinceFileStart() {
        return this.sensorLogs.get(0).getSecondsSinceFileStart();
    }

    static String getSensorName(Sensor sensor, int debugMode) {
        if (sensor == Sensor.debugFloatField1 && SensorLogger.isPidDebugMode(debugMode)) {
            return "PID: output";
        }
        if (sensor == Sensor.debugFloatField2 && SensorLogger.isPidDebugMode(debugMode)) {
            return "PID: I-term";
        }
        if (sensor == Sensor.debugFloatField3 && SensorLogger.isPidDebugMode(debugMode)) {
            return "PID: prevError";
        }
        if (sensor == Sensor.debugFloatField4 && SensorLogger.isPidDebugMode(debugMode)) {
            return "PID: I setting";
        }
        if (sensor == Sensor.debugFloatField5 && SensorLogger.isPidDebugMode(debugMode)) {
            return "PID: D setting";
        }
        if (sensor == Sensor.debugFloatField6 && SensorLogger.isPidDebugMode(debugMode)) {
            return "PID: D-term";
        }
        if (sensor == Sensor.debugIntField1 && SensorLogger.isPidDebugMode(debugMode)) {
            return "PID: P setting";
        }
        if (sensor == Sensor.debugIntField2 && SensorLogger.isPidDebugMode(debugMode)) {
            return "PID: offset";
        }
        if (sensor == Sensor.debugIntField3 && SensorLogger.isPidDebugMode(debugMode)) {
            return "PID: counter";
        }
        if (sensor == Sensor.debugIntField4 && SensorLogger.isPidDebugMode(debugMode)) {
            return "PID: period";
        }
        if (sensor == Sensor.debugIntField5 && SensorLogger.isPidDebugMode(debugMode)) {
            return "PID: feed forward";
        }
        return sensor.getName();
    }

    private static boolean isPidDebugMode(int debugMode) {
        return debugMode == 0 || debugMode == 3 || debugMode == 7 || debugMode == 11 || debugMode == 17;
    }
}

