/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STWriter;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.debug.AddAttributeEvent;
import org.stringtemplate.v4.debug.ConstructionEvent;
import org.stringtemplate.v4.debug.EvalTemplateEvent;
import org.stringtemplate.v4.debug.InterpEvent;
import org.stringtemplate.v4.gui.STViz;
import org.stringtemplate.v4.misc.Aggregate;
import org.stringtemplate.v4.misc.ErrorBuffer;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.MultiMap;

public class ST {
    public static final String VERSION = "4.3.4";
    public static final String UNKNOWN_NAME = "anonymous";
    public static final Object EMPTY_ATTR = new Object();
    public static final String IMPLICIT_ARG_NAME = "it";
    public CompiledST impl;
    protected Object[] locals;
    public STGroup groupThatCreatedThisInstance;
    public DebugState debugState;

    protected ST() {
        if (STGroup.trackCreationEvents) {
            if (this.debugState == null) {
                this.debugState = new DebugState();
            }
            this.debugState.newSTEvent = new ConstructionEvent();
        }
    }

    public ST(String template) {
        this(STGroup.defaultGroup, template);
    }

    public ST(String template, char delimiterStartChar, char delimiterStopChar) {
        this(new STGroup(delimiterStartChar, delimiterStopChar), template);
    }

    public ST(STGroup group, String template) {
        this();
        this.groupThatCreatedThisInstance = group;
        this.impl = this.groupThatCreatedThisInstance.compile(group.getFileName(), null, null, template, null);
        this.impl.hasFormalArgs = false;
        this.impl.name = UNKNOWN_NAME;
        this.impl.defineImplicitlyDefinedTemplates(this.groupThatCreatedThisInstance);
    }

    public ST(ST proto) {
        try {
            this.impl = proto.impl.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (proto.locals != null) {
            this.locals = new Object[proto.locals.length];
            System.arraycopy(proto.locals, 0, this.locals, 0, proto.locals.length);
        } else if (this.impl.formalArguments != null && !this.impl.formalArguments.isEmpty()) {
            this.locals = new Object[this.impl.formalArguments.size()];
            Arrays.fill(this.locals, EMPTY_ATTR);
        }
        this.groupThatCreatedThisInstance = proto.groupThatCreatedThisInstance;
    }

    public synchronized ST add(String name, Object value) {
        Object curvalue;
        if (name == null) {
            throw new NullPointerException("null attribute name");
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in attribute names");
        }
        if (STGroup.trackCreationEvents) {
            if (this.debugState == null) {
                this.debugState = new DebugState();
            }
            this.debugState.addAttrEvents.map(name, new AddAttributeEvent(name, value));
        }
        FormalArgument arg = null;
        if (this.impl.hasFormalArgs) {
            if (this.impl.formalArguments != null) {
                arg = this.impl.formalArguments.get(name);
            }
            if (arg == null) {
                throw new IllegalArgumentException("no such attribute: " + name);
            }
        } else {
            if (this.impl.formalArguments != null) {
                arg = this.impl.formalArguments.get(name);
            }
            if (arg == null) {
                arg = new FormalArgument(name);
                this.impl.addArg(arg);
                if (this.locals == null) {
                    this.locals = new Object[1];
                } else {
                    Object[] copy = new Object[this.impl.formalArguments.size()];
                    System.arraycopy(this.locals, 0, copy, 0, Math.min(this.locals.length, this.impl.formalArguments.size()));
                    this.locals = copy;
                }
                this.locals[arg.index] = EMPTY_ATTR;
            }
        }
        if ((curvalue = this.locals[arg.index]) == EMPTY_ATTR) {
            this.locals[arg.index] = value;
            return this;
        }
        AttributeList multi = ST.convertToAttributeList(curvalue);
        this.locals[arg.index] = multi;
        if (value instanceof List) {
            multi.addAll((List)value);
        } else if (value != null && value.getClass().isArray()) {
            if (value instanceof Object[]) {
                multi.addAll(Arrays.asList((Object[])value));
            } else {
                multi.addAll(ST.convertToAttributeList(value));
            }
        } else {
            multi.add(value);
        }
        return this;
    }

    public synchronized ST addAggr(String aggrSpec, Object ... values) {
        int dot = aggrSpec.indexOf(".{");
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("missing values for aggregate attribute format: " + aggrSpec);
        }
        int finalCurly = aggrSpec.indexOf(125);
        if (dot < 0 || finalCurly < 0) {
            throw new IllegalArgumentException("invalid aggregate attribute format: " + aggrSpec);
        }
        String aggrName = aggrSpec.substring(0, dot);
        String propString = aggrSpec.substring(dot + 2, aggrSpec.length() - 1);
        String[] propNames = (propString = propString.trim()).split("\\ *,\\ *");
        if (propNames == null || propNames.length == 0) {
            throw new IllegalArgumentException("invalid aggregate attribute format: " + aggrSpec);
        }
        if (values.length != propNames.length) {
            throw new IllegalArgumentException("number of properties and values mismatch for aggregate attribute format: " + aggrSpec);
        }
        int i = 0;
        Aggregate aggr = new Aggregate();
        for (String p : propNames) {
            Object v = values[i++];
            aggr.properties.put(p, v);
        }
        this.add(aggrName, aggr);
        return this;
    }

    public void remove(String name) {
        if (this.impl.formalArguments == null) {
            if (this.impl.hasFormalArgs) {
                throw new IllegalArgumentException("no such attribute: " + name);
            }
            return;
        }
        FormalArgument arg = this.impl.formalArguments.get(name);
        if (arg == null) {
            throw new IllegalArgumentException("no such attribute: " + name);
        }
        this.locals[arg.index] = EMPTY_ATTR;
    }

    protected void rawSetAttribute(String name, Object value) {
        if (this.impl.formalArguments == null) {
            throw new IllegalArgumentException("no such attribute: " + name);
        }
        FormalArgument arg = this.impl.formalArguments.get(name);
        if (arg == null) {
            throw new IllegalArgumentException("no such attribute: " + name);
        }
        this.locals[arg.index] = value;
    }

    public Object getAttribute(String name) {
        FormalArgument localArg = null;
        if (this.impl.formalArguments != null) {
            localArg = this.impl.formalArguments.get(name);
        }
        if (localArg != null) {
            Object o = this.locals[localArg.index];
            if (o == EMPTY_ATTR) {
                o = null;
            }
            return o;
        }
        return null;
    }

    public Map<String, Object> getAttributes() {
        if (this.impl.formalArguments == null) {
            return null;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (FormalArgument a : this.impl.formalArguments.values()) {
            Object o = this.locals[a.index];
            if (o == EMPTY_ATTR) {
                o = null;
            }
            attributes.put(a.name, o);
        }
        return attributes;
    }

    protected static AttributeList convertToAttributeList(Object curvalue) {
        AttributeList multi;
        if (curvalue == null) {
            multi = new AttributeList();
            multi.add(curvalue);
        } else if (curvalue instanceof AttributeList) {
            multi = (AttributeList)curvalue;
        } else if (curvalue instanceof List) {
            List listAttr = (List)curvalue;
            multi = new AttributeList(listAttr.size());
            multi.addAll(listAttr);
        } else if (curvalue instanceof Object[]) {
            Object[] a = (Object[])curvalue;
            multi = new AttributeList(a.length);
            multi.addAll(Arrays.asList(a));
        } else if (curvalue.getClass().isArray()) {
            int length = Array.getLength(curvalue);
            multi = new AttributeList(length);
            for (int i = 0; i < length; ++i) {
                multi.add(Array.get(curvalue, i));
            }
        } else {
            multi = new AttributeList();
            multi.add(curvalue);
        }
        return multi;
    }

    public String getName() {
        return this.impl.name;
    }

    public boolean isAnonSubtemplate() {
        return this.impl.isAnonSubtemplate;
    }

    public int write(STWriter out) throws IOException {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, this.impl.nativeGroup.errMgr, false);
        InstanceScope scope = new InstanceScope(null, this);
        return interp.exec(out, scope);
    }

    public int write(STWriter out, Locale locale) {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale, this.impl.nativeGroup.errMgr, false);
        InstanceScope scope = new InstanceScope(null, this);
        return interp.exec(out, scope);
    }

    public int write(STWriter out, STErrorListener listener) {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, new ErrorManager(listener), false);
        InstanceScope scope = new InstanceScope(null, this);
        return interp.exec(out, scope);
    }

    public int write(STWriter out, Locale locale, STErrorListener listener) {
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale, new ErrorManager(listener), false);
        InstanceScope scope = new InstanceScope(null, this);
        return interp.exec(out, scope);
    }

    public int write(File outputFile, STErrorListener listener) throws IOException {
        return this.write(outputFile, listener, "UTF-8", Locale.getDefault(), -1);
    }

    public int write(File outputFile, STErrorListener listener, String encoding) throws IOException {
        return this.write(outputFile, listener, encoding, Locale.getDefault(), -1);
    }

    public int write(File outputFile, STErrorListener listener, String encoding, int lineWidth) throws IOException {
        return this.write(outputFile, listener, encoding, Locale.getDefault(), lineWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(File outputFile, STErrorListener listener, String encoding, Locale locale, int lineWidth) throws IOException {
        try (Writer bw = null;){
            FileOutputStream fos = new FileOutputStream(outputFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);
            bw = new BufferedWriter(osw);
            AutoIndentWriter w = new AutoIndentWriter(bw);
            w.setLineWidth(lineWidth);
            int n = this.write(w, locale, listener);
            bw.close();
            bw = null;
            int n2 = n;
            return n2;
        }
    }

    public String render() {
        return this.render(Locale.getDefault());
    }

    public String render(int lineWidth) {
        return this.render(Locale.getDefault(), lineWidth);
    }

    public String render(Locale locale) {
        return this.render(locale, -1);
    }

    public String render(Locale locale, int lineWidth) {
        StringWriter out = new StringWriter();
        AutoIndentWriter wr = new AutoIndentWriter(out);
        wr.setLineWidth(lineWidth);
        this.write((STWriter)wr, locale);
        return out.toString();
    }

    public STViz inspect() {
        return this.inspect(Locale.getDefault());
    }

    public STViz inspect(int lineWidth) {
        return this.inspect(this.impl.nativeGroup.errMgr, Locale.getDefault(), lineWidth);
    }

    public STViz inspect(Locale locale) {
        return this.inspect(this.impl.nativeGroup.errMgr, locale, -1);
    }

    public STViz inspect(ErrorManager errMgr, Locale locale, int lineWidth) {
        ErrorBuffer errors = new ErrorBuffer();
        this.impl.nativeGroup.setListener(errors);
        StringWriter out = new StringWriter();
        AutoIndentWriter wr = new AutoIndentWriter(out);
        wr.setLineWidth(lineWidth);
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale, true);
        InstanceScope scope = new InstanceScope(null, this);
        interp.exec(wr, scope);
        List<InterpEvent> events = interp.getEvents();
        EvalTemplateEvent overallTemplateEval = (EvalTemplateEvent)events.get(events.size() - 1);
        STViz viz = new STViz(errMgr, overallTemplateEval, out.toString(), interp, interp.getExecutionTrace(), errors.errors);
        viz.open();
        return viz;
    }

    public List<InterpEvent> getEvents() {
        return this.getEvents(Locale.getDefault());
    }

    public List<InterpEvent> getEvents(int lineWidth) {
        return this.getEvents(Locale.getDefault(), lineWidth);
    }

    public List<InterpEvent> getEvents(Locale locale) {
        return this.getEvents(locale, -1);
    }

    public List<InterpEvent> getEvents(Locale locale, int lineWidth) {
        StringWriter out = new StringWriter();
        AutoIndentWriter wr = new AutoIndentWriter(out);
        wr.setLineWidth(lineWidth);
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale, true);
        InstanceScope scope = new InstanceScope(null, this);
        interp.exec(wr, scope);
        return interp.getEvents();
    }

    public String toString() {
        if (this.impl == null) {
            return "bad-template()";
        }
        String name = this.impl.name + "()";
        if (this.impl.isRegion) {
            name = "@" + STGroup.getUnMangledTemplateName(name);
        }
        return name;
    }

    public static String format(String template, Object ... attributes) {
        return ST.format(-1, template, attributes);
    }

    public static String format(int lineWidth, String template, Object ... attributes) {
        template = template.replaceAll("%([0-9]+)", "arg$1");
        ST st = new ST(template);
        int i = 1;
        for (Object a : attributes) {
            st.add("arg" + i, a);
            ++i;
        }
        return st.render(lineWidth);
    }

    public static final class AttributeList
    extends ArrayList<Object> {
        public AttributeList(int size) {
            super(size);
        }

        public AttributeList() {
        }
    }

    public static class DebugState {
        public ConstructionEvent newSTEvent;
        public MultiMap<String, AddAttributeEvent> addAttrEvents = new MultiMap();
    }

    public static enum RegionType {
        IMPLICIT,
        EMBEDDED,
        EXPLICIT;

    }
}

