/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.f4discovery;

import com.rusefi.RusefiTestBase;
import com.rusefi.autotest.ControllerConnectorState;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.engine_type_e;
import com.rusefi.functional_tests.EcuTestHelper;
import org.junit.Test;

public class VssHardwareLoopTest
extends RusefiTestBase {
    @Override
    protected boolean needsHardwareTriggerInput() {
        return true;
    }

    @Test
    public void test() {
        this.ecu.setEngineType(engine_type_e.FRANKENSO_MIATA_NA6_MAP);
        this.ecu.changeRpm(1000);
        this.ecu.sendCommand("set_trigger_simulator_pin 0 none");
        this.ecu.sendCommand("set_trigger_simulator_pin 1 none");
        this.ecu.sendCommand("set_trigger_input_pin 1 none");
        this.ecu.sendCommand("set_idle_pin PD2");
        this.ecu.sendCommand("set idle_solenoid_freq 100");
        EcuTestHelper.assertSomewhatClose("VSS no input", 0.0, SensorCentral.getInstance().getValue(Sensor.vehicleSpeedKph));
        this.ecu.sendCommand("set vss_pin pa5");
        BinaryProtocol.sleep(2000L);
        this.ecu.sendCommand("set driveWheelRevPerKm 500");
        EcuTestHelper.assertSomewhatClose("VSS with input", 145.58, SensorCentral.getInstance().getValue(Sensor.vehicleSpeedKph));
        if (ControllerConnectorState.firmwareVersion == null) {
            throw new IllegalStateException("firmwareVersion has not arrived");
        }
    }
}

