/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.util.EnumSet;
import java.util.Set;

public enum BcmFlag {
    SETTIMER(1),
    STARTTIMER(2),
    TX_COUNTEVT(4),
    TX_ANNOUNCE(8),
    TX_CP_CAN_ID(16),
    RX_FILTER_ID(32),
    RX_CHECK_DLC(64),
    RX_NO_AUTOTIMER(128),
    RX_ANNOUNCE_RESUME(256),
    TX_RESET_MULTI_IDX(512),
    RX_RTR_FRAME(1024),
    CAN_FD_FRAME(2048);

    private final int bit;

    private BcmFlag(int bit) {
        this.bit = bit;
    }

    public static Set<BcmFlag> fromNative(int nativeFlags) {
        EnumSet<BcmFlag> flags = EnumSet.noneOf(BcmFlag.class);
        for (BcmFlag flag : BcmFlag.values()) {
            if ((flag.bit & nativeFlags) == 0) continue;
            flags.add(flag);
        }
        return flags;
    }

    public static int toNative(Set<BcmFlag> flags) {
        int nativeFlags = 0;
        for (BcmFlag flag : flags) {
            nativeFlags |= flag.bit;
        }
        return nativeFlags;
    }
}

