/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.PostPosition;
import eu.hansolo.steelseries.tools.Section;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;

public final class Altimeter
extends AbstractRadial {
    private double value100 = 0.0;
    private double oldValue = 0.0;
    private double value1000 = 0.0;
    private double value10000 = 0.0;
    private double angleStep100ft;
    private double angleStep1000ft;
    private double angleStep10000ft;
    private static final double TICKMARK_OFFSET = Math.PI;
    private float tickLabelPeriod = 1.0f;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage pointer10000FtImage;
    private BufferedImage pointer1000FtImage;
    private BufferedImage pointer100FtImage;
    private BufferedImage disabledImage;
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private Timeline timeline = new Timeline(this);
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private double unitStringWidth;
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();

    public Altimeter() {
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setMinValue(0.0);
        this.setMaxValue(10.0);
        this.calcAngleStep();
        this.setLcdColor(LcdColor.BLACK_LCD);
        this.setLcdVisible(true);
        this.setTitle("ALT");
        this.setUnitString("ft");
    }

    @Override
    public AbstractGauge init(int WIDTH, int HEIGHT) {
        int GAUGE_HEIGHT;
        int GAUGE_WIDTH = this.isFrameVisible() ? WIDTH : this.getGaugeBounds().width;
        int n = GAUGE_HEIGHT = this.isFrameVisible() ? HEIGHT : this.getGaugeBounds().height;
        if (GAUGE_WIDTH <= 1 || GAUGE_HEIGHT <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.isDigitalFont()) {
            this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * (float)GAUGE_WIDTH * 0.1f));
        } else {
            this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * (float)GAUGE_WIDTH * 0.1f));
        }
        if (this.isCustomLcdUnitFontEnabled()) {
            this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)GAUGE_WIDTH * 0.1f));
        } else {
            this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * (float)GAUGE_WIDTH * 0.1f));
        }
        this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * (float)GAUGE_WIDTH * 0.1f));
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(GAUGE_WIDTH, GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(GAUGE_WIDTH, "", "", this.bImage);
        }
        this.create_TICKMARKS_Image(GAUGE_WIDTH, 0.0, Math.PI, 0.0, 10.0, this.angleStep100ft, (int)this.tickLabelPeriod, 0, true, true, null, this.bImage);
        if (this.isLcdVisible()) {
            this.createLcdImage(new Rectangle2D.Double(((double)this.getGaugeBounds().width - (double)GAUGE_WIDTH * 0.4) / 2.0, (double)this.getGaugeBounds().height * 0.55, (double)GAUGE_WIDTH * 0.4, (double)GAUGE_WIDTH * 0.1), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
            this.LCD.setRect(((double)this.getGaugeBounds().width - (double)GAUGE_WIDTH * 0.4) / 2.0, (double)this.getGaugeBounds().height * 0.55, (double)GAUGE_WIDTH * 0.4, (double)GAUGE_WIDTH * 0.1);
        }
        if (this.pointer100FtImage != null) {
            this.pointer100FtImage.flush();
        }
        this.pointer100FtImage = this.create_100FT_POINTER_Image(GAUGE_WIDTH);
        if (this.pointer1000FtImage != null) {
            this.pointer1000FtImage.flush();
        }
        this.pointer1000FtImage = this.create_1000FT_POINTER_Image(GAUGE_WIDTH);
        if (this.pointer10000FtImage != null) {
            this.pointer10000FtImage.flush();
        }
        this.pointer10000FtImage = this.create_10000FT_POINTER_Image(GAUGE_WIDTH);
        this.createPostsImage(GAUGE_WIDTH, this.fImage, PostPosition.CENTER);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(GAUGE_WIDTH, GAUGE_WIDTH, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(GAUGE_WIDTH, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(GAUGE_WIDTH);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterX());
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isLcdVisible()) {
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                G2.setColor(this.getCustomLcdForeground());
            } else {
                G2.setColor(this.getLcdColor().TEXT_COLOR);
            }
            G2.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), G2.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                G2.drawString(this.getLcdUnitString(), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                this.unitStringWidth = this.UNIT_BOUNDARY.getWidth();
            } else {
                this.unitStringWidth = 0.0;
            }
            G2.setFont(this.getLcdValueFont());
            switch (this.getModel().getNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(Integer.toOctalString((int)this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(this.formatLcdValue(this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                G2.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), G2.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                G2.drawString(this.getLcdInfoString(), (float)this.LCD.getBounds().x + 5.0f, (float)this.LCD.getBounds().y + (float)this.INFO_BOUNDARY.getHeight() + 5.0f);
            }
        }
        G2.rotate((this.value10000 - this.getMinValue()) * this.angleStep10000ft, this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.pointer10000FtImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate((this.value1000 - this.getMinValue()) * this.angleStep1000ft, this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.pointer1000FtImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate((this.value100 - this.getMinValue()) * this.angleStep100ft, this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.pointer100FtImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        G2.dispose();
    }

    @Override
    public void setValue(double VALUE) {
        if (this.isEnabled()) {
            this.value100 = VALUE % 1000.0 / 100.0;
            this.value1000 = VALUE % 10000.0 / 100.0;
            this.value10000 = VALUE % 100000.0 / 100.0;
            if (this.isValueCoupled()) {
                this.setLcdValue(VALUE);
            }
            this.fireStateChanged();
            this.oldValue = VALUE;
            this.repaint();
        }
    }

    @Override
    public void setValueAnimated(double VALUE) {
        if (this.isEnabled()) {
            if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
                this.timeline.abort();
            }
            this.timeline = new Timeline(this);
            this.timeline.addPropertyToInterpolate("value", this.oldValue, VALUE);
            this.timeline.setEase(new Spline(0.5f));
            double range = Math.abs(this.value100 - VALUE);
            double fraction = range / 1000.0;
            this.timeline.setDuration((long)(1000.0 * fraction));
            this.timeline.play();
        }
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        Point2D.Double FOREGROUND_STOP;
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (FOREGROUND_START.equals(FOREGROUND_STOP = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLORS[0], LCD_COLORS[1], LCD_COLORS[2], LCD_COLORS[3], LCD_COLORS[4]};
        return new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    private void calcAngleStep() {
        this.angleStep100ft = Math.PI * 2 / (this.getMaxValue() - this.getMinValue());
        this.angleStep1000ft = this.angleStep100ft / 10.0;
        this.angleStep10000ft = this.angleStep1000ft / 10.0;
    }

    private BufferedImage create_TICKMARKS_Image(int WIDTH, double FREE_AREA_ANGLE, double OFFSET, double MIN_VALUE, double MAX_VALUE, double ANGLE_STEP, int TICK_LABEL_PERIOD, int SCALE_DIVIDER_POWER, boolean DRAW_TICKS, boolean DRAW_TICK_LABELS, ArrayList<Section> tickmarkSections, BufferedImage image) {
        double ALPHA_START;
        if (WIDTH <= 0) {
            return null;
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, WIDTH, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        Font STD_FONT = new Font("Verdana", 0, (int)(0.09 * (double)WIDTH));
        BasicStroke MEDIUM_STROKE = new BasicStroke(2.0f, 1, 2);
        BasicStroke THIN_STROKE = new BasicStroke(1.5f, 1, 2);
        int TEXT_DISTANCE = (int)(0.17 * (double)WIDTH);
        int MED_LENGTH = (int)(0.05 * (double)WIDTH);
        int MAX_LENGTH = (int)(0.07 * (double)WIDTH);
        Color TEXT_COLOR = super.getBackgroundColor().LABEL_COLOR;
        Color TICK_COLOR = super.getBackgroundColor().LABEL_COLOR;
        float RADIUS = (float)IMAGE_WIDTH * 0.4f;
        Point2D.Double ALTIMETER_CENTER = new Point2D.Double((float)IMAGE_WIDTH / 2.0f, (float)IMAGE_HEIGHT / 2.0f);
        Point2D.Double textPoint = null;
        int counter = 0;
        int tickCounter = 0;
        G2.setFont(STD_FONT);
        double sinValue = 0.0;
        double cosValue = 0.0;
        double alpha = ALPHA_START = -OFFSET - FREE_AREA_ANGLE / 2.0;
        float valueCounter = 0.0f;
        while (valueCounter <= 10.0f) {
            Line2D.Double tick;
            Point2D.Double outerPoint;
            Point2D.Double innerPoint;
            G2.setStroke(THIN_STROKE);
            sinValue = Math.sin(alpha);
            cosValue = Math.cos(alpha);
            if (counter % 2 == 0) {
                G2.setStroke(THIN_STROKE);
                innerPoint = new Point2D.Double(((Point2D)ALTIMETER_CENTER).getX() + (double)(RADIUS - (float)MED_LENGTH) * sinValue, ((Point2D)ALTIMETER_CENTER).getY() + (double)(RADIUS - (float)MED_LENGTH) * cosValue);
                outerPoint = new Point2D.Double(((Point2D)ALTIMETER_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)ALTIMETER_CENTER).getY() + (double)RADIUS * cosValue);
                G2.setColor(TICK_COLOR);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
            }
            if (counter == 10 || counter == 0) {
                G2.setColor(TEXT_COLOR);
                G2.setStroke(MEDIUM_STROKE);
                innerPoint = new Point2D.Double(((Point2D)ALTIMETER_CENTER).getX() + (double)(RADIUS - (float)MAX_LENGTH) * sinValue, ((Point2D)ALTIMETER_CENTER).getY() + (double)(RADIUS - (float)MAX_LENGTH) * cosValue);
                outerPoint = new Point2D.Double(((Point2D)ALTIMETER_CENTER).getX() + (double)RADIUS * sinValue, ((Point2D)ALTIMETER_CENTER).getY() + (double)RADIUS * cosValue);
                textPoint = new Point2D.Double(((Point2D)ALTIMETER_CENTER).getX() + (double)(RADIUS - (float)TEXT_DISTANCE + (float)STD_FONT.getSize() / 2.0f) * sinValue, ((Point2D)ALTIMETER_CENTER).getY() + (double)(RADIUS - (float)TEXT_DISTANCE + (float)STD_FONT.getSize() / 2.0f) * cosValue + (double)((float)TEXT_DISTANCE / 2.5f));
                TextLayout TEXT_LAYOUT = new TextLayout(String.valueOf(Math.round(valueCounter)), G2.getFont(), this.RENDER_CONTEXT);
                Rectangle2D TEXT_BOUNDARY = TEXT_LAYOUT.getBounds();
                if (FREE_AREA_ANGLE == 0.0) {
                    if (Float.compare(valueCounter, 10.0f) != 0) {
                        G2.drawString(String.valueOf(Math.round(valueCounter)), (int)(((Point2D)textPoint).getX() - TEXT_BOUNDARY.getWidth() / 2.0), (int)(((Point2D)textPoint).getY() - TEXT_BOUNDARY.getHeight() / 2.0));
                    }
                } else {
                    G2.drawString(String.valueOf(Math.round(valueCounter)), (int)(((Point2D)textPoint).getX() - TEXT_BOUNDARY.getWidth() / 2.0), (int)(((Point2D)textPoint).getY() - TEXT_BOUNDARY.getHeight() / 2.0));
                }
                counter = 0;
                ++tickCounter;
                G2.setColor(TICK_COLOR);
                tick = new Line2D.Double(((Point2D)innerPoint).getX(), ((Point2D)innerPoint).getY(), ((Point2D)outerPoint).getX(), ((Point2D)outerPoint).getY());
                G2.draw(tick);
            }
            ++counter;
            alpha -= ANGLE_STEP * 0.1;
            valueCounter = (float)((double)valueCounter + 0.1);
        }
        G2.dispose();
        return image;
    }

    private BufferedImage create_100FT_POINTER_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, (int)(1.0 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath POINTER100FT = new GeneralPath();
        POINTER100FT.setWindingRule(0);
        POINTER100FT.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.4672897196261682);
        POINTER100FT.lineTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.20093457943925233);
        POINTER100FT.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.16822429906542055);
        POINTER100FT.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.20093457943925233);
        POINTER100FT.lineTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.4672897196261682);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5327102803738317);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5887850467289719);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.6074766355140186);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.6261682242990654);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.6261682242990654, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.6074766355140186);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5981308411214953, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.5934579439252337, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5887850467289719);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5794392523364486, (double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5327102803738317);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
        POINTER100FT.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
        POINTER100FT.closePath();
        Point2D.Double POINTER100FT_START = new Point2D.Double(0.0, POINTER100FT.getBounds2D().getMinY());
        Point2D.Double POINTER100FT_STOP = new Point2D.Double(0.0, POINTER100FT.getBounds2D().getMaxY());
        float[] POINTER100FT_FRACTIONS = new float[]{0.0f, 0.31f, 0.3101f, 0.32f, 1.0f};
        Color[] POINTER100FT_COLORS = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(32, 32, 32, 255), new Color(32, 32, 32, 255)};
        LinearGradientPaint POINTER100FT_GRADIENT = new LinearGradientPaint(POINTER100FT_START, POINTER100FT_STOP, POINTER100FT_FRACTIONS, POINTER100FT_COLORS);
        G2.setPaint(POINTER100FT_GRADIENT);
        G2.fill(POINTER100FT);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_1000FT_POINTER_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, (int)(1.0 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath POINTER1000FT = new GeneralPath();
        POINTER1000FT.setWindingRule(0);
        POINTER1000FT.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
        POINTER1000FT.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.40186915887850466);
        POINTER1000FT.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.3317757009345794);
        POINTER1000FT.lineTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.40186915887850466);
        POINTER1000FT.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.40186915887850466, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.46261682242990654, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299);
        POINTER1000FT.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
        POINTER1000FT.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.4766355140186916, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5327102803738317);
        POINTER1000FT.curveTo((double)IMAGE_WIDTH * 0.49065420560747663, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.5934579439252337);
        POINTER1000FT.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.6121495327102804);
        POINTER1000FT.curveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.6121495327102804, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.616822429906542, (double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5934579439252337);
        POINTER1000FT.curveTo((double)IMAGE_WIDTH * 0.5373831775700935, (double)IMAGE_HEIGHT * 0.5747663551401869, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5093457943925234, (double)IMAGE_HEIGHT * 0.5327102803738317);
        POINTER1000FT.curveTo((double)IMAGE_WIDTH * 0.5233644859813084, (double)IMAGE_HEIGHT * 0.5280373831775701, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.514018691588785, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
        POINTER1000FT.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
        POINTER1000FT.closePath();
        Point2D.Double POINTER1000FT_START = new Point2D.Double(0.0, POINTER1000FT.getBounds2D().getMinY());
        Point2D.Double POINTER1000FT_STOP = new Point2D.Double(0.0, POINTER1000FT.getBounds2D().getMaxY());
        float[] POINTER1000FT_FRACTIONS = new float[]{0.0f, 0.51f, 0.52f, 0.5201f, 0.53f, 1.0f};
        Color[] POINTER1000FT_COLORS = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(32, 32, 32, 255), new Color(32, 32, 32, 255), new Color(32, 32, 32, 255)};
        LinearGradientPaint POINTER1000FT_GRADIENT = new LinearGradientPaint(POINTER1000FT_START, POINTER1000FT_STOP, POINTER1000FT_FRACTIONS, POINTER1000FT_COLORS);
        G2.setPaint(POINTER1000FT_GRADIENT);
        G2.fill(POINTER1000FT);
        G2.dispose();
        return IMAGE;
    }

    private BufferedImage create_10000FT_POINTER_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = UTIL.createImage(WIDTH, (int)(1.0 * (double)WIDTH), 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath POINTER10000FT = new GeneralPath();
        POINTER10000FT.setWindingRule(0);
        POINTER10000FT.moveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
        POINTER10000FT.curveTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.4672897196261682);
        POINTER10000FT.lineTo((double)IMAGE_WIDTH * 0.514018691588785, (double)IMAGE_HEIGHT * 0.3177570093457944);
        POINTER10000FT.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.3037383177570093);
        POINTER10000FT.lineTo((double)IMAGE_WIDTH * 0.5046728971962616, (double)IMAGE_HEIGHT * 0.1822429906542056);
        POINTER10000FT.lineTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.11682242990654206);
        POINTER10000FT.lineTo((double)IMAGE_WIDTH * 0.46261682242990654, (double)IMAGE_HEIGHT * 0.11682242990654206);
        POINTER10000FT.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.1822429906542056);
        POINTER10000FT.lineTo((double)IMAGE_WIDTH * 0.4953271028037383, (double)IMAGE_HEIGHT * 0.29906542056074764);
        POINTER10000FT.lineTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.3177570093457944);
        POINTER10000FT.lineTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4672897196261682);
        POINTER10000FT.curveTo((double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4672897196261682, (double)IMAGE_WIDTH * 0.48598130841121495, (double)IMAGE_HEIGHT * 0.4719626168224299, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.4719626168224299);
        POINTER10000FT.curveTo((double)IMAGE_WIDTH * 0.4719626168224299, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5);
        POINTER10000FT.curveTo((double)IMAGE_WIDTH * 0.4672897196261682, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.48130841121495327, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.5327102803738317);
        POINTER10000FT.curveTo((double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.5327102803738317, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5186915887850467, (double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.5);
        POINTER10000FT.curveTo((double)IMAGE_WIDTH * 0.5327102803738317, (double)IMAGE_HEIGHT * 0.49065420560747663, (double)IMAGE_WIDTH * 0.5280373831775701, (double)IMAGE_HEIGHT * 0.48130841121495327, (double)IMAGE_WIDTH * 0.5186915887850467, (double)IMAGE_HEIGHT * 0.4719626168224299);
        POINTER10000FT.closePath();
        G2.setColor(Color.WHITE);
        G2.fill(POINTER10000FT);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "Altimeter";
    }
}

