/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger counter = new AtomicInteger();
    private final String name;
    private final boolean isDaemon;

    public NamedThreadFactory(String name) {
        this(name, false);
    }

    public NamedThreadFactory(String name, boolean isDaemon) {
        this.name = name;
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setName(this.name + this.counter.incrementAndGet());
        t.setDaemon(this.isDaemon);
        return t;
    }
}

