/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.AutotestLogging;
import com.rusefi.IoUtil;
import com.rusefi.autotest.ControllerConnectorState;
import com.rusefi.enums.engine_type_e;
import com.rusefi.functional_tests.EcuTestHelper;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.LinkManager;

public class EnduranceTestUtility {
    private static final int DEFAULT_COUNT = 2000;

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        int count = EnduranceTestUtility.parseCount(args);
        AutotestLogging.INSTANCE.logLine("Running " + count + " cycles");
        try {
            LinkManager linkManager = ControllerConnectorState.getLinkManager();
            CommandQueue commandQueue = linkManager.getCommandQueue();
            for (int i = 0; i < count; ++i) {
                EcuTestHelper.currentEngineType = engine_type_e.FORD_ASPIRE_1996.ordinal();
                IoUtil.sendBlockingCommand("set engine_type 3", 60000, commandQueue);
                IoUtil.sleepSeconds(2);
                IoUtil.sendBlockingCommand(IoUtil.getEnableCommand("self_stimulation"), commandQueue);
                EcuTestHelper.currentEngineType = engine_type_e.DEFAULT_FRANKENSO.ordinal();
                IoUtil.sendBlockingCommand("set engine_type 28", 60000, commandQueue);
                IoUtil.sleepSeconds(2);
                AutotestLogging.INSTANCE.logLine("++++++++++++++++++++++++++++++++++++  " + i + "   +++++++++++++++");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(-1);
        }
        AutotestLogging.INSTANCE.logLine("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        AutotestLogging.INSTANCE.logLine("++++++++++++++++++++++++++++++++++++  YES YES YES " + count + "   +++++++++++++++");
        AutotestLogging.INSTANCE.logLine("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        long totalTime = System.currentTimeMillis() - start;
        long minutes = totalTime / 1000L / 60L;
        AutotestLogging.INSTANCE.logLine("In " + minutes + " minutes");
    }

    private static int parseCount(String[] args) {
        if (args.length == 2) {
            return Integer.parseInt(args[1]);
        }
        return 2000;
    }
}

