/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LogicdataOutputStream {
    private final OutputStream outputStream;

    public LogicdataOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeDouble(double value) throws IOException {
        if (value == 0.0) {
            this.writeByte(0);
        } else {
            this.writeByte(8);
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.putDouble(value);
            bb.rewind();
            for (int i = 0; i < 8; ++i) {
                this.writeByte(bb.get());
            }
        }
    }

    public void writeVarLength(long value) throws IOException {
        if (value < 0L || value > 0xFFFFFFFFL) {
            this.writeAs(value, 8);
        } else if (value == 0L) {
            this.writeByte(0);
        } else if (value <= 255L) {
            this.writeAs(value, 1);
        } else if (value <= 65535L) {
            this.writeAs(value, 2);
        } else if (value <= 0xFFFFFFL) {
            this.writeAs(value, 3);
        } else {
            this.writeAs(value, 4);
        }
    }

    private void writeAs(long value, int numBytes) throws IOException {
        if (value == 0L) {
            this.writeByte(0);
        } else {
            this.writeByte(numBytes);
            for (int i = 0; i < numBytes; ++i) {
                this.writeByte((byte)(value >> i * 8 & 0xFFL));
            }
        }
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void writeByte(int i) throws IOException {
        this.outputStream.write(i);
    }

    void writeString(String str) throws IOException {
        this.writeVarLength(str.length());
        for (char c : str.toCharArray()) {
            this.writeByte(c);
        }
    }
}

