/*
 * Decompiled with CFR 0.152.
 */
package neoe.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class FileIterator
implements Iterable<File> {
    List<File> buf = new ArrayList<File>();
    private boolean sortByName;

    public FileIterator(String dir) {
        File f = new File(dir);
        this.buf.add(f);
    }

    public FileIterator(String dir, boolean sortByName) {
        this(dir);
        this.sortByName = sortByName;
    }

    private static int getLineCnt(File f, int[] linecnt) throws Exception {
        String line;
        int cnt = 0;
        BufferedReader in = new BufferedReader(new FileReader(f));
        while ((line = in.readLine()) != null) {
            linecnt[0] = linecnt[0] + 1;
            if (!line.trim().startsWith("'")) continue;
            linecnt[1] = linecnt[1] + 1;
        }
        return cnt;
    }

    @Override
    public Iterator<File> iterator() {
        return new Iterator<File>(){

            @Override
            public boolean hasNext() {
                return FileIterator.this.buf.size() > 0;
            }

            @Override
            public File next() {
                File[] sub;
                File f = FileIterator.this.buf.remove(0);
                if (f.isDirectory() && (sub = f.listFiles()) != null) {
                    if (FileIterator.this.sortByName) {
                        FileIterator.sortFiles(sub);
                    }
                    FileIterator.this.buf.addAll(Arrays.asList(sub));
                }
                return f;
            }

            @Override
            public void remove() {
            }
        };
    }

    public static void sortFiles(File[] sub) {
        Arrays.sort(sub, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }
}

