/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.NumberSystem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public final class DisplayCircular
extends AbstractRadial {
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage lcdThresholdImage;
    private BufferedImage disabledImage;
    private Font lcdFormerValueFont;
    private double oldValue;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout oldValueLayout;
    private final Rectangle2D OLD_VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private float lcdTextYPositionFactor = 0.6f;
    private boolean displayMulti = true;

    public DisplayCircular() {
        this.setLcdVisible(true);
        this.setUserLedPosition(0.453271028, 0.75);
        this.oldValue = 0.0;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return this;
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(WIDTH, WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(WIDTH, WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(WIDTH, WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(WIDTH, "", "", this.bImage);
        }
        this.create_TITLE_Image(WIDTH, this.getTitle(), this.getUnitString(), this.bImage);
        if (this.displayMulti) {
            this.lcdTextYPositionFactor = 0.6f;
            this.createLcdImage(new Rectangle2D.Double(((double)this.getGaugeBounds().width - (double)WIDTH * 0.6542056075) / 2.0, (double)this.getGaugeBounds().height * 0.425, (double)WIDTH * 0.6542056075, (double)WIDTH * 0.2990654206), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
            this.LCD.setRect(((double)this.getGaugeBounds().width - (double)WIDTH * 0.6542056075) / 2.0, (double)this.getGaugeBounds().height * 0.425, (double)WIDTH * 0.6542056075, (double)WIDTH * 0.2990654206);
            if (this.lcdThresholdImage != null) {
                this.lcdThresholdImage.flush();
            }
            this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)(this.LCD.getHeight() * 0.2045454545), (int)(this.LCD.getHeight() * 0.2045454545), this.getLcdColor().TEXT_COLOR);
        } else {
            this.lcdTextYPositionFactor = 0.76f;
            this.createLcdImage(new Rectangle2D.Double(((double)this.getGaugeBounds().width - (double)WIDTH * 0.6542056075) / 2.0, (double)this.getGaugeBounds().height * 0.425, (double)WIDTH * 0.6542056075, (double)WIDTH * 0.2242990654), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
            this.LCD.setRect(((double)this.getGaugeBounds().width - (double)WIDTH * 0.6542056075) / 2.0, (double)this.getGaugeBounds().height * 0.425, (double)WIDTH * 0.6542056075, (double)WIDTH * 0.2242990654);
            if (this.lcdThresholdImage != null) {
                this.lcdThresholdImage.flush();
            }
            this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)(this.LCD.getHeight() * 0.2045454545), (int)(this.LCD.getHeight() * 0.2045454545), this.getLcdColor().TEXT_COLOR);
        }
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(WIDTH, WIDTH, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(WIDTH, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(WIDTH);
        if (this.bImage != null) {
            if (this.displayMulti) {
                if (this.isDigitalFont()) {
                    this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.5f * ((float)WIDTH * 0.2990654f)));
                    this.lcdFormerValueFont = this.getModel().getDigitalBaseFont().deriveFont(0.2f * ((float)WIDTH * 0.2990654f));
                } else {
                    this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.46875f * ((float)WIDTH * 0.2990654f)));
                    this.lcdFormerValueFont = this.getModel().getStandardBaseFont().deriveFont(0.1875f * ((float)WIDTH * 0.2990654f));
                }
                if (this.isCustomLcdUnitFontEnabled()) {
                    this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.1875f * ((float)WIDTH * 0.2990654f)));
                } else {
                    this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.1875f * ((float)WIDTH * 0.2990654f)));
                }
            } else {
                if (this.isDigitalFont()) {
                    this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * ((float)WIDTH * 0.22429906f)));
                } else {
                    this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * ((float)WIDTH * 0.22429906f)));
                }
                if (this.isCustomLcdUnitFontEnabled()) {
                    this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * ((float)WIDTH * 0.22429906f)));
                } else {
                    this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * ((float)WIDTH * 0.22429906f)));
                }
                this.setLcdInfoFont(this.getModel().getStandardBaseFont().deriveFont(0.15f * ((float)WIDTH * 0.22429906f)));
            }
        }
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        G2.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isLcdVisible() && this.bImage != null) {
            double UNIT_STRING_WIDTH;
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                G2.setColor(this.getCustomLcdForeground());
            } else {
                G2.setColor(this.getLcdColor().TEXT_COLOR);
            }
            G2.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible() && !this.getLcdUnitString().isEmpty()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), G2.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                G2.drawString(this.getLcdUnitString(), (int)(this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth() - this.LCD.getWidth() * 0.03 + ((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0), (int)(this.LCD.getHeight() * (double)this.lcdTextYPositionFactor + (double)this.getGaugeBounds().height * 0.425));
                UNIT_STRING_WIDTH = this.UNIT_BOUNDARY.getWidth();
            } else {
                UNIT_STRING_WIDTH = 0.0;
            }
            G2.setFont(this.getLcdValueFont());
            switch (this.getLcdNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (int)(this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth() - this.LCD.getWidth() * 0.09 + ((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0), (int)(this.LCD.getHeight() * (double)this.lcdTextYPositionFactor + (double)this.getGaugeBounds().height * 0.425));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(Integer.toOctalString((int)this.getLcdValue()), (int)(this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth() - this.LCD.getWidth() * 0.09 + ((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0), (int)(this.LCD.getHeight() * (double)this.lcdTextYPositionFactor + (double)this.getGaugeBounds().height * 0.425));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    G2.drawString(this.formatLcdValue(this.getLcdValue()), (int)(this.LCD.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth() - this.LCD.getWidth() * 0.09 + ((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0), (int)(this.LCD.getHeight() * (double)this.lcdTextYPositionFactor + (double)this.getGaugeBounds().height * 0.425));
                }
            }
            if (!this.getLcdInfoString().isEmpty() && !this.displayMulti) {
                G2.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), G2.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                G2.drawString(this.getLcdInfoString(), (float)(this.LCD.getBounds().x + 5), (float)this.LCD.getBounds().y + (float)this.INFO_BOUNDARY.getHeight() + 5.0f);
            }
            if (this.displayMulti) {
                G2.setFont(this.lcdFormerValueFont);
                this.oldValueLayout = new TextLayout(this.formatLcdValue(this.oldValue), G2.getFont(), this.RENDER_CONTEXT);
                this.OLD_VALUE_BOUNDARY.setFrame(this.oldValueLayout.getBounds());
                G2.drawString(this.formatLcdValue(this.oldValue), (int)((this.LCD.getWidth() - this.OLD_VALUE_BOUNDARY.getWidth()) / 2.0 + ((double)this.getGaugeBounds().width - this.LCD.getWidth()) / 2.0), (int)(this.LCD.getHeight() * 0.9 + (double)this.getGaugeBounds().height * 0.425));
            }
            if (this.getLcdNumberSystem() == NumberSystem.DEC && this.isLcdThresholdVisible() && this.getLcdValue() >= this.getLcdThreshold()) {
                G2.drawImage((Image)this.lcdThresholdImage, (int)(this.LCD.getX() + this.LCD.getHeight() * 0.0568181818), (int)(this.LCD.getY() + this.LCD.getHeight() - (double)this.lcdThresholdImage.getHeight() - this.LCD.getHeight() * 0.0568181818), null);
            }
        }
        if (this.isUserLedVisible()) {
            G2.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getGaugeBounds().height * this.getUserLedPosition().getY()), null);
        }
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        G2.dispose();
    }

    public boolean isDisplayMulti() {
        return this.displayMulti;
    }

    public void setDisplayMulti(boolean DISPLAY_MULTI) {
        this.displayMulti = DISPLAY_MULTI;
        this.init(this.getWidth(), this.getWidth());
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setLcdValue(double VALUE) {
        this.oldValue = this.getLcdValue();
        super.setLcdValue(VALUE);
    }

    @Override
    public void setLcdVisible(boolean LCD_VISIBLE) {
        super.setLcdVisible(true);
    }

    @Override
    public boolean isLcdVisible() {
        return true;
    }

    @Override
    public NumberSystem getLcdNumberSystem() {
        if (this.displayMulti) {
            return NumberSystem.DEC;
        }
        return super.getLcdNumberSystem();
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        Point2D.Double FOREGROUND_STOP;
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (FOREGROUND_START.equals(FOREGROUND_STOP = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLORS[0], LCD_COLORS[1], LCD_COLORS[2], LCD_COLORS[3], LCD_COLORS[4]};
        return new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    @Override
    public String toString() {
        return "DisplayCircular";
    }
}

