/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.devexperts.logging.Logging;
import com.rusefi.AvailableHardware;
import com.rusefi.CompatibilityOptional;
import com.rusefi.CompatibilitySet;
import com.rusefi.FileLog;
import com.rusefi.SerialPortScanner;
import com.rusefi.StartupFrame;
import com.rusefi.core.FindFileHelper;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.maintenance.ProgramSelector;
import com.rusefi.maintenance.StatusAnimation;
import com.rusefi.maintenance.jobs.AsyncJob;
import com.rusefi.maintenance.jobs.AsyncJobExecutor;
import com.rusefi.maintenance.jobs.AsyncJobWithContext;
import com.rusefi.maintenance.jobs.DfuAutoJob;
import com.rusefi.maintenance.jobs.DfuManualJob;
import com.rusefi.maintenance.jobs.OpenBltAutoJob;
import com.rusefi.maintenance.jobs.OpenBltManualJob;
import com.rusefi.ui.BasicLogoHelper;
import com.rusefi.ui.LogoHelper;
import com.rusefi.ui.basic.UpdateCalibrations;
import com.rusefi.ui.util.DefaultExceptionHandler;
import com.rusefi.ui.util.HorizontalLine;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.ToolButtons;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.putgemin.VerticalFlowLayout;

public class BasicStartupFrame {
    private static final Logging log = Logging.getLogging(BasicStartupFrame.class);
    private final String whiteLabel = ConnectionAndMeta.getWhiteLabel(ConnectionAndMeta.getProperties());
    private final FrameHelper frame = FrameHelper.createFrame(this.whiteLabel + " basic console " + 20241210);
    private final boolean isObfuscated = FindFileHelper.isObfuscated();
    private final JLabel statusMessage = new JLabel();
    private final StatusAnimation status = new StatusAnimation(this::updateStatus, "Scanning ports");
    private final JButton updateFirmwareButton = ProgramSelector.createUpdateFirmwareButton();
    private final JButton updateCalibrationsButton = new JButton("Update Calibrations", AutoupdateUtil.loadIcon("writeconfig48.png"));
    private final UpdateCalibrations updateCalibrations = new UpdateCalibrations();
    private volatile Optional<AsyncJob> updateFirmwareJob = Optional.empty();
    private volatile Optional<SerialPortScanner.PortResult> portToUpdateCalibrations = Optional.empty();

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        BasicStartupFrame.runTool(null);
    }

    public static void runTool(String[] args) throws InterruptedException, InvocationTargetException {
        DefaultExceptionHandler.install();
        SwingUtilities.invokeAndWait(BasicStartupFrame::new);
    }

    public BasicStartupFrame() {
        JPanel panel = new JPanel(new VerticalFlowLayout());
        if (FileLog.isWindows()) {
            panel.add(ToolButtons.createShowDeviceManagerButton());
            panel.add(StartupFrame.binaryModificationControl());
            this.updateFirmwareButton.addActionListener(this::onUpdateFirmwareButtonClicked);
            this.updateFirmwareButton.setEnabled(false);
            this.statusMessage.setForeground(Color.red);
            panel.add(this.statusMessage);
            panel.add(this.updateFirmwareButton);
        } else {
            panel.add(new JLabel("Sorry only works on Windows"));
        }
        SerialPortScanner.INSTANCE.addListener(currentHardware -> SwingUtilities.invokeLater(() -> this.onHardwareUpdated(currentHardware)));
        panel.add(new HorizontalLine());
        JLabel logoLabel = LogoHelper.createLogoLabel();
        if (logoLabel != null) {
            panel.add(logoLabel);
        }
        if (ConnectionAndMeta.isDefaultWhitelabel(this.whiteLabel)) {
            panel.add(LogoHelper.createUrlLabel());
        }
        this.updateCalibrationsButton.addActionListener(this::onUpdateCalibrationsButtonClicked);
        this.updateCalibrationsButton.setEnabled(false);
        if (ConnectionAndMeta.showUpdateCalibrations()) {
            panel.add(this.updateCalibrationsButton);
        }
        BasicLogoHelper.setGenericFrameIcon(this.frame.getFrame());
        this.frame.showFrame(panel, false);
        UiUtils.centerWindow(this.frame.getFrame());
        this.packFrame();
    }

    private void packFrame() {
        this.frame.getFrame().pack();
    }

    private void hideStatusMessage() {
        this.statusMessage.setText(" ");
    }

    private void updateStatus(String niceStatus) {
        this.statusMessage.setText(niceStatus);
        this.packFrame();
    }

    private void onHardwareUpdated(AvailableHardware currentHardware) {
        this.status.stop();
        this.hideStatusMessage();
        this.packFrame();
        this.updateUpdateFirmwareJob(currentHardware);
        this.updatePortToUpdateCalibrations(currentHardware);
    }

    private void updateUpdateFirmwareJob(AvailableHardware currentHardware) {
        if (currentHardware.isDfuFound()) {
            this.setUpdateFirmwareJob(new DfuManualJob());
        } else {
            Set<SerialPortScanner.SerialPortType> portTypesToUpdateFirmware = this.isObfuscated ? CompatibilitySet.of(SerialPortScanner.SerialPortType.EcuWithOpenblt, SerialPortScanner.SerialPortType.OpenBlt) : CompatibilitySet.of(SerialPortScanner.SerialPortType.Ecu, SerialPortScanner.SerialPortType.EcuWithOpenblt);
            List<SerialPortScanner.PortResult> portsToUpdateFirmware = currentHardware.getKnownPorts(portTypesToUpdateFirmware);
            switch (portsToUpdateFirmware.size()) {
                case 0: {
                    this.resetUpdateFirmwareJob("ECU not found");
                    break;
                }
                case 1: {
                    SerialPortScanner.PortResult portToUpdateFirmware = portsToUpdateFirmware.get(0);
                    AsyncJobWithContext job = null;
                    if (this.isObfuscated) {
                        SerialPortScanner.SerialPortType portType = portToUpdateFirmware.type;
                        switch (portType) {
                            case EcuWithOpenblt: {
                                job = new OpenBltAutoJob(portToUpdateFirmware, this.updateFirmwareButton);
                                break;
                            }
                            case OpenBlt: {
                                job = new OpenBltManualJob(portToUpdateFirmware, this.updateFirmwareButton);
                                break;
                            }
                            default: {
                                log.error(String.format("Unexpected port type: %s", new Object[]{portType}));
                                break;
                            }
                        }
                    } else {
                        job = new DfuAutoJob(portToUpdateFirmware, this.updateFirmwareButton);
                    }
                    this.setUpdateFirmwareJob(job);
                    break;
                }
                default: {
                    this.resetUpdateFirmwareJob(String.format("Multiple ECUs found on: %s", portsToUpdateFirmware.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
                }
            }
        }
    }

    private void setUpdateFirmwareJob(AsyncJob updateFirmwareJob) {
        this.updateFirmwareJob = Optional.of(updateFirmwareJob);
        this.hideStatusMessage();
        this.updateFirmwareButton.setEnabled(true);
        Optional<Object> updateFirmwareButtonText = Optional.empty();
        if (updateFirmwareJob instanceof OpenBltAutoJob) {
            updateFirmwareButtonText = Optional.of("Auto Update Firmware");
        } else if (updateFirmwareJob instanceof OpenBltManualJob) {
            updateFirmwareButtonText = Optional.of("Blt Update Firmware");
        } else if (updateFirmwareJob instanceof DfuAutoJob) {
            updateFirmwareButtonText = Optional.of("Update Firmware");
        } else if (updateFirmwareJob instanceof DfuManualJob) {
            updateFirmwareButtonText = Optional.of("Update Firmware via DFU");
        } else {
            log.error(String.format("Unexpected job type: %s", updateFirmwareJob.getClass().getSimpleName()));
        }
        updateFirmwareButtonText.ifPresent(this.updateFirmwareButton::setText);
    }

    private void resetUpdateFirmwareJob(String reason) {
        this.updateFirmwareJob = Optional.empty();
        this.updateFirmwareButton.setEnabled(false);
        this.statusMessage.setText(reason);
    }

    private void updatePortToUpdateCalibrations(AvailableHardware currentHardware) {
        List<SerialPortScanner.PortResult> ecuPortsToUpdateCalibrations = currentHardware.getKnownPorts(CompatibilitySet.of(SerialPortScanner.SerialPortType.Ecu, SerialPortScanner.SerialPortType.EcuWithOpenblt));
        switch (ecuPortsToUpdateCalibrations.size()) {
            case 0: {
                this.resetPortToUpdateCalibrations();
                log.info("No ECU ports to update calibrations found");
                break;
            }
            case 1: {
                this.setPortToUpdateCalibrations(ecuPortsToUpdateCalibrations.get(0));
                break;
            }
            default: {
                this.resetPortToUpdateCalibrations();
                log.info(String.format("Multiple ECU ports to update calibrations found on: %s", ecuPortsToUpdateCalibrations.stream().map(portResult -> portResult.port).collect(Collectors.joining(", "))));
            }
        }
    }

    private void setPortToUpdateCalibrations(SerialPortScanner.PortResult port) {
        this.portToUpdateCalibrations = Optional.of(port);
        this.updateCalibrationsButton.setEnabled(true);
    }

    private void resetPortToUpdateCalibrations() {
        this.portToUpdateCalibrations = Optional.empty();
        this.updateCalibrationsButton.setEnabled(false);
    }

    private void onUpdateFirmwareButtonClicked(ActionEvent actionEvent) {
        CompatibilityOptional.ifPresentOrElse(this.updateFirmwareJob, AsyncJobExecutor.INSTANCE::executeJob, () -> log.error("Update firmware job is is not defined."));
    }

    private void onUpdateCalibrationsButtonClicked(ActionEvent actionEvent) {
        CompatibilityOptional.ifPresentOrElse(this.portToUpdateCalibrations, port -> this.updateCalibrations.updateCalibrationsAction((SerialPortScanner.PortResult)port, this.updateCalibrationsButton), () -> JOptionPane.showMessageDialog(this.updateCalibrationsButton, "Device is not connected", "Error", 0));
    }
}

