/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.core.io.BundleUtil;
import org.jetbrains.annotations.Nullable;

public class UiBundleUtil {
    private static final Logging log = Logging.getLogging(BundleUtil.class);

    @Nullable
    public static String readBranchNameToDisplay() {
        String bundleFullName = BundleUtil.readBundleFullName();
        if (bundleFullName != null) {
            try {
                BundleUtil.BundleInfo bundleInfo = BundleUtil.parse(bundleFullName);
                return bundleInfo.isMaster() ? "development" : bundleInfo.getBranchName();
            }
            catch (Throwable e) {
                log.warn(String.format("We failed to parse bundle full name `%s`", bundleFullName), e);
            }
        }
        return null;
    }
}

