/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ReaderState;
import com.rusefi.output.JavaFieldsConsumer;
import com.rusefi.util.LazyFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileJavaFieldsConsumer
extends JavaFieldsConsumer {
    private static final String JAVA_PACKAGE = "com.rusefi.config.generated";
    private final LazyFile javaFields;
    private final String className;

    public FileJavaFieldsConsumer(ReaderState state, String javaDestination, int baseOffset, LazyFile.LazyFileFactory fileFactory) {
        super(state, baseOffset);
        this.javaFields = fileFactory.create(javaDestination);
        String className = new File(javaDestination).getName();
        this.className = FileJavaFieldsConsumer.remoteExtension(className);
    }

    @NotNull
    public static String remoteExtension(String fileNameWithExtension) {
        return fileNameWithExtension.substring(0, fileNameWithExtension.indexOf(46));
    }

    @Override
    public void startFile() {
        FileJavaFieldsConsumer.writePackageLine(this.javaFields);
        this.javaFields.write("// this file " + this.state.getHeader() + "\n" + "\n");
        this.javaFields.write("// by " + this.getClass() + "\n");
        this.javaFields.write("import com.rusefi.config.*;\n\n");
        FileJavaFieldsConsumer.writeClassOpenLine(this.javaFields, this.className);
    }

    public static void writeClassOpenLine(LazyFile lazyFile, String className1) {
        lazyFile.write("public class " + className1 + " {" + "\n");
    }

    public static void writePackageLine(LazyFile lazyFile) {
        lazyFile.write("package com.rusefi.config.generated;\n\n");
    }

    @Override
    public void endFile() throws IOException {
        this.javaFields.write(this.state.getVariableRegistry().getJavaConstants());
        this.javaFields.write(this.getContent());
        if (this.allFields.length() > 0) {
            this.javaFields.write("\tpublic static final Field[] VALUES = {\n");
            this.allFields.append("\t};\n");
            this.javaFields.write(this.allFields.toString());
        }
        this.javaFields.write("}\n");
        this.javaFields.close();
    }
}

