/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.waves;

import com.rusefi.waves.RevolutionLog;
import com.rusefi.waves.TimeAxisTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EngineReport {
    public static final EngineReport MOCK = new EngineReport(Collections.singletonList(new UpDown(0, -1, 1, -1, Double.NaN, Double.NaN)));
    public static final double ENGINE_SNIFFER_TICKS_PER_MS = 100.0;
    public static final double RATIO = 0.05;
    private final List<UpDown> list;
    private int maxTime;
    private int minTime;
    private final TimeAxisTranslator timeAxisTranslator = new TimeAxisTranslator(){

        @Override
        public int getMaxTime() {
            return EngineReport.this.maxTime;
        }

        @Override
        public int getMinTime() {
            return EngineReport.this.minTime;
        }

        @Override
        public int timeToScreen(double time, int width) {
            double fraction = (time - (double)EngineReport.this.minTime) * 1.0 / (double)EngineReport.this.getDuration();
            int offset = 150;
            return (int)((double)offset + (double)(width - offset) * fraction);
        }

        @Override
        public double screenToTime(int screenX, int screenWidth) {
            double time = 1.0 * (double)screenX * (double)EngineReport.this.getDuration() / (double)screenWidth + (double)EngineReport.this.minTime;
            return (int)time;
        }
    };

    public EngineReport(String report) {
        this(EngineReport.parse(report));
    }

    public EngineReport(List<UpDown> list) {
        this.list = list;
        if (!list.isEmpty()) {
            this.minTime = list.get((int)0).upTime;
            this.maxTime = list.get((int)(list.size() - 1)).downTime;
        }
    }

    public EngineReport(List<UpDown> list, int minTime, int maxTime) {
        this.list = list;
        this.minTime = minTime;
        this.maxTime = maxTime;
    }

    public static boolean isCloseEnough(double v1, double v2) {
        return EngineReport.isCloseEnough(v1, v2, 0.05);
    }

    public static boolean isCloseEnough(double v1, double v2, double th) {
        if (v2 == 0.0) {
            return v1 == 0.0;
        }
        double ratio = v1 / v2;
        return Math.abs(1.0 - ratio) < th;
    }

    public List<UpDown> getList() {
        return this.list;
    }

    public TimeAxisTranslator getTimeAxisTranslator() {
        return this.timeAxisTranslator;
    }

    @NotNull
    public static List<UpDown> parse(String report) {
        String[] array = report.split("!");
        ArrayList<UpDown> times = new ArrayList<UpDown>();
        int index = 0;
        if (array[0].equals("d")) {
            index += 2;
        }
        while (index + 3 < array.length) {
            if (!array[index].startsWith("u")) {
                index += 2;
                continue;
            }
            if (!array[index + 2].startsWith("d")) {
                index += 2;
                continue;
            }
            Object[] upString = array[index].split("_");
            Object[] downString = array[index + 2].split("_");
            try {
                int upTime = Integer.parseInt(array[index + 1]);
                int downTime = Integer.parseInt(array[index + 3]);
                int upEventIndex = upString.length > 1 ? Integer.parseInt((String)upString[1]) : -1;
                int downEventIndex = downString.length > 1 ? Integer.parseInt((String)downString[1]) : -1;
                times.add(new UpDown(upTime, upEventIndex, downTime, downEventIndex, Double.NaN, Double.NaN));
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid? [" + Arrays.toString(upString) + "][" + Arrays.toString(downString) + "]");
            }
            index += 4;
        }
        return times;
    }

    public int getDuration() {
        return this.maxTime - this.minTime;
    }

    public String toString() {
        return "EngineReport{size=" + this.list.size() + ", maxTime=" + this.maxTime + ", minTime=" + this.minTime + '}';
    }

    public static class UpDown {
        public final int upTime;
        public final int upTriggerCycleIndex;
        public final int downTime;
        public final int downTriggerCycleIndex;
        public final double prevGap;
        public final double gap;

        public UpDown(int upTime, int upIndex, int downTime, int downIndex, double prevGap, double gap) {
            this.upTime = upTime;
            this.upTriggerCycleIndex = upIndex;
            this.downTime = downTime;
            this.downTriggerCycleIndex = downIndex;
            this.prevGap = prevGap;
            this.gap = gap;
        }

        public int getDuration() {
            return this.downTime - this.upTime;
        }

        public String toString() {
            return "UpDown{upTime=" + this.upTime + ", downTime=" + this.downTime + ", d=" + this.getDuration() + '}';
        }

        public double getDutyCycle(RevolutionLog rl) {
            double angleDuration = (rl.getCrankAngleByTime(this.downTime) + 720.0 - rl.getCrankAngleByTime(this.upTime)) % 360.0;
            if (angleDuration < 0.0) {
                throw new IllegalStateException("Negative width: " + angleDuration);
            }
            return angleDuration / 360.0;
        }
    }
}

