/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan.platform.linux;

import java.io.IOException;
import java.util.Objects;
import tel.schich.javacan.JavaCAN;
import tel.schich.javacan.NetworkDevice;
import tel.schich.javacan.platform.linux.LinuxNativeOperationException;

public class LinuxNetworkDevice
implements NetworkDevice {
    private final String name;
    private final long index;

    private LinuxNetworkDevice(String name, long index) {
        this.name = name;
        this.index = index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public long getIndex() {
        return this.index;
    }

    public static NetworkDevice lookup(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("The device name may not be null!");
        }
        long index = LinuxNetworkDevice.resolveInterfaceName(name);
        return new LinuxNetworkDevice(name, index);
    }

    public String toString() {
        return "LinuxNetworkDevice(name='" + this.name + '\'' + ", index=" + this.index + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinuxNetworkDevice dev = (LinuxNetworkDevice)o;
        return this.index == dev.index;
    }

    public int hashCode() {
        return Objects.hash(this.index);
    }

    private static native long resolveInterfaceName(String var0) throws LinuxNativeOperationException;

    static {
        JavaCAN.initialize();
    }
}

