/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.BitState;
import com.rusefi.ConfigField;
import com.rusefi.ConfigFieldImpl;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.FieldIteratorWithOffset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ConfigStructureImpl
implements ConfigStructure {
    public static final String ALIGNMENT_FILL_AT = "alignmentFill_at_";
    public static final String UNUSED_BIT_PREFIX = "unusedBit_";
    private final String name;
    private final String comment;
    private final boolean withPrefix;
    private final ConfigStructure parent;
    private final List<ConfigField> cFields = new ArrayList<ConfigField>();
    private final List<ConfigField> tsFields = new ArrayList<ConfigField>();
    private final Map<String, ConfigField> tsFieldsMap = new TreeMap<String, ConfigField>();
    private final Map<String, ConfigField> currentInstance = new TreeMap<String, ConfigField>();
    private int totalSize;
    private final BitState readingBitState = new BitState();
    private ConfigField cPrevField = ConfigFieldImpl.VOID;
    private final Set<String> names = new HashSet<String>();

    public ConfigStructureImpl(String name, String comment, boolean withPrefix, ConfigStructure parent) {
        this.name = name;
        this.comment = comment;
        this.withPrefix = withPrefix;
        this.parent = parent;
    }

    @Override
    public Map<String, ConfigField> getCurrentInstance() {
        return this.currentInstance;
    }

    public void addBitField(ConfigFieldImpl bitField) {
        this.addBoth(bitField);
        this.readingBitState.incrementBitIndex(bitField);
    }

    @Override
    public ConfigStructure getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addAlignmentFill(ReaderState state, int alignment) {
        int fillSize;
        if (alignment == 0) {
            return;
        }
        FieldIteratorWithOffset iterator = new FieldIteratorWithOffset(this.cFields){

            @Override
            public void end() {
                super.end();
                this.currentOffset += this.cf.getSize(this.next);
            }
        };
        iterator.loop();
        this.totalSize = iterator.currentOffset;
        int n = fillSize = this.totalSize % alignment == 0 ? 0 : alignment - this.totalSize % alignment;
        if (fillSize > 3) {
            throw new IllegalStateException("Fill size does not look right: " + fillSize);
        }
        if (fillSize != 0) {
            int[] fillSizeArray = fillSize != 1 ? new int[]{fillSize} : new int[]{};
            ConfigFieldImpl fill = new ConfigFieldImpl(state, ALIGNMENT_FILL_AT + this.totalSize, "need 4 byte alignment", "" + fillSize, "uint8_t", fillSizeArray, "\"units\", 1, 0, -20, 100, 0", false, false, null, null);
            this.addBoth(fill);
        }
        this.totalSize += fillSize;
    }

    public void addBoth(ConfigFieldImpl cf) {
        this.addC(cf);
        this.addTs(cf);
    }

    public void addC(ConfigFieldImpl cf) {
        if (cf.getName().equals(this.cPrevField.getName())) {
            return;
        }
        boolean isNew = this.names.add(cf.getName());
        if (!isNew) {
            throw new IllegalStateException(cf.getName() + " name already used");
        }
        this.cFields.add(cf);
        this.cPrevField = cf;
    }

    public void addTs(ConfigFieldImpl cf) {
        this.tsFields.add(cf);
        this.tsFieldsMap.put(cf.getName(), cf);
        this.currentInstance.put(cf.getTypeName(), cf);
    }

    @Override
    public ConfigField getTsFieldByName(String name) {
        return this.tsFieldsMap.get(name);
    }

    @Override
    public void addBitPadding(ReaderState readerState) {
        if (this.readingBitState.get() == 0) {
            return;
        }
        int sizeAtStartOfPadding = this.cFields.size();
        while (this.readingBitState.get() < 32) {
            ConfigFieldImpl bitField = new ConfigFieldImpl(readerState, UNUSED_BIT_PREFIX + sizeAtStartOfPadding + "_" + this.readingBitState.get(), "", null, "boolean", new int[0], null, false, false, null, null);
            this.addBitField(bitField);
        }
        this.readingBitState.reset();
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public List<ConfigField> getTsFields() {
        return this.tsFields;
    }

    @Override
    public List<ConfigField> getcFields() {
        return this.cFields;
    }

    @Override
    public boolean isWithPrefix() {
        return this.withPrefix;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "ConfigStructureImpl{name='" + this.name + '\'' + '}';
    }
}

