/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.util;

import com.devexperts.logging.Logging;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;

public class JustOneInstance {
    private static final Logging log = Logging.getLogging(JustOneInstance.class);
    private static final int PORT = 29213;
    private static final int LOCAL_CONNECTION_TIMEOUT_MS = 100;

    public static boolean isAlreadyRunning() {
        if (Boolean.getBoolean("SKIP_ONE_INSTANCE_CHECK")) {
            return false;
        }
        try {
            Socket clientSocket = new Socket();
            clientSocket.connect(new InetSocketAddress("localhost", 29213), 100);
            String msg = "*** Already running!";
            System.out.println(msg);
            log.info(msg);
            return true;
        }
        catch (IOException e) {
            log.info("No other instances seem to be running");
            return false;
        }
    }

    public static void onStart() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                log.info("server socket 29213");
                try {
                    ServerSocket serverSocket = new ServerSocket(29213, 1);
                    while (true) {
                        Socket clientSocket = serverSocket.accept();
                        JustOneInstance.handleConnection(clientSocket);
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        };
        new Thread(runnable, "JustOneInstance").start();
    }

    private static void handleConnection(Socket clientSocket) throws IOException {
        try (OutputStream outputStream = clientSocket.getOutputStream();){
            PrintWriter networkWriter = new PrintWriter(outputStream, true);
            String msg = new Date() + "Already running \r\n";
            log.info(msg);
            networkWriter.println(msg);
        }
    }
}

