/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public interface LongComparator {
    public int compare(long var1, long var3);

    default public LongComparator reversed() {
        return (LongComparator & Serializable)(i1, i2) -> this.compare(i2, i1);
    }

    default public LongComparator thenComparing(LongComparator other) {
        Objects.requireNonNull(other);
        return (LongComparator & Serializable)(i1, i2) -> {
            int res = this.compare(i1, i2);
            return res != 0 ? res : other.compare(i1, i2);
        };
    }

    default public <K> LongComparator thenComparing(LongFunction<? extends K> keyExtractor, Comparator<? super K> keyComparator) {
        return this.thenComparing(LongComparator.comparing(keyExtractor, keyComparator));
    }

    default public <K extends Comparable<? super K>> LongComparator thenComparing(LongFunction<? extends K> keyExtractor) {
        return this.thenComparing(LongComparator.comparing(keyExtractor));
    }

    default public LongComparator thenComparingInt(LongToIntFunction keyExtractor) {
        return this.thenComparing(LongComparator.comparingInt(keyExtractor));
    }

    default public LongComparator thenComparingLong(LongUnaryOperator keyExtractor) {
        return this.thenComparing(LongComparator.comparingLong(keyExtractor));
    }

    default public LongComparator thenComparingDouble(LongToDoubleFunction keyExtractor) {
        return this.thenComparing(LongComparator.comparingDouble(keyExtractor));
    }

    public static <K> LongComparator comparing(LongFunction<? extends K> keyExtractor, Comparator<? super K> keyComparator) {
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(keyComparator);
        return (LongComparator & Serializable)(i1, i2) -> keyComparator.compare((Object)keyExtractor.apply(i1), (Object)keyExtractor.apply(i2));
    }

    public static <K extends Comparable<? super K>> LongComparator comparing(LongFunction<? extends K> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (LongComparator & Serializable)(i1, i2) -> ((Comparable)keyExtractor.apply(i1)).compareTo(keyExtractor.apply(i2));
    }

    public static LongComparator comparingInt(LongToIntFunction keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (LongComparator & Serializable)(i1, i2) -> Integer.compare(keyExtractor.applyAsInt(i1), keyExtractor.applyAsInt(i2));
    }

    public static LongComparator comparingLong(LongUnaryOperator keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (LongComparator & Serializable)(i1, i2) -> Long.compare(keyExtractor.applyAsLong(i1), keyExtractor.applyAsLong(i2));
    }

    public static LongComparator comparingDouble(LongToDoubleFunction keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (LongComparator & Serializable)(i1, i2) -> Double.compare(keyExtractor.applyAsDouble(i1), keyExtractor.applyAsDouble(i2));
    }
}

