/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.server;

import com.rusefi.server.SessionDetails;
import com.rusefi.server.UserDetails;
import com.rusefi.tools.online.HttpUtil;
import java.util.Objects;
import org.json.simple.JSONObject;

public class ApplicationRequest {
    private static final String SESSION = "session";
    private final SessionDetails sessionDetails;
    private final UserDetails vehicleOwner;

    public ApplicationRequest(SessionDetails sessionDetails, UserDetails vehicleOwner) {
        this.sessionDetails = sessionDetails;
        this.vehicleOwner = vehicleOwner;
    }

    public SessionDetails getSessionDetails() {
        return this.sessionDetails;
    }

    public UserDetails getVehicleOwner() {
        return this.vehicleOwner;
    }

    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(SESSION, this.sessionDetails.toJson());
        this.vehicleOwner.put(jsonObject);
        return jsonObject.toJSONString();
    }

    public static ApplicationRequest valueOf(String jsonString) {
        JSONObject jsonObject = HttpUtil.parse(jsonString);
        UserDetails userDetails = UserDetails.valueOf(jsonObject);
        SessionDetails session = SessionDetails.valueOf((String)jsonObject.get(SESSION));
        return new ApplicationRequest(session, userDetails);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationRequest that = (ApplicationRequest)o;
        return this.vehicleOwner.equals(that.vehicleOwner) && this.sessionDetails.equals(that.sessionDetails);
    }

    public int hashCode() {
        return Objects.hash(this.sessionDetails, this.vehicleOwner);
    }

    public String toString() {
        return "ApplicationRequest{sessionDetails=" + this.sessionDetails + ", targetUserId=" + this.vehicleOwner + '}';
    }
}

