/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.console;

import com.rusefi.PaneSettings;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.preferences.storage.PersistentConfiguration;
import com.rusefi.io.ConnectionStatusLogic;
import com.rusefi.ui.LogDownloader;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.console.SettingsTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JTabbedPane;

public class TabbedPanel {
    private String criticalError;
    public final SettingsTab settingsTab;
    public final LogDownloader logsManager;
    public final PaneSettings paneSettings = new PaneSettings(PersistentConfiguration.getConfig().getRoot().getChild("panes"));
    public final JTabbedPane tabbedPane = new JTabbedPane(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.paintStatusText(g);
        }

        private void paintStatusText(Graphics g) {
            String text;
            Font f = g.getFont();
            g.setFont(new Font(f.getName(), f.getStyle(), f.getSize() * 4));
            Dimension d = this.getSize();
            switch (ConnectionStatusLogic.INSTANCE.getValue()) {
                case NOT_CONNECTED: {
                    text = "Not connected";
                    break;
                }
                case LOADING: {
                    text = "Loading";
                    break;
                }
                default: {
                    text = "";
                }
            }
            if (TabbedPanel.this.criticalError != null) {
                text = TabbedPanel.this.criticalError;
                g.setColor(Color.red);
            }
            int labelWidth = g.getFontMetrics().stringWidth(text);
            g.drawString(text, (d.width - labelWidth) / 2, d.height / 2);
        }
    };

    public TabbedPanel(UIContext uiContext) {
        MessagesCentral.getInstance().addListener((clazz, message) -> {
            if (message.startsWith("CRITICAL")) {
                this.criticalError = message;
            }
        });
        this.settingsTab = new SettingsTab(uiContext);
        this.logsManager = new LogDownloader(uiContext);
    }

    public void addTab(String title, Component component) {
        this.tabbedPane.addTab(title, component);
    }
}

