/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.CustomLedColor;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public enum LedImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int sizeBuffer = 0;
    private LedColor ledColorBuffer = LedColor.RED_LED;
    private CustomLedColor customLedColorBuffer = new CustomLedColor(Color.RED);
    private BufferedImage ledOnBuffer = this.UTIL.createImage(1, 1, 3);
    private BufferedImage ledOffBuffer = this.UTIL.createImage(1, 1, 3);

    public final BufferedImage create_LED_Image(int SIZE, int STATE, LedColor LED_COLOR, CustomLedColor CUSTOM_LED_COLOR) {
        Color[] LED_ON_CORONA_COLORS;
        Color[] LED_ON_COLORS;
        Color[] LED_OFF_COLORS;
        if (SIZE <= 11) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (SIZE == this.sizeBuffer && LED_COLOR == this.ledColorBuffer && CUSTOM_LED_COLOR == this.customLedColorBuffer) {
            switch (STATE) {
                case 0: {
                    return this.ledOffBuffer;
                }
                case 1: {
                    return this.ledOnBuffer;
                }
            }
        }
        this.ledOnBuffer.flush();
        this.ledOffBuffer.flush();
        this.ledOnBuffer = this.UTIL.createImage((int)((double)SIZE * 0.0934579439), (int)((double)SIZE * 0.0934579439), 3);
        this.ledOffBuffer = this.UTIL.createImage((int)((double)SIZE * 0.0934579439), (int)((double)SIZE * 0.0934579439), 3);
        Graphics2D G2_ON = this.ledOnBuffer.createGraphics();
        Graphics2D G2_OFF = this.ledOffBuffer.createGraphics();
        G2_ON.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2_ON.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2_ON.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2_OFF.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2_OFF.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2_OFF.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = this.ledOnBuffer.getWidth();
        int IMAGE_HEIGHT = this.ledOnBuffer.getHeight();
        Ellipse2D.Double LED = new Ellipse2D.Double(0.25 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT);
        Ellipse2D.Double LED_CORONA = new Ellipse2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT);
        Point2D.Double LED_CENTER = new Point2D.Double(LED.getCenterX(), LED.getCenterY());
        float[] LED_FRACTIONS = new float[]{0.0f, 0.2f, 1.0f};
        float[] LED_INNER_SHADOW_FRACTIONS = new float[]{0.0f, 0.8f, 1.0f};
        Color[] LED_INNER_SHADOW_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.4f)};
        float[] LED_ON_CORONA_FRACTIONS = new float[]{0.0f, 0.6f, 0.7f, 0.8f, 0.85f, 1.0f};
        if (LED_COLOR == LedColor.CUSTOM) {
            LED_OFF_COLORS = new Color[]{CUSTOM_LED_COLOR.INNER_COLOR1_OFF, CUSTOM_LED_COLOR.INNER_COLOR2_OFF, CUSTOM_LED_COLOR.OUTER_COLOR_OFF};
            LED_ON_COLORS = new Color[]{CUSTOM_LED_COLOR.INNER_COLOR1_ON, CUSTOM_LED_COLOR.INNER_COLOR2_ON, CUSTOM_LED_COLOR.OUTER_COLOR_ON};
            LED_ON_CORONA_COLORS = new Color[]{this.UTIL.setAlpha(CUSTOM_LED_COLOR.CORONA_COLOR, 0.0f), this.UTIL.setAlpha(CUSTOM_LED_COLOR.CORONA_COLOR, 0.4f), this.UTIL.setAlpha(CUSTOM_LED_COLOR.CORONA_COLOR, 0.25f), this.UTIL.setAlpha(CUSTOM_LED_COLOR.CORONA_COLOR, 0.15f), this.UTIL.setAlpha(CUSTOM_LED_COLOR.CORONA_COLOR, 0.05f), this.UTIL.setAlpha(CUSTOM_LED_COLOR.CORONA_COLOR, 0.0f)};
        } else {
            LED_OFF_COLORS = new Color[]{LED_COLOR.INNER_COLOR1_OFF, LED_COLOR.INNER_COLOR2_OFF, LED_COLOR.OUTER_COLOR_OFF};
            LED_ON_COLORS = new Color[]{LED_COLOR.INNER_COLOR1_ON, LED_COLOR.INNER_COLOR2_ON, LED_COLOR.OUTER_COLOR_ON};
            LED_ON_CORONA_COLORS = new Color[]{this.UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.0f), this.UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.4f), this.UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.25f), this.UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.15f), this.UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.05f), this.UTIL.setAlpha(LED_COLOR.CORONA_COLOR, 0.0f)};
        }
        RadialGradientPaint LED_OFF_GRADIENT = new RadialGradientPaint(LED_CENTER, 0.25f * (float)IMAGE_WIDTH, LED_FRACTIONS, LED_OFF_COLORS);
        RadialGradientPaint LED_ON_GRADIENT = new RadialGradientPaint(LED_CENTER, 0.25f * (float)IMAGE_WIDTH, LED_FRACTIONS, LED_ON_COLORS);
        RadialGradientPaint LED_INNER_SHADOW_GRADIENT = new RadialGradientPaint(LED_CENTER, 0.25f * (float)IMAGE_WIDTH, LED_INNER_SHADOW_FRACTIONS, LED_INNER_SHADOW_COLORS);
        RadialGradientPaint LED_ON_CORONA_GRADIENT = new RadialGradientPaint(LED_CENTER, 0.5f * (float)IMAGE_WIDTH, LED_ON_CORONA_FRACTIONS, LED_ON_CORONA_COLORS);
        Ellipse2D.Double LED_LIGHTREFLEX = new Ellipse2D.Double(0.4 * (double)IMAGE_WIDTH, 0.35 * (double)IMAGE_WIDTH, 0.2 * (double)IMAGE_WIDTH, 0.15 * (double)IMAGE_WIDTH);
        Point2D.Double LED_LIGHTREFLEX_START = new Point2D.Double(0.0, LED_LIGHTREFLEX.getMinY());
        Point2D.Double LED_LIGHTREFLEX_STOP = new Point2D.Double(0.0, LED_LIGHTREFLEX.getMaxY());
        float[] LIGHT_REFLEX_FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] LIGHTREFLEX_COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.4f), new Color(1.0f, 1.0f, 1.0f, 0.0f)};
        LinearGradientPaint LED_LIGHTREFLEX_GRADIENT = new LinearGradientPaint(LED_LIGHTREFLEX_START, LED_LIGHTREFLEX_STOP, LIGHT_REFLEX_FRACTIONS, LIGHTREFLEX_COLORS);
        G2_ON.setPaint(LED_ON_CORONA_GRADIENT);
        G2_ON.fill(LED_CORONA);
        G2_ON.setPaint(LED_ON_GRADIENT);
        G2_ON.fill(LED);
        G2_ON.setPaint(LED_INNER_SHADOW_GRADIENT);
        G2_ON.fill(LED);
        G2_ON.setPaint(LED_LIGHTREFLEX_GRADIENT);
        G2_ON.fill(LED_LIGHTREFLEX);
        G2_OFF.setPaint(LED_OFF_GRADIENT);
        G2_OFF.fill(LED);
        G2_OFF.setPaint(LED_INNER_SHADOW_GRADIENT);
        G2_OFF.fill(LED);
        G2_OFF.setPaint(LED_LIGHTREFLEX_GRADIENT);
        G2_OFF.fill(LED_LIGHTREFLEX);
        G2_ON.dispose();
        G2_OFF.dispose();
        this.sizeBuffer = SIZE;
        this.ledColorBuffer = LED_COLOR;
        this.customLedColorBuffer = CUSTOM_LED_COLOR;
        switch (STATE) {
            case 1: {
                return this.ledOnBuffer;
            }
        }
        return this.ledOffBuffer;
    }
}

