/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractLinear;
import eu.hansolo.steelseries.tools.LcdColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public final class DisplayRectangular
extends AbstractLinear {
    private BufferedImage frameImage;
    private BufferedImage backgroundImage;
    private BufferedImage titleImage;
    private BufferedImage lcdImage;
    private BufferedImage foregroundImage;
    private BufferedImage disabledImage;
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();

    public DisplayRectangular() {
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return this;
        }
        int offset = 0;
        if (this.isFrameVisible()) {
            offset = 18;
        }
        if (this.isDigitalFont()) {
            this.setLcdValueFont(LCD_DIGITAL_FONT.deriveFont(0.7f * (float)(this.getHeight() - 2 * offset)));
        } else {
            this.setLcdValueFont(LCD_STANDARD_FONT.deriveFont(0.625f * (float)(this.getHeight() - 2 * offset)));
        }
        if (this.isCustomLcdUnitFontEnabled()) {
            this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)(this.getHeight() - 2 * offset)));
        } else {
            this.setLcdUnitFont(LCD_STANDARD_FONT.deriveFont(0.25f * (float)(this.getHeight() - 2 * offset)));
        }
        if (this.frameImage != null) {
            this.frameImage.flush();
        }
        this.frameImage = this.create_FRAME_Image(WIDTH, HEIGHT);
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.create_BACKGROUND_Image(WIDTH, HEIGHT);
        if (this.lcdImage != null) {
            this.lcdImage.flush();
        }
        this.lcdImage = this.isFrameVisible() ? this.create_LCD_Image(WIDTH - 2 * offset, HEIGHT - 2 * offset, this.getLcdColor(), this.getCustomLcdBackground()) : this.create_LCD_Image(this.getWidth(), this.getHeight(), this.getLcdColor(), this.getCustomLcdBackground());
        if (this.foregroundImage != null) {
            this.foregroundImage.flush();
        }
        this.foregroundImage = this.create_FOREGROUND_Image(WIDTH, HEIGHT);
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(this.getWidth(), this.getHeight());
        if (this.backgroundImage != null) {
            this.backgroundImage.flush();
        }
        this.backgroundImage = this.create_BACKGROUND_Image(WIDTH, HEIGHT);
        if (this.foregroundImage != null) {
            this.foregroundImage.flush();
        }
        this.foregroundImage = this.create_FOREGROUND_Image(WIDTH, HEIGHT);
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(WIDTH, HEIGHT);
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        if (this.isFrameVisible()) {
            G2.drawImage((Image)this.frameImage, 0, 0, null);
        }
        if (this.isBackgroundVisible()) {
            G2.drawImage((Image)this.backgroundImage, 0, 0, null);
        }
        if (this.isLcdVisible()) {
            double UNIT_STRING_WIDTH;
            int offset = 0;
            if (this.isFrameVisible()) {
                offset = 18;
            }
            G2.drawImage((Image)this.lcdImage, offset, offset, null);
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                G2.setColor(this.getCustomLcdForeground());
            } else {
                G2.setColor(this.getLcdColor().TEXT_COLOR);
            }
            G2.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), G2.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                G2.drawString(this.getLcdUnitString(), (int)((double)this.lcdImage.getWidth() - this.UNIT_BOUNDARY.getWidth() - (double)((float)this.lcdImage.getWidth() * 0.03f)) + offset, (int)((float)this.lcdImage.getHeight() * 0.76f) + offset);
                UNIT_STRING_WIDTH = this.UNIT_BOUNDARY.getWidth();
            } else {
                UNIT_STRING_WIDTH = 0.0;
            }
            G2.setFont(this.getLcdValueFont());
            this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
            this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
            G2.drawString(this.formatLcdValue(this.getLcdValue()), (int)((double)this.lcdImage.getWidth() - UNIT_STRING_WIDTH - this.VALUE_BOUNDARY.getWidth() - (double)this.lcdImage.getWidth() * 0.09) + offset, (int)((float)this.lcdImage.getHeight() * 0.76f) + offset);
        }
        if (this.isForegroundVisible()) {
            G2.drawImage((Image)this.foregroundImage, 0, 0, null);
        }
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        G2.dispose();
    }

    @Override
    public boolean isLcdVisible() {
        return true;
    }

    @Override
    public void setValue(double VALUE) {
        this.setLcdValue(VALUE);
    }

    @Override
    public double getValue() {
        return this.getLcdValue();
    }

    @Override
    public boolean isValueCoupled() {
        return false;
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        Point2D.Double FOREGROUND_STOP;
        Point2D.Double FOREGROUND_START;
        int offset = 1;
        if (this.isFrameVisible()) {
            offset = 19;
        }
        if ((FOREGROUND_START = new Point2D.Double(0.0, offset)).equals(FOREGROUND_STOP = new Point2D.Double(0.0, this.getHeight() - offset))) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLORS[0], LCD_COLORS[1], LCD_COLORS[2], LCD_COLORS[3], LCD_COLORS[4]};
        return new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.backgroundImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.backgroundImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        int offset = 0;
        if (this.isFrameVisible()) {
            offset = 17;
        }
        return new Rectangle(offset, offset, this.lcdImage.getWidth(), this.lcdImage.getHeight());
    }

    @Override
    public String toString() {
        return "DisplayRectangular";
    }
}

