/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.GaugeType;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Model;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.PostPosition;
import eu.hansolo.steelseries.tools.Section;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Radial
extends AbstractRadial {
    private static final int BASE = 10;
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage glowImageOff;
    private BufferedImage glowImageOn;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage lcdThresholdImage;
    private BufferedImage disabledImage;
    private double angle;
    private final Point2D CENTER = new Point2D.Double();
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private boolean section3DEffectVisible;
    private RadialGradientPaint section3DEffect;
    private boolean area3DEffectVisible;
    private RadialGradientPaint area3DEffect;
    private final Point2D TRACK_OFFSET = new Point2D.Double();
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private double unitStringWidth;
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();
    private Area areaOfMeasuredValues;
    private Area lcdArea;

    public Radial() {
        this.angle = 0.0;
        this.section3DEffectVisible = false;
        this.area3DEffectVisible = false;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    public Radial(Model MODEL) {
        this.setModel(MODEL);
        this.angle = 0.0;
        this.section3DEffectVisible = false;
        this.area3DEffectVisible = false;
        this.areaOfMeasuredValues = new Area();
        this.lcdArea = new Area();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public final AbstractGauge init(int WIDTH, int HEIGHT) {
        int GAUGE_HEIGHT;
        int GAUGE_WIDTH = this.isFrameVisible() ? WIDTH : this.getGaugeBounds().width;
        int n = GAUGE_HEIGHT = this.isFrameVisible() ? HEIGHT : this.getGaugeBounds().height;
        if (GAUGE_WIDTH <= 1 || GAUGE_HEIGHT <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX() - (double)this.getInsets().left, this.getGaugeBounds().getCenterX() - (double)this.getInsets().top);
        if (this.isLcdVisible()) {
            if (this.isDigitalFont()) {
                this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * (float)GAUGE_WIDTH * 0.15f));
            } else {
                this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * (float)GAUGE_WIDTH * 0.15f));
            }
            if (this.isCustomLcdUnitFontEnabled()) {
                this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)GAUGE_WIDTH * 0.15f));
            } else {
                this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * (float)GAUGE_WIDTH * 0.15f));
            }
            this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * (float)GAUGE_WIDTH * 0.15f));
        }
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(GAUGE_WIDTH, GAUGE_WIDTH, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(GAUGE_WIDTH, GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(GAUGE_WIDTH, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(GAUGE_WIDTH, "", "", this.bImage);
        }
        if (this.isGlowVisible()) {
            if (this.glowImageOff != null) {
                this.glowImageOff.flush();
            }
            this.glowImageOff = this.create_GLOW_Image(GAUGE_WIDTH, this.getGlowColor(), false, this.getGaugeType(), true, this.getOrientation());
            if (this.glowImageOn != null) {
                this.glowImageOn.flush();
            }
            this.glowImageOn = this.create_GLOW_Image(GAUGE_WIDTH, this.getGlowColor(), true, this.getGaugeType(), true, this.getOrientation());
        } else {
            this.setGlowPulsating(false);
        }
        if (this.getPostsVisible()) {
            this.createPostsImage(GAUGE_WIDTH, this.fImage, this.getGaugeType().POST_POSITIONS);
        } else {
            this.createPostsImage(GAUGE_WIDTH, this.fImage, PostPosition.CENTER);
        }
        this.TRACK_OFFSET.setLocation(0.0, 0.0);
        if (this.isTrackVisible()) {
            this.create_TRACK_Image(GAUGE_WIDTH, this.getFreeAreaAngle(), this.getTickmarkOffset(), this.getMinValue(), this.getMaxValue(), this.getAngleStep(), this.getTrackStart(), this.getTrackSection(), this.getTrackStop(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), 0.38f, this.CENTER, this.getTickmarkDirection(), this.TRACK_OFFSET, this.bImage);
        }
        if (!this.getAreas().isEmpty()) {
            if (this.area3DEffectVisible) {
                this.area3DEffect = this.createArea3DEffectGradient(GAUGE_WIDTH, 0.38f);
            }
            this.createAreas(this.bImage);
        }
        if (!this.getSections().isEmpty()) {
            if (this.section3DEffectVisible) {
                this.section3DEffect = this.createSection3DEffectGradient(GAUGE_WIDTH, 0.38f);
            }
            this.createSections(this.bImage);
        }
        TICKMARK_FACTORY.create_RADIAL_TICKMARKS_Image(GAUGE_WIDTH, this.getModel().getNiceMinValue(), this.getModel().getNiceMaxValue(), this.getModel().getMaxNoOfMinorTicks(), this.getModel().getMaxNoOfMajorTicks(), this.getModel().getMinorTickSpacing(), this.getModel().getMajorTickSpacing(), this.getGaugeType(), this.getMinorTickmarkType(), this.getMajorTickmarkType(), this.isTickmarksVisible(), this.isTicklabelsVisible(), this.getModel().isMinorTickmarksVisible(), this.getModel().isMajorTickmarksVisible(), this.getLabelNumberFormat(), this.isTickmarkSectionsVisible(), this.getBackgroundColor(), this.getTickmarkColor(), this.isTickmarkColorFromThemeEnabled(), this.getTickmarkSections(), this.isSectionTickmarksOnly(), this.getSections(), 0.38f, 0.09f, this.CENTER, new Point2D.Double(0.0, 0.0), Orientation.NORTH, this.getModel().getTicklabelOrientation(), this.getModel().isNiceScale(), this.getModel().isLogScale(), this.bImage);
        this.create_TITLE_Image(GAUGE_WIDTH, this.getTitle(), this.getUnitString(), this.bImage);
        if (this.isLcdVisible()) {
            if (this.isLcdBackgroundVisible()) {
                this.createLcdImage(new Rectangle2D.Double(((double)this.getGaugeBounds().width - (double)GAUGE_WIDTH * this.getGaugeType().LCD_FACTORS.getX()) / 2.0, (double)this.getGaugeBounds().height * this.getGaugeType().LCD_FACTORS.getY(), (double)GAUGE_WIDTH * this.getGaugeType().LCD_FACTORS.getWidth(), (double)GAUGE_WIDTH * this.getGaugeType().LCD_FACTORS.getHeight()), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
            }
            this.LCD.setRect(((double)this.getGaugeBounds().width - (double)GAUGE_WIDTH * this.getGaugeType().LCD_FACTORS.getX()) / 2.0, (double)this.getGaugeBounds().height * this.getGaugeType().LCD_FACTORS.getY(), (double)GAUGE_WIDTH * this.getGaugeType().LCD_FACTORS.getWidth(), (double)GAUGE_WIDTH * this.getGaugeType().LCD_FACTORS.getHeight());
            this.lcdArea = new Area(this.LCD);
            if (this.lcdThresholdImage != null) {
                this.lcdThresholdImage.flush();
            }
            this.lcdThresholdImage = this.create_LCD_THRESHOLD_Image((int)(this.LCD.getHeight() * 0.2045454545), (int)(this.LCD.getHeight() * 0.2045454545), this.getLcdColor().TEXT_COLOR);
        }
        if (this.pointerImage != null) {
            this.pointerImage.flush();
        }
        this.pointerImage = this.create_POINTER_Image(GAUGE_WIDTH, this.getPointerType());
        if (this.pointerShadowImage != null) {
            this.pointerShadowImage.flush();
        }
        this.pointerShadowImage = this.getModel().isPointerShadowVisible() ? this.create_POINTER_SHADOW_Image(GAUGE_WIDTH, this.getPointerType()) : null;
        if (this.thresholdImage != null) {
            this.thresholdImage.flush();
        }
        this.thresholdImage = this.create_THRESHOLD_Image(GAUGE_WIDTH);
        if (this.minMeasuredImage != null) {
            this.minMeasuredImage.flush();
        }
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(GAUGE_WIDTH, new Color(0, 23, 252, 255));
        if (this.maxMeasuredImage != null) {
            this.maxMeasuredImage.flush();
        }
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(GAUGE_WIDTH, new Color(252, 29, 0, 255));
        if ((this.getGaugeType() == GaugeType.TYPE3 || this.getGaugeType() == GaugeType.TYPE4) && this.isLcdVisible()) {
            this.areaOfMeasuredValues = new Area(this.getModel().getRadialShapeOfMeasuredValues());
            this.areaOfMeasuredValues.subtract(this.lcdArea);
        } else {
            this.areaOfMeasuredValues = new Area(this.getModel().getRadialShapeOfMeasuredValues());
        }
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(GAUGE_WIDTH, GAUGE_WIDTH, false, this.fImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(GAUGE_WIDTH, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(GAUGE_WIDTH);
        this.setCurrentLedImage(this.getLedImageOff());
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform OLD_TRANSFORM = G2.getTransform();
        G2.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isRangeOfMeasuredValuesVisible()) {
            G2.setPaint(this.getModel().getRangeOfMeasuredValuesPaint());
            if ((this.getGaugeType() == GaugeType.TYPE3 || this.getGaugeType() == GaugeType.TYPE4) && this.isLcdVisible()) {
                Area area = this.getModel().getRadialAreaOfMeasuredValues();
                area.subtract(this.lcdArea);
                G2.fill(area);
            } else {
                G2.fill(this.getModel().getRadialShapeOfMeasuredValues());
            }
        }
        if (this.isHighlightArea()) {
            for (Section area : this.getAreas()) {
                if (!area.contains(this.getValue())) continue;
                G2.setColor(area.getHighlightColor());
                if ((this.getGaugeType() == GaugeType.TYPE3 || this.getGaugeType() == GaugeType.TYPE4) && this.isLcdVisible()) {
                    Area currentArea = new Area(area.getFilledArea());
                    currentArea.subtract(this.lcdArea);
                    G2.fill(currentArea);
                    break;
                }
                G2.fill(area.getFilledArea());
                break;
            }
        }
        if (this.isHighlightSection()) {
            for (Section section : this.getSections()) {
                if (!section.contains(this.getValue())) continue;
                G2.setColor(section.getHighlightColor());
                G2.fill(section.getSectionArea());
                break;
            }
        }
        if (this.isThresholdVisible()) {
            if (!this.isLogScale()) {
                G2.rotate(this.getRotationOffset() + (this.getThreshold() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                G2.rotate(this.getRotationOffset() + UTIL.logOfBase(10.0, this.getThreshold() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            G2.drawImage((Image)this.thresholdImage, (int)((double)this.getGaugeBounds().width * 0.4813084112), (int)((double)this.getGaugeBounds().height * 0.0841121495), null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isMinMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                G2.rotate(this.getRotationOffset() + (this.getMinMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                G2.rotate(this.getRotationOffset() + UTIL.logOfBase(10.0, this.getMinMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            G2.drawImage((Image)this.minMeasuredImage, (int)((double)this.getGaugeBounds().width * 0.4865), (int)((double)this.getGaugeBounds().height * 0.105), null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isMaxMeasuredValueVisible()) {
            if (!this.isLogScale()) {
                G2.rotate(this.getRotationOffset() + (this.getMaxMeasuredValue() - this.getMinValue()) * this.getAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            } else {
                G2.rotate(this.getRotationOffset() + UTIL.logOfBase(10.0, this.getMaxMeasuredValue() - this.getMinValue()) * this.getLogAngleStep(), this.CENTER.getX(), this.CENTER.getY());
            }
            G2.drawImage((Image)this.maxMeasuredImage, (int)((double)this.getGaugeBounds().width * 0.4865), (int)((double)this.getGaugeBounds().height * 0.105), null);
            G2.setTransform(OLD_TRANSFORM);
        }
        if (this.isLedVisible()) {
            G2.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.getGaugeBounds().width * this.getLedPosition().getX()), (int)((double)this.getGaugeBounds().height * this.getLedPosition().getY()), null);
        }
        if (this.isUserLedVisible()) {
            G2.drawImage((Image)this.getCurrentUserLedImage(), (int)((double)this.getGaugeBounds().width * this.getUserLedPosition().getX()), (int)((double)this.getGaugeBounds().height * this.getUserLedPosition().getY()), null);
        }
        if (this.isLcdVisible()) {
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                G2.setColor(this.getCustomLcdForeground());
            } else {
                G2.setColor(this.getLcdColor().TEXT_COLOR);
            }
            if (this.isLcdTextVisible()) {
                G2.setFont(this.getLcdUnitFont());
                if (this.isLcdUnitStringVisible()) {
                    this.unitLayout = new TextLayout(this.getLcdUnitString(), G2.getFont(), this.RENDER_CONTEXT);
                    this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                    G2.drawString(this.getLcdUnitString(), (int)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (int)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    this.unitStringWidth = this.UNIT_BOUNDARY.getWidth();
                } else {
                    this.unitStringWidth = 0.0;
                }
                G2.setFont(this.getLcdValueFont());
                switch (this.getModel().getNumberSystem()) {
                    case HEX: {
                        this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), G2.getFont(), this.RENDER_CONTEXT);
                        this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                        G2.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getHeight() * 0.333333333), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                        break;
                    }
                    case OCT: {
                        this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                        this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                        G2.drawString(Integer.toOctalString((int)this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getHeight() * 0.333333333), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                        break;
                    }
                    default: {
                        int digitalFontNo_1Offset = 0;
                        if (this.isDigitalFont() && Double.toString(this.getLcdValue()).startsWith("1")) {
                            digitalFontNo_1Offset = (int)(this.LCD.getHeight() * 0.2166666667);
                        }
                        this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), G2.getFont(), this.RENDER_CONTEXT);
                        this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                        G2.drawString(this.formatLcdValue(this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getHeight() * 0.333333333) - (float)digitalFontNo_1Offset, (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    }
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                G2.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), G2.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                G2.drawString(this.getLcdInfoString(), (float)this.LCD.getBounds().x + 5.0f, (float)this.LCD.getBounds().y + (float)this.INFO_BOUNDARY.getHeight() + 5.0f);
            }
            if (this.getLcdNumberSystem() == NumberSystem.DEC && this.isLcdThresholdVisible() && this.getLcdValue() >= this.getLcdThreshold()) {
                G2.drawImage((Image)this.lcdThresholdImage, (int)(this.LCD.getX() + this.LCD.getHeight() * 0.0568181818), (int)(this.LCD.getY() + this.LCD.getHeight() - (double)this.lcdThresholdImage.getHeight() - this.LCD.getHeight() * 0.0568181818), null);
            }
        }
        if (!this.isLogScale()) {
            this.angle = this.getRotationOffset() + (this.getValue() - this.getMinValue()) * this.getAngleStep();
            G2.rotate(this.angle + Math.cos(Math.toRadians(this.angle - this.getRotationOffset() - 91.5)), this.CENTER.getX(), this.CENTER.getY());
        } else {
            this.angle = this.getRotationOffset() + UTIL.logOfBase(10.0, this.getValue() - this.getMinValue()) * this.getLogAngleStep();
            G2.rotate(this.angle, this.CENTER.getX(), this.CENTER.getY() + 2.0);
        }
        G2.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.rotate(this.angle, this.CENTER.getX(), this.CENTER.getY());
        G2.drawImage((Image)this.pointerImage, 0, 0, null);
        G2.setTransform(OLD_TRANSFORM);
        G2.drawImage((Image)this.fImage, 0, 0, null);
        if (this.isGlowVisible()) {
            if (this.isGlowing()) {
                G2.setComposite(AlphaComposite.getInstance(3, this.getGlowAlpha()));
                G2.drawImage((Image)this.glowImageOn, 0, 0, null);
                G2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            } else {
                G2.drawImage((Image)this.glowImageOff, 0, 0, null);
            }
        }
        if (!this.isEnabled()) {
            G2.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        G2.dispose();
    }

    @Override
    public void setValue(double value) {
        if (this.isValueCoupled()) {
            this.setLcdValue(value);
        }
        super.setValue(value);
    }

    public boolean isSection3DEffectVisible() {
        return this.section3DEffectVisible;
    }

    public void setSection3DEffectVisible(boolean SECTION_3D_EFFECT_VISIBLE) {
        this.section3DEffectVisible = SECTION_3D_EFFECT_VISIBLE;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isArea3DEffectVisible() {
        return this.area3DEffectVisible;
    }

    public void setArea3DEffectVisible(boolean AREA_3DEFFECT_VISIBLE) {
        this.area3DEffectVisible = AREA_3DEFFECT_VISIBLE;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] LCD_COLORS) {
        Point2D.Double FOREGROUND_STOP;
        Point2D.Double FOREGROUND_START = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (FOREGROUND_START.equals(FOREGROUND_STOP = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)FOREGROUND_STOP).setLocation(0.0, ((Point2D)FOREGROUND_START).getY() + 1.0);
        }
        float[] FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] FOREGROUND_COLORS = new Color[]{LCD_COLORS[0], LCD_COLORS[1], LCD_COLORS[2], LCD_COLORS[3], LCD_COLORS[4]};
        return new LinearGradientPaint(FOREGROUND_START, FOREGROUND_STOP, FOREGROUND_FRACTIONS, FOREGROUND_COLORS);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    private void createAreas(BufferedImage IMAGE) {
        if (this.bImage != null) {
            double ANGLE_STEP = !this.isLogScale() ? Math.toDegrees(this.getGaugeType().ANGLE_RANGE) / (this.getMaxValue() - this.getMinValue()) : Math.toDegrees(this.getGaugeType().ANGLE_RANGE) / UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinValue());
            if (this.bImage != null && !this.getAreas().isEmpty()) {
                double OUTER_RADIUS = (float)this.bImage.getWidth() * 0.38f;
                double RADIUS = this.isSectionsVisible() ? (this.isExpandedSectionsEnabled() ? OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.12f) : OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.04f)) : OUTER_RADIUS;
                double FREE_AREA = (double)this.bImage.getWidth() / 2.0 - RADIUS;
                Rectangle2D.Double AREA_FRAME = new Rectangle2D.Double((double)this.bImage.getMinX() + FREE_AREA, (double)this.bImage.getMinY() + FREE_AREA, 2.0 * RADIUS, 2.0 * RADIUS);
                for (Section area : this.getAreas()) {
                    if (!this.isLogScale()) {
                        area.setFilledArea(new Arc2D.Double(AREA_FRAME, this.getGaugeType().ORIGIN_CORRECTION - area.getStart() * ANGLE_STEP + this.getMinValue() * ANGLE_STEP, -(area.getStop() - area.getStart()) * ANGLE_STEP, 2));
                        continue;
                    }
                    area.setFilledArea(new Arc2D.Double(AREA_FRAME, this.getGaugeType().ORIGIN_CORRECTION - UTIL.logOfBase(10.0, area.getStart()) * ANGLE_STEP + UTIL.logOfBase(10.0, this.getMinValue()) * ANGLE_STEP, -UTIL.logOfBase(10.0, area.getStop() - area.getStart()) * ANGLE_STEP, 2));
                }
            }
            if (this.isAreasVisible() && IMAGE != null) {
                Graphics2D G2 = IMAGE.createGraphics();
                G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section area : this.getAreas()) {
                    G2.setColor(this.isTransparentAreasEnabled() ? area.getTransparentColor() : area.getColor());
                    G2.fill(area.getFilledArea());
                    if (!this.area3DEffectVisible) continue;
                    G2.setPaint(this.area3DEffect);
                    G2.fill(area.getFilledArea());
                }
                G2.dispose();
            }
        }
    }

    private void createSections(BufferedImage IMAGE) {
        if (this.bImage != null) {
            double ANGLE_STEP = !this.isLogScale() ? this.getGaugeType().APEX_ANGLE / (this.getMaxValue() - this.getMinValue()) : this.getGaugeType().APEX_ANGLE / UTIL.logOfBase(10.0, this.getMaxValue() - this.getMinValue());
            double OUTER_RADIUS = (float)this.bImage.getWidth() * 0.38f;
            double INNER_RADIUS = this.isExpandedSectionsEnabled() ? OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.12f) : OUTER_RADIUS - (double)((float)this.bImage.getWidth() * 0.04f);
            double FREE_AREA_OUTER_RADIUS = (double)this.bImage.getWidth() / 2.0 - OUTER_RADIUS;
            double FREE_AREA_INNER_RADIUS = (double)this.bImage.getWidth() / 2.0 - INNER_RADIUS;
            Area INNER = new Area(new Ellipse2D.Double((double)this.bImage.getMinX() + FREE_AREA_INNER_RADIUS, (double)this.bImage.getMinY() + FREE_AREA_INNER_RADIUS, 2.0 * INNER_RADIUS, 2.0 * INNER_RADIUS));
            for (Section section : this.getSections()) {
                double ANGLE_EXTEND;
                double ANGLE_START;
                if (!this.isLogScale()) {
                    ANGLE_START = this.getGaugeType().ORIGIN_CORRECTION - section.getStart() * ANGLE_STEP + this.getMinValue() * ANGLE_STEP;
                    ANGLE_EXTEND = -(section.getStop() - section.getStart()) * ANGLE_STEP;
                } else {
                    ANGLE_START = this.getGaugeType().ORIGIN_CORRECTION - UTIL.logOfBase(10.0, section.getStart()) * ANGLE_STEP + UTIL.logOfBase(10.0, this.getMinValue()) * ANGLE_STEP;
                    ANGLE_EXTEND = -UTIL.logOfBase(10.0, section.getStop() - section.getStart()) * ANGLE_STEP;
                }
                Arc2D.Double OUTER_ARC = new Arc2D.Double(2);
                OUTER_ARC.setFrame((double)this.bImage.getMinX() + FREE_AREA_OUTER_RADIUS, (double)this.bImage.getMinY() + FREE_AREA_OUTER_RADIUS, 2.0 * OUTER_RADIUS, 2.0 * OUTER_RADIUS);
                ((Arc2D)OUTER_ARC).setAngleStart(ANGLE_START);
                ((Arc2D)OUTER_ARC).setAngleExtent(ANGLE_EXTEND);
                Area SECTION = new Area(OUTER_ARC);
                SECTION.subtract(INNER);
                section.setSectionArea(SECTION);
            }
            if (this.isSectionsVisible() && IMAGE != null) {
                Graphics2D G2 = IMAGE.createGraphics();
                G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (Section section : this.getSections()) {
                    G2.setColor(this.isTransparentSectionsEnabled() ? section.getTransparentColor() : section.getColor());
                    G2.fill(section.getSectionArea());
                    if (!this.section3DEffectVisible) continue;
                    G2.setPaint(this.section3DEffect);
                    G2.fill(section.getSectionArea());
                }
                G2.dispose();
            }
        }
    }

    @Override
    public String toString() {
        return "Radial " + (Object)((Object)this.getGaugeType());
    }
}

