/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ldmp;

import com.devexperts.logging.Logging;
import com.rusefi.ReaderProvider;
import com.rusefi.ReaderState;
import com.rusefi.ReaderStateImpl;
import com.rusefi.TriggerMetaGenerator;
import com.rusefi.ldmp.StateDictionaryGenerator;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.DataLogConsumer;
import com.rusefi.output.FileJavaFieldsConsumer;
import com.rusefi.output.FragmentDialogConsumer;
import com.rusefi.output.GaugeConsumer;
import com.rusefi.output.GetConfigValueConsumer;
import com.rusefi.output.GetOutputValueConsumer;
import com.rusefi.output.JavaSensorsConsumer;
import com.rusefi.output.OutputsSectionConsumer;
import com.rusefi.output.SdCardFieldsContent;
import com.rusefi.util.LazyFile;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

public class LiveDataProcessor {
    private static final Logging log = Logging.getLogging(LiveDataProcessor.class);
    private static final String header = "// generated by gen_live_documentation.sh / LiveDataProcessor.java\n";
    public static final String STATE_DICTIONARY_FACTORY_JAVA = "../java_console/io/src/main/java/com/rusefi/enums/StateDictionaryFactory.java";
    public static final String JAVA_DESTINATION = "../java_console/models/src/main/java/com/rusefi/config/generated/";
    private final ReaderProvider readerProvider;
    private final LazyFile.LazyFileFactory fileFactory;
    private final GaugeConsumer gaugeConsumer;
    private final String destinationFolder;
    private final StringBuilder enumContent = new StringBuilder("// generated by gen_live_documentation.sh / LiveDataProcessor.java\n#pragma once\n\n// this generated C header is mostly used as input for java code generation\ntypedef enum {\n");
    private final StringBuilder baseAddressCHeader = new StringBuilder();
    private final StringBuilder totalSensors = new StringBuilder();
    private final StringBuilder fancyNewStuff = new StringBuilder();
    public final StateDictionaryGenerator stateDictionaryGenerator;
    private final StringBuilder fancyNewMenu = new StringBuilder();
    private final StringBuilder fragmentsContent = new StringBuilder("// generated by gen_live_documentation.sh / LiveDataProcessor.java\n");
    private final String extraPrepend = System.getProperty("LiveDataProcessor.extra_prepend");

    public LiveDataProcessor(String yamlFileName, ReaderProvider readerProvider, LazyFile.LazyFileFactory fileFactory, String destinationFolder) {
        this.readerProvider = readerProvider;
        this.fileFactory = fileFactory;
        this.destinationFolder = destinationFolder;
        this.stateDictionaryGenerator = new StateDictionaryGenerator(yamlFileName);
        this.gaugeConsumer = new GaugeConsumer(this.getGauges(), fileFactory);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 5) {
            System.err.println("Five arguments expected: name of live data yaml input file and else but got " + args.length + ": " + Arrays.toString(args));
            System.exit(-1);
        }
        log.info("Invoked with " + Arrays.toString(args));
        String yamlFileNames = args[0];
        log.info("yamlFileNames=" + yamlFileNames);
        String definitionInputFileName = args[1];
        String headerFileName = args[2];
        String javaDestinationFileName = args[3];
        String destinationFolder = args[4];
        TriggerMetaGenerator.doJob(definitionInputFileName, headerFileName, javaDestinationFileName);
        ArrayList<LinkedHashMap> totalContent = new ArrayList<LinkedHashMap>();
        for (String fileName : yamlFileNames.split(",")) {
            ArrayList<LinkedHashMap> yamlContent = LiveDataProcessor.getStringObjectMap(new FileReader(fileName));
            totalContent.addAll(yamlContent);
        }
        LiveDataProcessor liveDataProcessor = new LiveDataProcessor(yamlFileNames, ReaderProvider.REAL, LazyFile.REAL, destinationFolder);
        int sensorTsPosition = liveDataProcessor.handleYaml(totalContent);
        liveDataProcessor.end(sensorTsPosition);
    }

    public static ArrayList<LinkedHashMap> getStringObjectMap(Reader reader) {
        Yaml yaml = new Yaml();
        Map objectMap = (Map)yaml.load(reader);
        Objects.requireNonNull(objectMap, "content of " + reader);
        if (objectMap.size() != 1) {
            throw new IllegalStateException("Exactly one top level key expected");
        }
        String key = (String)objectMap.keySet().iterator().next();
        ArrayList linkedHashMaps = (ArrayList)objectMap.get(key);
        log.info("Got " + linkedHashMaps.size() + " for " + key);
        return linkedHashMaps;
    }

    private String getTsOutputsDestination() {
        return this.destinationFolder + "console/binary/generated/";
    }

    public String getEnumContentFileName() {
        return this.getTsOutputsDestination() + "live_data_ids.h";
    }

    public String getGauges() {
        return this.getTsOutputsDestination() + "gauges.ini";
    }

    public String getDataFragmentsH() {
        return this.getTsOutputsDestination() + "live_data_fragments.h";
    }

    public String getFancyContentIni() {
        return this.getTsOutputsDestination() + "fancy_content.ini";
    }

    public String getFancyMenuIni() {
        return this.getTsOutputsDestination() + "fancy_menu.ini";
    }

    public String getDataLogFileName() {
        return this.getTsOutputsDestination() + "data_logs.ini";
    }

    public String getOutputsSectionFileName() {
        return this.getTsOutputsDestination() + "output_channels.ini";
    }

    private void end(int sensorTsPosition) throws IOException {
        log.info("TS_TOTAL_OUTPUT_SIZE=" + sensorTsPosition);
        try (FileWriter fw = new FileWriter(this.getTsOutputsDestination() + "total_live_data_generated.h");){
            fw.write(header);
            fw.write("#define TS_TOTAL_OUTPUT_SIZE " + sensorTsPosition);
        }
    }

    public int handleYaml(List<LinkedHashMap> liveDocs) throws IOException {
        final AtomicInteger startingPosition = new AtomicInteger();
        final OutputsSectionConsumer outputsSections = new OutputsSectionConsumer(this.getOutputsSectionFileName(), this.fileFactory);
        final DataLogConsumer dataLogConsumer = new DataLogConsumer(this.getDataLogFileName(), this.fileFactory);
        final SdCardFieldsContent sdCardFieldsConsumer = new SdCardFieldsContent();
        final GetOutputValueConsumer outputValueConsumer = new GetOutputValueConsumer("controllers/lua/generated/output_lookup_generated.cpp", this.fileFactory);
        EntryHandler handler = new EntryHandler(){

            @Override
            public void onEntry(String name, String javaName, String inFolder, String prepend, String[] outputNames, String[] constexpr, String conditional, String engineModule, Boolean isPtr, String cppFileName, String outFolder) throws IOException {
                Objects.requireNonNull(outFolder);
                if (constexpr != null && outputNames.length != constexpr.length) {
                    throw new IllegalStateException(Arrays.toString(outputNames) + " vs " + Arrays.toString(constexpr));
                }
                LiveDataProcessor.this.stateDictionaryGenerator.onEntry(name, javaName, outputNames, cppFileName);
                log.info("Starting " + name + " at " + startingPosition + " with [" + conditional + "]");
                LiveDataProcessor.this.baseAddressCHeader.append("#define " + name.toUpperCase() + "_BASE_ADDRESS " + startingPosition + "\n");
                ReaderStateImpl state = new ReaderStateImpl(LiveDataProcessor.this.readerProvider, LiveDataProcessor.this.fileFactory);
                state.setDefinitionInputFile(inFolder + File.separator + name + ".txt");
                state.setWithC_Defines(false);
                outputsSections.outputNames = outputNames;
                dataLogConsumer.outputNames = outputNames;
                ((LiveDataProcessor)LiveDataProcessor.this).gaugeConsumer.outputNames = outputNames;
                ArrayList<JavaSensorsConsumer> javaSensorsConsumers = new ArrayList<JavaSensorsConsumer>();
                for (int i = 0; i < outputNames.length; ++i) {
                    JavaSensorsConsumer javaSensorsConsumer = new JavaSensorsConsumer(startingPosition.get());
                    state.addDestination(javaSensorsConsumer);
                    javaSensorsConsumers.add(javaSensorsConsumer);
                }
                state.addDestination(outputsSections, dataLogConsumer);
                ArrayList<FragmentDialogConsumer> fragmentConsumers = new ArrayList<FragmentDialogConsumer>();
                for (int i = 0; i < outputNames.length; ++i) {
                    String variableNameSuffix = outputNames.length > 1 ? Integer.toString(i) : "";
                    FragmentDialogConsumer fragmentDialogConsumer = new FragmentDialogConsumer(name, variableNameSuffix);
                    fragmentConsumers.add(fragmentDialogConsumer);
                    state.addDestination(fragmentDialogConsumer);
                }
                if (LiveDataProcessor.this.extraPrepend != null) {
                    if (new File(LiveDataProcessor.this.extraPrepend).exists()) {
                        log.info("extraPrepend=" + LiveDataProcessor.this.extraPrepend);
                        state.addPrepend(LiveDataProcessor.this.extraPrepend);
                    } else {
                        log.info("extraPrepend=" + LiveDataProcessor.this.extraPrepend + " does not exist, skipping");
                    }
                }
                state.addPrepend(prepend);
                state.addCHeaderDestination(outFolder + File.separator + name + "_generated.h");
                sdCardFieldsConsumer.structureStartingTsPosition = outputsSections.getBaseOffset();
                state.addDestination(new FileJavaFieldsConsumer(state, LiveDataProcessor.JAVA_DESTINATION + javaName, outputsSections.getBaseOffset(), LiveDataProcessor.this.fileFactory));
                if (constexpr != null) {
                    sdCardFieldsConsumer.expressions = constexpr;
                    sdCardFieldsConsumer.names = outputNames;
                    sdCardFieldsConsumer.conditional = conditional;
                    sdCardFieldsConsumer.isPtr = isPtr;
                    ConfigurationConsumer[] configurationConsumerArray = new ConfigurationConsumer[1];
                    configurationConsumerArray[0] = sdCardFieldsConsumer::handleEndStruct;
                    state.addDestination(configurationConsumerArray);
                    outputValueConsumer.currentSectionPrefix = constexpr[0];
                    outputValueConsumer.moduleMode = false;
                    outputValueConsumer.conditional = conditional;
                    outputValueConsumer.isPtr = isPtr;
                    ConfigurationConsumer[] configurationConsumerArray2 = new ConfigurationConsumer[1];
                    configurationConsumerArray2[0] = outputValueConsumer::handleEndStruct;
                    state.addDestination(configurationConsumerArray2);
                } else if (engineModule != null) {
                    outputValueConsumer.currentEngineModule = engineModule;
                    outputValueConsumer.moduleMode = true;
                    outputValueConsumer.conditional = conditional;
                    outputValueConsumer.isPtr = isPtr;
                    ConfigurationConsumer[] configurationConsumerArray = new ConfigurationConsumer[1];
                    configurationConsumerArray[0] = outputValueConsumer::handleEndStruct;
                    state.addDestination(configurationConsumerArray);
                }
                state.addDestination(new ConfigurationConsumer(){

                    @Override
                    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
                        LiveDataProcessor.this.gaugeConsumer.handleEndStruct(readerState, structure);
                    }
                });
                state.doJob();
                for (FragmentDialogConsumer fragmentDialogConsumer : fragmentConsumers) {
                    LiveDataProcessor.this.fancyNewStuff.append(fragmentDialogConsumer.getContent());
                    LiveDataProcessor.this.fancyNewMenu.append(fragmentDialogConsumer.menuLine());
                }
                for (JavaSensorsConsumer javaSensorsConsumer : javaSensorsConsumers) {
                    LiveDataProcessor.this.totalSensors.append(javaSensorsConsumer.getContent());
                    startingPosition.addAndGet(javaSensorsConsumer.getStructSize());
                }
                log.info("Done with " + name + " at " + startingPosition);
            }
        };
        for (LinkedHashMap entry : liveDocs) {
            int i;
            String[] constexpr;
            String name = (String)entry.get("name");
            String java = (String)entry.get("java");
            String inputOutputFolder = (String)entry.get("folder");
            String inputFolder = (String)entry.get("input_folder");
            String prepend = (String)entry.get("prepend");
            Object constexprValue = entry.get("constexpr");
            String engineModule = (String)entry.get("engineModule");
            String cppFileName = (String)entry.get("cppFileName");
            if (cppFileName == null) {
                cppFileName = name;
            }
            String conditional = (String)entry.get("conditional_compilation");
            Boolean isPtr = (Boolean)entry.get("isPtr");
            isPtr = isPtr != null && isPtr != false;
            Object outputNames = entry.get("output_name");
            String[] outputNamesArr = LiveDataProcessor.getStrings(outputNames);
            String[] stringArray = constexpr = constexprValue == null ? null : LiveDataProcessor.getStrings(constexprValue);
            if (inputFolder != null) {
                log.info("Only inputFolder " + inputFolder);
            } else {
                log.info("Common inputOutputFolder " + inputOutputFolder);
                inputFolder = inputOutputFolder;
            }
            handler.onEntry(name, java, inputFolder, prepend, outputNamesArr, constexpr, conditional, engineModule, isPtr, cppFileName, "live_data_generated");
            String enumName = "LDS_" + name;
            String type = name + "_s";
            if (outputNamesArr.length < 2) {
                this.enumContent.append(enumName + ",\n");
                this.fragmentsContent.append("decl_frag<").append(type).append(">{},\n");
                continue;
            }
            for (i = 0; i < outputNamesArr.length; ++i) {
                this.enumContent.append(enumName + i + ",\n");
            }
            for (i = 0; i < outputNamesArr.length; ++i) {
                if (LiveDataProcessor.needComment(i)) {
                    this.fragmentsContent.append("// ");
                }
                this.fragmentsContent.append("decl_frag<").append(type).append(", ").append(i).append(">{},\t// ").append(outputNamesArr[i]).append("\n");
            }
        }
        this.enumContent.append("} live_data_e;\n");
        LazyFile lazyFile = this.fileFactory.create(this.destinationFolder + "console/binary_log/log_fields_generated.h");
        SdCardFieldsContent.wrapContent(lazyFile, sdCardFieldsConsumer.getBody());
        lazyFile.close();
        dataLogConsumer.endFile();
        outputValueConsumer.endFile();
        try (LazyFile fw = this.fileFactory.create("console/binary/generated/sensors.java");){
            fw.write(this.totalSensors.toString());
        }
        fw = this.fileFactory.create(this.getFancyContentIni());
        try {
            fw.write(this.fancyNewStuff.toString());
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
        fw = this.fileFactory.create(this.getFancyMenuIni());
        try {
            fw.write(this.fancyNewMenu.toString());
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
        GetConfigValueConsumer.writeStringToFile(STATE_DICTIONARY_FACTORY_JAVA, this.stateDictionaryGenerator.getCompleteClass(), this.fileFactory);
        this.writeFiles();
        return startingPosition.get();
    }

    private static String @NotNull [] getStrings(Object value) {
        String[] output;
        if (value == null) {
            output = new String[]{""};
        } else if (value instanceof String) {
            output = new String[]{(String)value};
        } else {
            ArrayList nameList = (ArrayList)value;
            output = new String[nameList.size()];
            nameList.toArray(output);
        }
        return output;
    }

    private void writeFiles() throws IOException {
        this.gaugeConsumer.endFile();
        try (LazyFile fw = this.fileFactory.create(this.getEnumContentFileName());){
            fw.write(this.enumContent.toString());
            fw.write(this.baseAddressCHeader.toString());
        }
        fw = this.fileFactory.create(this.getDataFragmentsH());
        try {
            fw.write(this.fragmentsContent.toString());
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    public static boolean needComment(int index) {
        return false;
    }

    static interface EntryHandler {
        public void onEntry(String var1, String var2, String var3, String var4, String[] var5, String[] var6, String var7, String var8, Boolean var9, String var10, String var11) throws IOException;
    }
}

