/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.opensr5.ini.field.IniField;
import com.rusefi.ConfigField;
import com.rusefi.ConfigFieldImpl;
import com.rusefi.ReaderState;
import com.rusefi.TokenUtils;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.FieldIterator;
import com.rusefi.output.FieldsStrategy;
import com.rusefi.output.JavaSensorsConsumer;
import com.rusefi.parse.Type;
import com.rusefi.parse.TypesHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class TsOutput {
    private final StringBuilder settingContextHelp = new StringBuilder();
    private final boolean isConstantsSection;
    private final StringBuilder tsHeader = new StringBuilder();
    private final TreeSet<String> usedNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);

    public TsOutput(boolean longForm) {
        this.isConstantsSection = longForm;
    }

    public String getContent() {
        return this.tsHeader.toString();
    }

    public String getSettingContextHelp() {
        return this.settingContextHelp.toString();
    }

    public int run(ReaderState state, ConfigStructure structure, int structureStartingTsPosition, final String temporaryLineComment, final String variableNameSuffix) {
        FieldsStrategy strategy = new FieldsStrategy(){

            @Override
            public int writeOneField(FieldIterator it, String prefix, int tsPosition) {
                ConfigField configField = it.cf;
                ConfigField next = it.next;
                int bitIndex = it.bitState.get();
                String nameWithPrefix = prefix + configField.getName() + variableNameSuffix;
                if (!(TsOutput.this.usedNames.add(nameWithPrefix) || TsOutput.this.isConstantsSection || configField.isUnusedField())) {
                    throw new IllegalStateException(nameWithPrefix + " already present: " + configField);
                }
                if (configField.getName().startsWith("alignmentFill_at_")) {
                    return it.adjustSize(tsPosition);
                }
                if (configField.isDirective() && configField.getComment() != null) {
                    TsOutput.this.tsHeader.append(configField.getComment());
                    TsOutput.this.tsHeader.append("\n");
                    return tsPosition;
                }
                ConfigStructure cs = configField.getStructureType();
                if (configField.getComment() != null && configField.getComment().trim().length() > 0 && cs == null) {
                    String commentContent = configField.getCommentTemplated();
                    commentContent = ConfigFieldImpl.unquote(commentContent);
                    TsOutput.this.settingContextHelp.append(temporaryLineComment + "\t" + nameWithPrefix + " = " + JavaSensorsConsumer.quote(commentContent) + "\n");
                }
                if (cs != null) {
                    String extraPrefix = cs.isWithPrefix() ? configField.getName() + "_" : "";
                    return this.writeFields(cs.getTsFields(), prefix + extraPrefix, tsPosition);
                }
                if (configField.isBit()) {
                    if (!configField.getName().startsWith("unusedBit_")) {
                        TsOutput.this.tsHeader.append(temporaryLineComment + nameWithPrefix + " = bits, U32,");
                        TsOutput.this.tsHeader.append(" " + tsPosition + ", [");
                        TsOutput.this.tsHeader.append(bitIndex + ":" + bitIndex);
                        TsOutput.this.tsHeader.append("]");
                        if (TsOutput.this.isConstantsSection) {
                            TsOutput.this.tsHeader.append(", \"" + configField.getFalseName() + "\", \"" + configField.getTrueName() + "\"");
                        }
                        TsOutput.this.tsHeader.append("\n");
                    }
                    return it.adjustSize(tsPosition);
                }
                if (configField.getState().getTsCustomLine().containsKey(configField.getTypeName())) {
                    String bits = configField.getState().getTsCustomLine().get(configField.getTypeName());
                    if (!bits.startsWith("bits")) {
                        bits = TsOutput.this.handleTsInfo(configField, bits, 5);
                    }
                    bits = bits.replaceAll("@OFFSET@", "" + tsPosition);
                    TsOutput.this.tsHeader.append(nameWithPrefix + " = " + bits);
                    if (!configField.getName().equals(next.getName())) {
                        tsPosition += configField.getState().getTsCustomSize().get(configField.getTypeName()).intValue();
                    }
                } else if (configField.getArraySizes().length == 0) {
                    TsOutput.this.tsHeader.append(temporaryLineComment + nameWithPrefix + " = scalar, ");
                    TsOutput.this.tsHeader.append(TypesHelper.convertToTs(configField.getTypeName()) + ",");
                    TsOutput.this.tsHeader.append(" " + tsPosition + ",");
                    TsOutput.this.tsHeader.append(" " + TsOutput.this.handleTsInfo(configField, configField.getTsInfo(), 1));
                    if (!configField.getName().equals(next.getName())) {
                        tsPosition += configField.getSize(next);
                    }
                } else if (configField.getSize(next) != 0) {
                    TsOutput.this.tsHeader.append(nameWithPrefix + " = array, ");
                    TsOutput.this.tsHeader.append(TypesHelper.convertToTs(configField.getTypeName()) + ",");
                    TsOutput.this.tsHeader.append(" " + tsPosition + ",");
                    TsOutput.this.tsHeader.append(" [");
                    boolean first = true;
                    List list = Arrays.stream(configField.getArraySizes()).boxed().collect(Collectors.toList());
                    Collections.reverse(list);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        int size = (Integer)iterator.next();
                        if (first) {
                            first = false;
                        } else {
                            TsOutput.this.tsHeader.append("x");
                        }
                        TsOutput.this.tsHeader.append(size);
                    }
                    TsOutput.this.tsHeader.append("], " + TsOutput.this.handleTsInfo(configField, configField.getTsInfo(), 1));
                    if (!configField.getName().equals(next.getName())) {
                        tsPosition += configField.getSize(next);
                    }
                }
                TsOutput.this.tsHeader.append("\n");
                return tsPosition;
            }
        };
        structureStartingTsPosition = strategy.run(state, structure, structureStartingTsPosition);
        if (state.isStackEmpty()) {
            this.tsHeader.append("; total TS size = " + structureStartingTsPosition + "\n");
        }
        return structureStartingTsPosition;
    }

    private String handleTsInfo(ConfigField configField, String tsInfo, int multiplierIndex) {
        if (tsInfo == null || tsInfo.trim().isEmpty()) {
            if (this.isConstantsSection) {
                if (configField.getTypeName().equalsIgnoreCase(Type.U16.cType) || configField.getTypeName().equalsIgnoreCase(Type.S16.cType)) {
                    return JavaSensorsConsumer.quote("") + ", 1, 0, 0, 32000, 0";
                }
                return JavaSensorsConsumer.quote("") + ", 1, 0, 0, 100, 0";
            }
            return JavaSensorsConsumer.quote("") + ", 1, 0";
        }
        try {
            String[] fields = TokenUtils.tokenizeWithBraces(tsInfo);
            if (fields.length > multiplierIndex) {
                double val = IniField.parseDouble(fields[multiplierIndex]);
                fields[multiplierIndex] = val == 0.0 ? " 0" : (val == 1.0 ? " 1" : " " + val);
            }
            StringBuilder sb = new StringBuilder();
            if (!this.isConstantsSection) {
                String[] subarray = new String[3];
                System.arraycopy(fields, 0, subarray, 0, subarray.length);
                fields = subarray;
            }
            for (String f : fields) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(f);
            }
            return sb.toString();
        }
        catch (Throwable e) {
            throw new IllegalStateException("While parsing [" + tsInfo + "] of " + configField, e);
        }
    }
}

