/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.DataLogConsumer;
import com.rusefi.output.JavaSensorsConsumer;
import com.rusefi.output.PerFieldWithStructuresIterator;
import com.rusefi.util.LazyFile;
import java.io.IOException;

public class SdCardFieldsContent {
    public static final String SD_CARD_OUTPUT_FILE_NAME = "console/binary_log/log_fields_generated.h";
    public static final String BOARD_LOOKUP_H = "#include \"board_lookup.h\"\n";
    private final StringBuilder body = new StringBuilder();
    public String[] expressions = new String[]{"test->reference"};
    public String conditional;
    public Boolean isPtr = false;
    public String[] names;
    public int structureStartingTsPosition;

    public static void wrapContent(LazyFile output, String content) {
        output.write("// generated by " + SdCardFieldsContent.class + "\n");
        output.write(BOARD_LOOKUP_H);
        output.write("static const LogField fields[] = {\n{packedTime, GAUGE_NAME_TIME, \"sec\", 0},\n");
        output.write(content);
        output.write("};\n");
    }

    public void handleEndStruct(ReaderState state, ConfigStructure structure) throws IOException {
        if (state.isStackEmpty()) {
            for (int i = 0; i < this.expressions.length; ++i) {
                String namePrefix = this.names == null || this.names.length <= 1 ? "" : this.names[i];
                String expression = this.expressions[i];
                this.appendFields(state, structure, namePrefix, expression);
            }
        }
    }

    private void appendFields(ReaderState state, ConfigStructure structure, final String namePrefix, final String expression) {
        PerFieldWithStructuresIterator.Strategy strategy = new PerFieldWithStructuresIterator.Strategy(){

            @Override
            public String process(ReaderState state, ConfigField configField, String prefix, int currentPosition, PerFieldWithStructuresIterator perFieldWithStructuresIterator) {
                return SdCardFieldsContent.this.processOutput(configField, prefix, currentPosition, perFieldWithStructuresIterator, namePrefix, expression);
            }

            @Override
            public String getArrayElementName(ConfigField cf) {
                return cf.getOriginalArrayName();
            }
        };
        PerFieldWithStructuresIterator iterator = new PerFieldWithStructuresIterator(state, structure.getTsFields(), "", strategy, ".");
        this.structureStartingTsPosition = iterator.loop(this.structureStartingTsPosition);
        String content = iterator.getContent();
        this.body.append(content);
    }

    private String processOutput(ConfigField configField, String prefix, int currentPosition, PerFieldWithStructuresIterator perFieldWithStructuresIterator, String namePrefix, String expression) {
        if (configField.isUnusedField()) {
            return "";
        }
        String name = configField.getOriginalArrayName();
        return SdCardFieldsContent.getLine(configField, prefix, namePrefix, prefix + name, expression, this.isPtr, this.conditional, currentPosition, perFieldWithStructuresIterator, this.structureStartingTsPosition);
    }

    private static String getLine(ConfigField configField, String prefix, String namePrefix, String name, String expression, Boolean isPtr, String conditional, int currentPosition, PerFieldWithStructuresIterator perFieldWithStructuresIterator, int structureStartingTsPosition) {
        String after;
        String humanName = DataLogConsumer.getHumanGaugeName("", prefix, configField, namePrefix);
        String categoryStr = configField.getCategory();
        categoryStr = categoryStr == null ? "" : ", " + categoryStr;
        boolean isEnum = configField.getTypeName().contains("_e");
        if (isEnum) {
            return "";
        }
        String before = conditional == null ? "" : "#if " + conditional + "\n";
        String string = after = conditional == null ? "" : "#endif\n";
        if (configField.isBit()) {
            int offsetWithinCurrentStructure = currentPosition - structureStartingTsPosition;
            if (offsetWithinCurrentStructure < 0) {
                throw new IllegalStateException(humanName + " seems broken: " + currentPosition + " vs " + structureStartingTsPosition);
            }
            return before + "\t{" + (isPtr != false ? "*" : "") + expression + ", " + offsetWithinCurrentStructure + ", " + perFieldWithStructuresIterator.bitState.get() + ", " + humanName + ", " + JavaSensorsConsumer.quote(configField.getUnits()) + categoryStr + "},\n" + after;
        }
        return before + "\t{" + expression + (isPtr != false ? "->" : ".") + name + ", " + humanName + ", " + JavaSensorsConsumer.quote(configField.getUnits()) + ", " + configField.getDigits() + categoryStr + "},\n" + after;
    }

    public String getBody() {
        return this.body.toString();
    }
}

